///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                     LibXL C headers version 5.0.1                         //
//                                                                           //
//                 Copyright (c) 2008 - 2025 XLware s.r.o.                   //
//                                                                           //
//   THIS FILE AND THE SOFTWARE CONTAINED HEREIN IS PROVIDED 'AS IS' AND     //
//                COMES WITH NO WARRANTIES OF ANY KIND.                      //
//                                                                           //
//          Please define LIBXL_STATIC variable for static linking.          //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef LIBXL_C_H
#define LIBXL_C_H

#define LIBXL_VERSION 0x05000100

#ifdef _UNICODE

    #include "BookW.h"
    #include "SheetW.h"
    #include "FormatW.h"
    #include "FontW.h"
    #include "AutoFilterW.h"
    #include "FilterColumnW.h"
    #include "RichStringW.h"
    #include "ConditionalFormatW.h"
    #include "ConditionalFormattingW.h"
    #include "CorePropertiesW.h"
    #include "FormControlW.h"
    #include "TableW.h"

    #define xlCreateBook xlCreateBookCW
    #define xlCreateXMLBook xlCreateXMLBookCW
    #define xlBookLoad xlBookLoadW
    #define xlBookSave xlBookSaveW
    #define xlBookLoadUsingTempFile xlBookLoadUsingTempFileW
    #define xlBookSaveUsingTempFile xlBookSaveUsingTempFileW
    #define xlBookLoadPartially xlBookLoadPartiallyW
    #define xlBookLoadPartiallyUsingTempFile xlBookLoadPartiallyUsingTempFileW
    #define xlBookLoadWithoutEmptyCells xlBookLoadWithoutEmptyCellsW
    #define xlBookLoadInfo xlBookLoadInfoW
    #define xlBookLoadInfoRaw xlBookLoadInfoRawW
    #define xlBookLoadRaw xlBookLoadRawW
    #define xlBookLoadRawPartially xlBookLoadRawPartiallyW
    #define xlBookSaveRaw xlBookSaveRawW
    #define xlBookSetPassword xlBookSetPasswordW
    #define xlBookAddSheet xlBookAddSheetW
    #define xlBookInsertSheet xlBookInsertSheetW
    #define xlBookGetSheet xlBookGetSheetW
    #define xlBookGetSheetName xlBookGetSheetNameW
    #define xlBookSheetType xlBookSheetTypeW
    #define xlBookMoveSheet xlBookMoveSheetW
    #define xlBookDelSheet xlBookDelSheetW
    #define xlBookSheetCount xlBookSheetCountW
    #define xlBookAddFormat xlBookAddFormatW
    #define xlBookAddFormatFromStyle xlBookAddFormatFromStyleW
    #define xlBookAddFont xlBookAddFontW
    #define xlBookAddRichString xlBookAddRichStringW
    #define xlBookAddCustomNumFormat xlBookAddCustomNumFormatW
    #define xlBookCustomNumFormat xlBookCustomNumFormatW
    #define xlBookFormat xlBookFormatW
    #define xlBookFormatSize xlBookFormatSizeW
    #define xlBookFont xlBookFontW
    #define xlBookFontSize xlBookFontSizeW
    #define xlBookAddConditionalFormat xlBookAddConditionalFormatW
    #define xlBookDatePack xlBookDatePackW
    #define xlBookDateUnpack xlBookDateUnpackW
    #define xlBookColorPack xlBookColorPackW
    #define xlBookColorUnpack xlBookColorUnpackW
    #define xlBookActiveSheet xlBookActiveSheetW
    #define xlBookSetActiveSheet xlBookSetActiveSheetW
    #define xlBookPictureSize xlBookPictureSizeW
    #define xlBookGetPicture xlBookGetPictureW
    #define xlBookAddPicture xlBookAddPictureW
    #define xlBookAddPicture2 xlBookAddPicture2W
    #define xlBookAddPictureAsLink xlBookAddPictureAsLinkW
    #define xlBookDefaultFont xlBookDefaultFontW
    #define xlBookSetDefaultFont xlBookSetDefaultFontW
    #define xlBookSetKey xlBookSetKeyW
    #define xlBookRefR1C1 xlBookRefR1C1W
    #define xlBookSetRefR1C1 xlBookSetRefR1C1W
    #define xlBookRgbMode xlBookRgbModeW
    #define xlBookSetRgbMode xlBookSetRgbModeW
    #define xlBookCalcMode xlBookCalcModeW
    #define xlBookSetCalcMode xlBookSetCalcModeW
    #define xlBookVersion xlBookVersionW
    #define xlBookBiffVersion xlBookBiffVersionW
    #define xlBookIsDate1904 xlBookIsDate1904W
    #define xlBookSetDate1904 xlBookSetDate1904W
    #define xlBookIsTemplate xlBookIsTemplateW
    #define xlBookSetTemplate xlBookSetTemplateW
    #define xlBookIsWriteProtected xlBookIsWriteProtectedW
    #define xlBookCoreProperties xlBookCorePropertiesW
    #define xlBookSetLocale xlBookSetLocaleW
    #define xlBookRemoveVBA xlBookRemoveVBAW
    #define xlBookRemovePrinterSettings xlBookRemovePrinterSettingsW
    #define xlBookRemoveAllPhonetics xlBookRemoveAllPhoneticsW
    #define xlBookErrorMessage xlBookErrorMessageW
    #define xlBookRelease xlBookReleaseW

    #define xlSheetCellType xlSheetCellTypeW
    #define xlSheetCellFormat xlSheetCellFormatW
    #define xlSheetSetCellFormat xlSheetSetCellFormatW
    #define xlSheetIsFormula xlSheetIsFormulaW
    #define xlSheetReadStr xlSheetReadStrW
    #define xlSheetWriteStr xlSheetWriteStrW
    #define xlSheetWriteStrAsNum xlSheetWriteStrAsNumW
    #define xlSheetReadRichStr xlSheetReadRichStrW
    #define xlSheetWriteRichStr xlSheetWriteRichStrW
    #define xlSheetReadNum xlSheetReadNumW
    #define xlSheetWriteNum xlSheetWriteNumW
    #define xlSheetReadBool xlSheetReadBoolW
    #define xlSheetWriteBool xlSheetWriteBoolW
    #define xlSheetReadBlank xlSheetReadBlankW
    #define xlSheetWriteBlank xlSheetWriteBlankW
    #define xlSheetReadFormula xlSheetReadFormulaW
    #define xlSheetWriteFormula xlSheetWriteFormulaW
    #define xlSheetWriteFormulaNum xlSheetWriteFormulaNumW
    #define xlSheetWriteFormulaStr xlSheetWriteFormulaStrW
    #define xlSheetWriteFormulaBool xlSheetWriteFormulaBoolW
    #define xlSheetReadComment xlSheetReadCommentW
    #define xlSheetWriteComment xlSheetWriteCommentW
    #define xlSheetRemoveComment xlSheetRemoveCommentW
    #define xlSheetIsDate xlSheetIsDateW
    #define xlSheetIsRichStr xlSheetIsRichStrW
    #define xlSheetReadError xlSheetReadErrorW
    #define xlSheetWriteError xlSheetWriteErrorW
    #define xlSheetColWidth xlSheetColWidthW
    #define xlSheetRowHeight xlSheetRowHeightW
    #define xlSheetColWidthPx xlSheetColWidthPxW
    #define xlSheetRowHeightPx xlSheetRowHeightPxW
    #define xlSheetColFormat xlSheetColFormatW
    #define xlSheetRowFormat xlSheetRowFormatW
    #define xlSheetSetCol xlSheetSetColW
    #define xlSheetSetColPx xlSheetSetColPxW
    #define xlSheetSetRow xlSheetSetRowW
    #define xlSheetSetRowPx xlSheetSetRowPxW
    #define xlSheetRowHidden xlSheetRowHiddenW
    #define xlSheetSetRowHidden xlSheetSetRowHiddenW
    #define xlSheetColHidden xlSheetColHiddenW
    #define xlSheetSetColHidden xlSheetSetColHiddenW
    #define xlSheetDefaultRowHeight xlSheetDefaultRowHeightW
    #define xlSheetSetDefaultRowHeight xlSheetSetDefaultRowHeightW
    #define xlSheetGetMerge xlSheetGetMergeW
    #define xlSheetSetMerge xlSheetSetMergeW
    #define xlSheetDelMerge xlSheetDelMergeW
    #define xlSheetMergeSize xlSheetMergeSizeW
    #define xlSheetMerge xlSheetMergeW
    #define xlSheetDelMergeByIndex xlSheetDelMergeByIndexW
    #define xlSheetPictureSize xlSheetPictureSizeW
    #define xlSheetGetPicture xlSheetGetPictureW
    #define xlSheetRemovePictureByIndex xlSheetRemovePictureByIndexW
    #define xlSheetSetPicture xlSheetSetPictureW
    #define xlSheetSetPicture2 xlSheetSetPicture2W
    #define xlSheetRemovePicture xlSheetRemovePictureW
    #define xlSheetGetHorPageBreak xlSheetGetHorPageBreakW
    #define xlSheetGetHorPageBreakSize xlSheetGetHorPageBreakSizeW
    #define xlSheetGetVerPageBreak xlSheetGetVerPageBreakW
    #define xlSheetGetVerPageBreakSize xlSheetGetVerPageBreakSizeW
    #define xlSheetSetHorPageBreak xlSheetSetHorPageBreakW
    #define xlSheetSetVerPageBreak xlSheetSetVerPageBreakW
    #define xlSheetSplit xlSheetSplitW
    #define xlSheetSplitInfo xlSheetSplitInfoW
    #define xlSheetGroupRows xlSheetGroupRowsW
    #define xlSheetGroupCols xlSheetGroupColsW
    #define xlSheetGroupSummaryBelow xlSheetGroupSummaryBelowW
    #define xlSheetSetGroupSummaryBelow xlSheetSetGroupSummaryBelowW
    #define xlSheetGroupSummaryRight xlSheetGroupSummaryRightW
    #define xlSheetSetGroupSummaryRight xlSheetSetGroupSummaryRightW
    #define xlSheetClear xlSheetClearW
    #define xlSheetInsertCol xlSheetInsertColW
    #define xlSheetInsertRow xlSheetInsertRowW
    #define xlSheetRemoveCol xlSheetRemoveColW
    #define xlSheetRemoveRow xlSheetRemoveRowW
    #define xlSheetInsertColAndKeepRanges xlSheetInsertColAndKeepRangesW
    #define xlSheetInsertRowAndKeepRanges xlSheetInsertRowAndKeepRangesW
    #define xlSheetRemoveColAndKeepRanges xlSheetRemoveColAndKeepRangesW
    #define xlSheetRemoveRowAndKeepRanges xlSheetRemoveRowAndKeepRangesW
    #define xlSheetCopyCell xlSheetCopyCellW
    #define xlSheetFirstRow xlSheetFirstRowW
    #define xlSheetLastRow xlSheetLastRowW
    #define xlSheetFirstCol xlSheetFirstColW
    #define xlSheetLastCol xlSheetLastColW
    #define xlSheetFirstFilledRow xlSheetFirstFilledRowW
    #define xlSheetLastFilledRow xlSheetLastFilledRowW
    #define xlSheetFirstFilledCol xlSheetFirstFilledColW
    #define xlSheetLastFilledCol xlSheetLastFilledColW
    #define xlSheetDisplayGridlines xlSheetDisplayGridlinesW
    #define xlSheetSetDisplayGridlines xlSheetSetDisplayGridlinesW
    #define xlSheetPrintGridlines xlSheetPrintGridlinesW
    #define xlSheetSetPrintGridlines xlSheetSetPrintGridlinesW
    #define xlSheetZoom xlSheetZoomW
    #define xlSheetSetZoom xlSheetSetZoomW
    #define xlSheetPrintZoom xlSheetPrintZoomW
    #define xlSheetSetPrintZoom xlSheetSetPrintZoomW
    #define xlSheetGetPrintFit xlSheetGetPrintFitW
    #define xlSheetSetPrintFit xlSheetSetPrintFitW
    #define xlSheetLandscape xlSheetLandscapeW
    #define xlSheetSetLandscape xlSheetSetLandscapeW
    #define xlSheetPaper xlSheetPaperW
    #define xlSheetSetPaper xlSheetSetPaperW
    #define xlSheetHeader xlSheetHeaderW
    #define xlSheetSetHeader xlSheetSetHeaderW
    #define xlSheetHeaderMargin xlSheetHeaderMarginW
    #define xlSheetFooter xlSheetFooterW
    #define xlSheetSetFooter xlSheetSetFooterW
    #define xlSheetFooterMargin xlSheetFooterMarginW
    #define xlSheetHCenter xlSheetHCenterW
    #define xlSheetSetHCenter xlSheetSetHCenterW
    #define xlSheetVCenter xlSheetVCenterW
    #define xlSheetSetVCenter xlSheetSetVCenterW
    #define xlSheetMarginLeft xlSheetMarginLeftW
    #define xlSheetSetMarginLeft xlSheetSetMarginLeftW
    #define xlSheetMarginRight xlSheetMarginRightW
    #define xlSheetSetMarginRight xlSheetSetMarginRightW
    #define xlSheetMarginTop xlSheetMarginTopW
    #define xlSheetSetMarginTop xlSheetSetMarginTopW
    #define xlSheetMarginBottom xlSheetMarginBottomW
    #define xlSheetSetMarginBottom xlSheetSetMarginBottomW
    #define xlSheetPrintRowCol xlSheetPrintRowColW
    #define xlSheetSetPrintRowCol xlSheetSetPrintRowColW
    #define xlSheetPrintRepeatRows xlSheetPrintRepeatRowsW
    #define xlSheetSetPrintRepeatRows xlSheetSetPrintRepeatRowsW
    #define xlSheetPrintRepeatCols xlSheetPrintRepeatColsW
    #define xlSheetSetPrintRepeatCols xlSheetSetPrintRepeatColsW
    #define xlSheetPrintArea xlSheetPrintAreaW
    #define xlSheetSetPrintArea xlSheetSetPrintAreaW
    #define xlSheetClearPrintRepeats xlSheetClearPrintRepeatsW
    #define xlSheetClearPrintArea xlSheetClearPrintAreaW
    #define xlSheetGetNamedRange xlSheetGetNamedRangeW
    #define xlSheetSetNamedRange xlSheetSetNamedRangeW
    #define xlSheetDelNamedRange xlSheetDelNamedRangeW
    #define xlSheetNamedRangeSize xlSheetNamedRangeSizeW
    #define xlSheetNamedRange xlSheetNamedRangeW
    #define xlSheetGetTable xlSheetGetTableW
    #define xlSheetTableSize xlSheetTableSizeW
    #define xlSheetTable xlSheetTableW
    #define xlSheetAddTable xlSheetAddTableW
    #define xlSheetGetTableByName xlSheetGetTableByNameW
    #define xlSheetGetTableByIndex xlSheetGetTableByIndexW
    #define xlSheetHyperlinkSize xlSheetHyperlinkSizeW
    #define xlSheetHyperlink xlSheetHyperlinkW
    #define xlSheetDelHyperlink xlSheetDelHyperlinkW
    #define xlSheetAddHyperlink xlSheetAddHyperlinkW
    #define xlSheetHyperlinkIndex xlSheetHyperlinkIndexW
    #define xlSheetIsAutoFilter xlSheetIsAutoFilterW
    #define xlSheetAutoFilter xlSheetAutoFilterW
    #define xlSheetApplyFilter xlSheetApplyFilterW
    #define xlSheetApplyFilter2 xlSheetApplyFilter2W
    #define xlSheetRemoveFilter xlSheetRemoveFilterW
    #define xlSheetName xlSheetNameW
    #define xlSheetSetName xlSheetSetNameW
    #define xlSheetProtect xlSheetProtectW
    #define xlSheetSetProtect xlSheetSetProtectW
    #define xlSheetSetProtectEx xlSheetSetProtectExW
    #define xlSheetHidden xlSheetHiddenW
    #define xlSheetSetHidden xlSheetSetHiddenW
    #define xlSheetGetTopLeftView xlSheetGetTopLeftViewW
    #define xlSheetSetTopLeftView xlSheetSetTopLeftViewW
    #define xlSheetRightToLeft xlSheetRightToLeftW
    #define xlSheetSetRightToLeft xlSheetSetRightToLeftW
    #define xlSheetSetAutoFitArea xlSheetSetAutoFitAreaW
    #define xlSheetAddrToRowCol xlSheetAddrToRowColW
    #define xlSheetRowColToAddr xlSheetRowColToAddrW
    #define xlSheetTabColor xlSheetTabColorW
    #define xlSheetSetTabColor xlSheetSetTabColorW
    #define xlSheetGetTabRgbColor xlSheetGetTabRgbColorW
    #define xlSheetSetTabRgbColor xlSheetSetTabRgbColorW
    #define xlSheetAddIgnoredError xlSheetAddIgnoredErrorW
    #define xlSheetAddDataValidation xlSheetAddDataValidationW
    #define xlSheetAddDataValidationEx xlSheetAddDataValidationExW
    #define xlSheetAddDataValidationDouble xlSheetAddDataValidationDoubleW
    #define xlSheetAddDataValidationDoubleEx xlSheetAddDataValidationDoubleExW
    #define xlSheetRemoveDataValidations xlSheetRemoveDataValidationsW
    #define xlSheetFormControlSize xlSheetFormControlSizeW
    #define xlSheetFormControl xlSheetFormControlW
    #define xlSheetAddConditionalFormatting xlSheetAddConditionalFormattingW
    #define xlSheetGetActiveCell xlSheetGetActiveCellW
    #define xlSheetSetActiveCell xlSheetSetActiveCellW
    #define xlSheetSelectionRange xlSheetSelectionRangeW
    #define xlSheetAddSelectionRange xlSheetAddSelectionRangeW
    #define xlSheetRemoveSelection xlSheetRemoveSelectionW

    #define xlFontSize xlFontSizeW
    #define xlFontSetSize xlFontSetSizeW
    #define xlFontItalic xlFontItalicW
    #define xlFontSetItalic xlFontSetItalicW
    #define xlFontStrikeOut xlFontStrikeOutW
    #define xlFontSetStrikeOut xlFontSetStrikeOutW
    #define xlFontColor xlFontColorW
    #define xlFontSetColor xlFontSetColorW
    #define xlFontBold xlFontBoldW
    #define xlFontSetBold xlFontSetBoldW
    #define xlFontScript xlFontScriptW
    #define xlFontSetScript xlFontSetScriptW
    #define xlFontUnderline xlFontUnderlineW
    #define xlFontSetUnderline xlFontSetUnderlineW
    #define xlFontName xlFontNameW
    #define xlFontSetName xlFontSetNameW

    #define xlFormatFont xlFormatFontW
    #define xlFormatSetFont xlFormatSetFontW
    #define xlFormatNumFormat xlFormatNumFormatW
    #define xlFormatSetNumFormat xlFormatSetNumFormatW
    #define xlFormatAlignH xlFormatAlignHW
    #define xlFormatSetAlignH xlFormatSetAlignHW
    #define xlFormatAlignV xlFormatAlignVW
    #define xlFormatSetAlignV xlFormatSetAlignVW
    #define xlFormatWrap xlFormatWrapW
    #define xlFormatSetWrap xlFormatSetWrapW
    #define xlFormatRotation xlFormatRotationW
    #define xlFormatSetRotation xlFormatSetRotationW
    #define xlFormatIndent xlFormatIndentW
    #define xlFormatSetIndent xlFormatSetIndentW
    #define xlFormatShrinkToFit xlFormatShrinkToFitW
    #define xlFormatSetShrinkToFit xlFormatSetShrinkToFitW
    #define xlFormatSetBorder xlFormatSetBorderW
    #define xlFormatSetBorderColor xlFormatSetBorderColorW
    #define xlFormatBorderLeft xlFormatBorderLeftW
    #define xlFormatSetBorderLeft xlFormatSetBorderLeftW
    #define xlFormatBorderRight xlFormatBorderRightW
    #define xlFormatSetBorderRight xlFormatSetBorderRightW
    #define xlFormatBorderTop xlFormatBorderTopW
    #define xlFormatSetBorderTop xlFormatSetBorderTopW
    #define xlFormatBorderBottom xlFormatBorderBottomW
    #define xlFormatSetBorderBottom xlFormatSetBorderBottomW
    #define xlFormatBorderLeftColor xlFormatBorderLeftColorW
    #define xlFormatSetBorderLeftColor xlFormatSetBorderLeftColorW
    #define xlFormatBorderRightColor xlFormatBorderRightColorW
    #define xlFormatSetBorderRightColor xlFormatSetBorderRightColorW
    #define xlFormatBorderTopColor xlFormatBorderTopColorW
    #define xlFormatSetBorderTopColor xlFormatSetBorderTopColorW
    #define xlFormatBorderBottomColor xlFormatBorderBottomColorW
    #define xlFormatSetBorderBottomColor xlFormatSetBorderBottomColorW
    #define xlFormatBorderDiagonal xlFormatBorderDiagonalW
    #define xlFormatSetBorderDiagonal xlFormatSetBorderDiagonalW
    #define xlFormatBorderDiagonalStyle xlFormatBorderDiagonalStyleW
    #define xlFormatSetBorderDiagonalStyle xlFormatSetBorderDiagonalStyleW
    #define xlFormatBorderDiagonalColor xlFormatBorderDiagonalColorW
    #define xlFormatSetBorderDiagonalColor xlFormatSetBorderDiagonalColorW
    #define xlFormatFillPattern xlFormatFillPatternW
    #define xlFormatSetFillPattern xlFormatSetFillPatternW
    #define xlFormatPatternForegroundColor xlFormatPatternForegroundColorW
    #define xlFormatSetPatternForegroundColor xlFormatSetPatternForegroundColorW
    #define xlFormatPatternBackgroundColor xlFormatPatternBackgroundColorW
    #define xlFormatSetPatternBackgroundColor xlFormatSetPatternBackgroundColorW
    #define xlFormatLocked xlFormatLockedW
    #define xlFormatSetLocked xlFormatSetLockedW
    #define xlFormatHidden xlFormatHiddenW
    #define xlFormatSetHidden xlFormatSetHiddenW

    #define xlAutoFilterGetRef xlAutoFilterGetRefW
    #define xlAutoFilterSetRef xlAutoFilterSetRefW
    #define xlAutoFilterColumn xlAutoFilterColumnW
    #define xlAutoFilterColumnSize xlAutoFilterColumnSizeW
    #define xlAutoFilterColumnByIndex xlAutoFilterColumnByIndexW
    #define xlAutoFilterGetSortRange xlAutoFilterGetSortRangeW
    #define xlAutoFilterGetSort xlAutoFilterGetSortW
    #define xlAutoFilterSetSort xlAutoFilterSetSortW
    #define xlAutoFilterAddSort xlAutoFilterAddSortW

    #define xlFilterColumnIndex xlFilterColumnIndexW
    #define xlFilterColumnFilterType xlFilterColumnFilterTypeW
    #define xlFilterColumnFilterSize xlFilterColumnFilterSizeW
    #define xlFilterColumnFilter xlFilterColumnFilterW
    #define xlFilterColumnAddFilter xlFilterColumnAddFilterW
    #define xlFilterColumnGetTop10 xlFilterColumnGetTop10W
    #define xlFilterColumnSetTop10 xlFilterColumnSetTop10W
    #define xlFilterColumnGetCustomFilter xlFilterColumnGetCustomFilterW
    #define xlFilterColumnSetCustomFilter xlFilterColumnSetCustomFilterW
    #define xlFilterColumnSetCustomFilterEx xlFilterColumnSetCustomFilterExW
    #define xlFilterColumnClear xlFilterColumnClearW

    #define xlRichStringAddFont xlRichStringAddFontW
    #define xlRichStringAddText xlRichStringAddTextW
    #define xlRichStringGetText xlRichStringGetTextW
    #define xlRichStringTextSize xlRichStringTextSizeW

    #define xlFormControlObjectType xlFormControlObjectTypeW
    #define xlFormControlChecked xlFormControlCheckedW
    #define xlFormControlSetChecked xlFormControlSetCheckedW
    #define xlFormControlFmlaGroup xlFormControlFmlaGroupW
    #define xlFormControlSetFmlaGroup xlFormControlSetFmlaGroupW
    #define xlFormControlFmlaLink xlFormControlFmlaLinkW
    #define xlFormControlSetFmlaLink xlFormControlSetFmlaLinkW
    #define xlFormControlFmlaRange xlFormControlFmlaRangeW
    #define xlFormControlSetFmlaRange xlFormControlSetFmlaRangeW
    #define xlFormControlFmlaTxbx xlFormControlFmlaTxbxW
    #define xlFormControlSetFmlaTxbx xlFormControlSetFmlaTxbxW
    #define xlFormControlName xlFormControlNameW
    #define xlFormControlLinkedCell xlFormControlLinkedCellW
    #define xlFormControlListFillRange xlFormControlListFillRangeW
    #define xlFormControlMacro xlFormControlMacroW
    #define xlFormControlAltText xlFormControlAltTextW
    #define xlFormControlLocked xlFormControlLockedW
    #define xlFormControlDefaultSize xlFormControlDefaultSizeW
    #define xlFormControlPrint xlFormControlPrintW
    #define xlFormControlDisabled xlFormControlDisabledW
    #define xlFormControlItem xlFormControlItemW
    #define xlFormControlItemSize xlFormControlItemSizeW
    #define xlFormControlAddItem xlFormControlAddItemW
    #define xlFormControlInsertItem xlFormControlInsertItemW
    #define xlFormControlClearItems xlFormControlClearItemsW
    #define xlFormControlDropLines xlFormControlDropLinesW
    #define xlFormControlSetDropLines xlFormControlSetDropLinesW
    #define xlFormControlDx xlFormControlDxW
    #define xlFormControlSetDx xlFormControlSetDxW
    #define xlFormControlFirstButton xlFormControlFirstButtonW
    #define xlFormControlSetFirstButton xlFormControlSetFirstButtonW
    #define xlFormControlHoriz xlFormControlHorizW
    #define xlFormControlSetHoriz xlFormControlSetHorizW
    #define xlFormControlInc xlFormControlIncW
    #define xlFormControlSetInc xlFormControlSetIncW
    #define xlFormControlGetMax xlFormControlGetMaxW
    #define xlFormControlSetMax xlFormControlSetMaxW
    #define xlFormControlGetMin xlFormControlGetMinW
    #define xlFormControlSetMin xlFormControlSetMinW
    #define xlFormControlMultiSel xlFormControlMultiSelW
    #define xlFormControlSetMultiSel xlFormControlSetMultiSelW
    #define xlFormControlSel xlFormControlSelW
    #define xlFormControlSetSel xlFormControlSetSelW
    #define xlFormControlFromAnchor xlFormControlFromAnchorW
    #define xlFormControlToAnchor xlFormControlToAnchorW

    #define xlConditionalFormattingAddRange xlConditionalFormattingAddRangeW
    #define xlConditionalFormattingAddRule xlConditionalFormattingAddRuleW
    #define xlConditionalFormattingAddTopRule xlConditionalFormattingAddTopRuleW
    #define xlConditionalFormattingAddOpNumRule xlConditionalFormattingAddOpNumRuleW
    #define xlConditionalFormattingAddOpStrRule xlConditionalFormattingAddOpStrRuleW
    #define xlConditionalFormattingAddAboveAverageRule xlConditionalFormattingAddAboveAverageRuleW
    #define xlConditionalFormattingAddTimePeriodRule xlConditionalFormattingAddTimePeriodRuleW
    #define xlConditionalFormattingAdd2ColorScaleRule xlConditionalFormattingAdd2ColorScaleRuleW
    #define xlConditionalFormattingAdd2ColorScaleFormulaRule xlConditionalFormattingAdd2ColorScaleFormulaRuleW
    #define xlConditionalFormattingAdd3ColorScaleRule xlConditionalFormattingAdd3ColorScaleRuleW
    #define xlConditionalFormattingAdd3ColorScaleFormulaRule xlConditionalFormattingAdd3ColorScaleFormulaRuleW

    #define xlConditionalFormatFont xlConditionalFormatFontW
    #define xlConditionalFormatNumFormat xlConditionalFormatNumFormatW
    #define xlConditionalFormatSetNumFormat xlConditionalFormatSetNumFormatW
    #define xlConditionalFormatCustomNumFormat xlConditionalFormatCustomNumFormatW
    #define xlConditionalFormatSetCustomNumFormat xlConditionalFormatSetCustomNumFormatW
    #define xlConditionalFormatSetBorder xlConditionalFormatSetBorderW
    #define xlConditionalFormatSetBorderColor xlConditionalFormatSetBorderColorW
    #define xlConditionalFormatBorderLeft xlConditionalFormatBorderLeftW
    #define xlConditionalFormatSetBorderLeft xlConditionalFormatSetBorderLeftW
    #define xlConditionalFormatBorderRight xlConditionalFormatBorderRightW
    #define xlConditionalFormatSetBorderRight xlConditionalFormatSetBorderRightW
    #define xlConditionalFormatBorderTop xlConditionalFormatBorderTopW
    #define xlConditionalFormatSetBorderTop xlConditionalFormatSetBorderTopW
    #define xlConditionalFormatBorderBottom xlConditionalFormatBorderBottomW
    #define xlConditionalFormatSetBorderBottom xlConditionalFormatSetBorderBottomW
    #define xlConditionalFormatBorderLeftColor xlConditionalFormatBorderLeftColorW
    #define xlConditionalFormatSetBorderLeftColor xlConditionalFormatSetBorderLeftColorW
    #define xlConditionalFormatBorderRightColor xlConditionalFormatBorderRightColorW
    #define xlConditionalFormatSetBorderRightColor xlConditionalFormatSetBorderRightColorW
    #define xlConditionalFormatBorderTopColor xlConditionalFormatBorderTopColorW
    #define xlConditionalFormatSetBorderTopColor xlConditionalFormatSetBorderTopColorW
    #define xlConditionalFormatBorderBottomColor xlConditionalFormatBorderBottomColorW
    #define xlConditionalFormatSetBorderBottomColor xlConditionalFormatSetBorderBottomColorW
    #define xlConditionalFormatFillPattern xlConditionalFormatFillPatternW
    #define xlConditionalFormatSetFillPattern xlConditionalFormatSetFillPatternW
    #define xlConditionalFormatPatternForegroundColor xlConditionalFormatPatternForegroundColorW
    #define xlConditionalFormatSetPatternForegroundColor xlConditionalFormatSetPatternForegroundColorW
    #define xlConditionalFormatPatternBackgroundColor xlConditionalFormatPatternBackgroundColorW
    #define xlConditionalFormatSetPatternBackgroundColor xlConditionalFormatSetPatternBackgroundColorW

    #define xlCorePropertiesTitle xlCorePropertiesTitleW
    #define xlCorePropertiesSetTitle xlCorePropertiesSetTitleW
    #define xlCorePropertiesSubject xlCorePropertiesSubjectW
    #define xlCorePropertiesSetSubject xlCorePropertiesSetSubjectW
    #define xlCorePropertiesCreator xlCorePropertiesCreatorW
    #define xlCorePropertiesSetCreator xlCorePropertiesSetCreatorW
    #define xlCorePropertiesLastModifiedBy xlCorePropertiesLastModifiedByW
    #define xlCorePropertiesSetLastModifiedBy xlCorePropertiesSetLastModifiedByW
    #define xlCorePropertiesCreated xlCorePropertiesCreatedW
    #define xlCorePropertiesSetCreated xlCorePropertiesSetCreatedW
    #define xlCorePropertiesCreatedAsDouble xlCorePropertiesCreatedAsDoubleW
    #define xlCorePropertiesSetCreatedAsDouble xlCorePropertiesSetCreatedAsDoubleW
    #define xlCorePropertiesModified xlCorePropertiesModifiedW
    #define xlCorePropertiesSetModified xlCorePropertiesSetModifiedW
    #define xlCorePropertiesModifiedAsDouble xlCorePropertiesModifiedAsDoubleW
    #define xlCorePropertiesSetModifiedAsDouble xlCorePropertiesSetModifiedAsDoubleW
    #define xlCorePropertiesTags xlCorePropertiesTagsW
    #define xlCorePropertiesSetTags xlCorePropertiesSetTagsW
    #define xlCorePropertiesCategories xlCorePropertiesCategoriesW
    #define xlCorePropertiesSetCategories xlCorePropertiesSetCategoriesW
    #define xlCorePropertiesComments xlCorePropertiesCommentsW
    #define xlCorePropertiesSetComments xlCorePropertiesSetCommentsW
    #define xlCorePropertiesRemoveAll xlCorePropertiesRemoveAllW

    #define xlTableName xlTableNameW
    #define xlTableSetName xlTableSetNameW
    #define xlTableRef xlTableRefW
    #define xlTableSetRef xlTableSetRefW
    #define xlTableAutoFilter xlTableAutoFilterW
    #define xlTableStyle xlTableStyleW
    #define xlTableSetStyle xlTableSetStyleW
    #define xlTableShowRowStripes xlTableShowRowStripesW
    #define xlTableSetShowRowStripes xlTableSetShowRowStripesW
    #define xlTableShowColumnStripes xlTableShowColumnStripesW
    #define xlTableSetShowColumnStripes xlTableSetShowColumnStripesW
    #define xlTableShowFirstColumn xlTableShowFirstColumnW
    #define xlTableSetShowFirstColumn xlTableSetShowFirstColumnW
    #define xlTableShowLastColumn xlTableShowLastColumnW
    #define xlTableSetShowLastColumn xlTableSetShowLastColumnW
    #define xlTableColumnSize xlTableColumnSizeW
    #define xlTableColumnName xlTableColumnNameW
    #define xlTableSetColumnName xlTableSetColumnNameW

#else

    #include "BookA.h"
    #include "SheetA.h"
    #include "FormatA.h"
    #include "FontA.h"
    #include "AutoFilterA.h"
    #include "FilterColumnA.h"
    #include "RichStringA.h"
    #include "ConditionalFormatA.h"
    #include "ConditionalFormattingA.h"
    #include "CorePropertiesA.h"
    #include "FormControlA.h"
    #include "TableA.h"

    #define xlCreateBook xlCreateBookCA
    #define xlCreateXMLBook xlCreateXMLBookCA
    #define xlBookLoad xlBookLoadA
    #define xlBookSave xlBookSaveA
    #define xlBookLoadUsingTempFile xlBookLoadUsingTempFileA
    #define xlBookSaveUsingTempFile xlBookSaveUsingTempFileA
    #define xlBookLoadPartially xlBookLoadPartiallyA
    #define xlBookLoadPartiallyUsingTempFile xlBookLoadPartiallyUsingTempFileA
    #define xlBookLoadWithoutEmptyCells xlBookLoadWithoutEmptyCellsA
    #define xlBookLoadInfo xlBookLoadInfoA
    #define xlBookLoadInfoRaw xlBookLoadInfoRawA
    #define xlBookLoadRaw xlBookLoadRawA
    #define xlBookLoadRawPartially xlBookLoadRawPartiallyA
    #define xlBookSaveRaw xlBookSaveRawA
    #define xlBookSetPassword xlBookSetPasswordA
    #define xlBookAddSheet xlBookAddSheetA
    #define xlBookInsertSheet xlBookInsertSheetA
    #define xlBookGetSheet xlBookGetSheetA
    #define xlBookGetSheetName xlBookGetSheetNameA
    #define xlBookSheetType xlBookSheetTypeA
    #define xlBookMoveSheet xlBookMoveSheetA
    #define xlBookDelSheet xlBookDelSheetA
    #define xlBookSheetCount xlBookSheetCountA
    #define xlBookAddFormat xlBookAddFormatA
    #define xlBookAddFormatFromStyle xlBookAddFormatFromStyleA
    #define xlBookAddFont xlBookAddFontA
    #define xlBookAddRichString xlBookAddRichStringA
    #define xlBookAddCustomNumFormat xlBookAddCustomNumFormatA
    #define xlBookCustomNumFormat xlBookCustomNumFormatA
    #define xlBookFormat xlBookFormatA
    #define xlBookFormatSize xlBookFormatSizeA
    #define xlBookFont xlBookFontA
    #define xlBookFontSize xlBookFontSizeA
    #define xlBookAddConditionalFormat xlBookAddConditionalFormatA
    #define xlBookDatePack xlBookDatePackA
    #define xlBookDateUnpack xlBookDateUnpackA
    #define xlBookColorPack xlBookColorPackA
    #define xlBookColorUnpack xlBookColorUnpackA
    #define xlBookActiveSheet xlBookActiveSheetA
    #define xlBookSetActiveSheet xlBookSetActiveSheetA
    #define xlBookPictureSize xlBookPictureSizeA
    #define xlBookGetPicture xlBookGetPictureA
    #define xlBookAddPicture xlBookAddPictureA
    #define xlBookAddPicture2 xlBookAddPicture2A
    #define xlBookAddPictureAsLink xlBookAddPictureAsLinkA
    #define xlBookDefaultFont xlBookDefaultFontA
    #define xlBookSetDefaultFont xlBookSetDefaultFontA
    #define xlBookSetKey xlBookSetKeyA
    #define xlBookRefR1C1 xlBookRefR1C1A
    #define xlBookSetRefR1C1 xlBookSetRefR1C1A
    #define xlBookRgbMode xlBookRgbModeA
    #define xlBookSetRgbMode xlBookSetRgbModeA
    #define xlBookCalcMode xlBookCalcModeA
    #define xlBookSetCalcMode xlBookSetCalcModeA
    #define xlBookVersion xlBookVersionA
    #define xlBookBiffVersion xlBookBiffVersionA
    #define xlBookIsDate1904 xlBookIsDate1904A
    #define xlBookSetDate1904 xlBookSetDate1904A
    #define xlBookIsTemplate xlBookIsTemplateA
    #define xlBookSetTemplate xlBookSetTemplateA
    #define xlBookIsWriteProtected xlBookIsWriteProtectedA
    #define xlBookCoreProperties xlBookCorePropertiesA
    #define xlBookSetLocale xlBookSetLocaleA
    #define xlBookRemoveVBA xlBookRemoveVBAA
    #define xlBookRemovePrinterSettings xlBookRemovePrinterSettingsA
    #define xlBookRemoveAllPhonetics xlBookRemoveAllPhoneticsA
    #define xlBookErrorMessage xlBookErrorMessageA
    #define xlBookRelease xlBookReleaseA

    #define xlSheetCellType xlSheetCellTypeA
    #define xlSheetCellFormat xlSheetCellFormatA
    #define xlSheetSetCellFormat xlSheetSetCellFormatA
    #define xlSheetIsFormula xlSheetIsFormulaA
    #define xlSheetReadStr xlSheetReadStrA
    #define xlSheetWriteStr xlSheetWriteStrA
    #define xlSheetWriteStrAsNum xlSheetWriteStrAsNumA
    #define xlSheetReadRichStr xlSheetReadRichStrA
    #define xlSheetWriteRichStr xlSheetWriteRichStrA
    #define xlSheetReadNum xlSheetReadNumA
    #define xlSheetWriteNum xlSheetWriteNumA
    #define xlSheetReadBool xlSheetReadBoolA
    #define xlSheetWriteBool xlSheetWriteBoolA
    #define xlSheetReadBlank xlSheetReadBlankA
    #define xlSheetWriteBlank xlSheetWriteBlankA
    #define xlSheetReadFormula xlSheetReadFormulaA
    #define xlSheetWriteFormula xlSheetWriteFormulaA
    #define xlSheetWriteFormulaNum xlSheetWriteFormulaNumA
    #define xlSheetWriteFormulaStr xlSheetWriteFormulaStrA
    #define xlSheetWriteFormulaBool xlSheetWriteFormulaBoolA
    #define xlSheetReadComment xlSheetReadCommentA
    #define xlSheetWriteComment xlSheetWriteCommentA
    #define xlSheetRemoveComment xlSheetRemoveCommentA
    #define xlSheetIsDate xlSheetIsDateA
    #define xlSheetIsRichStr xlSheetIsRichStrA
    #define xlSheetReadError xlSheetReadErrorA
    #define xlSheetWriteError xlSheetWriteErrorA
    #define xlSheetColWidth xlSheetColWidthA
    #define xlSheetRowHeight xlSheetRowHeightA
    #define xlSheetColWidthPx xlSheetColWidthPxA
    #define xlSheetRowHeightPx xlSheetRowHeightPxA
    #define xlSheetColFormat xlSheetColFormatA
    #define xlSheetRowFormat xlSheetRowFormatA
    #define xlSheetSetCol xlSheetSetColA
    #define xlSheetSetColPx xlSheetSetColPxA
    #define xlSheetSetRow xlSheetSetRowA
    #define xlSheetSetRowPx xlSheetSetRowPxA
    #define xlSheetRowHidden xlSheetRowHiddenA
    #define xlSheetSetRowHidden xlSheetSetRowHiddenA
    #define xlSheetColHidden xlSheetColHiddenA
    #define xlSheetSetColHidden xlSheetSetColHiddenA
    #define xlSheetDefaultRowHeight xlSheetDefaultRowHeightA
    #define xlSheetSetDefaultRowHeight xlSheetSetDefaultRowHeightA
    #define xlSheetGetMerge xlSheetGetMergeA
    #define xlSheetSetMerge xlSheetSetMergeA
    #define xlSheetDelMerge xlSheetDelMergeA
    #define xlSheetMergeSize xlSheetMergeSizeA
    #define xlSheetMerge xlSheetMergeA
    #define xlSheetDelMergeByIndex xlSheetDelMergeByIndexA
    #define xlSheetPictureSize xlSheetPictureSizeA
    #define xlSheetGetPicture xlSheetGetPictureA
    #define xlSheetRemovePictureByIndex xlSheetRemovePictureByIndexA
    #define xlSheetSetPicture xlSheetSetPictureA
    #define xlSheetSetPicture2 xlSheetSetPicture2A
    #define xlSheetRemovePicture xlSheetRemovePictureA
    #define xlSheetGetHorPageBreak xlSheetGetHorPageBreakA
    #define xlSheetGetHorPageBreakSize xlSheetGetHorPageBreakSizeA
    #define xlSheetGetVerPageBreak xlSheetGetVerPageBreakA
    #define xlSheetGetVerPageBreakSize xlSheetGetVerPageBreakSizeA
    #define xlSheetSetHorPageBreak xlSheetSetHorPageBreakA
    #define xlSheetSetVerPageBreak xlSheetSetVerPageBreakA
    #define xlSheetSplit xlSheetSplitA
    #define xlSheetSplitInfo xlSheetSplitInfoA
    #define xlSheetGroupRows xlSheetGroupRowsA
    #define xlSheetGroupCols xlSheetGroupColsA
    #define xlSheetGroupSummaryBelow xlSheetGroupSummaryBelowA
    #define xlSheetSetGroupSummaryBelow xlSheetSetGroupSummaryBelowA
    #define xlSheetGroupSummaryRight xlSheetGroupSummaryRightA
    #define xlSheetSetGroupSummaryRight xlSheetSetGroupSummaryRightA
    #define xlSheetClear xlSheetClearA
    #define xlSheetInsertCol xlSheetInsertColA
    #define xlSheetInsertRow xlSheetInsertRowA
    #define xlSheetRemoveCol xlSheetRemoveColA
    #define xlSheetRemoveRow xlSheetRemoveRowA
    #define xlSheetInsertColAndKeepRanges xlSheetInsertColAndKeepRangesA
    #define xlSheetInsertRowAndKeepRanges xlSheetInsertRowAndKeepRangesA
    #define xlSheetRemoveColAndKeepRanges xlSheetRemoveColAndKeepRangesA
    #define xlSheetRemoveRowAndKeepRanges xlSheetRemoveRowAndKeepRangesA
    #define xlSheetCopyCell xlSheetCopyCellA
    #define xlSheetFirstRow xlSheetFirstRowA
    #define xlSheetLastRow xlSheetLastRowA
    #define xlSheetFirstCol xlSheetFirstColA
    #define xlSheetLastCol xlSheetLastColA
    #define xlSheetFirstFilledRow xlSheetFirstFilledRowA
    #define xlSheetLastFilledRow xlSheetLastFilledRowA
    #define xlSheetFirstFilledCol xlSheetFirstFilledColA
    #define xlSheetLastFilledCol xlSheetLastFilledColA
    #define xlSheetDisplayGridlines xlSheetDisplayGridlinesA
    #define xlSheetSetDisplayGridlines xlSheetSetDisplayGridlinesA
    #define xlSheetPrintGridlines xlSheetPrintGridlinesA
    #define xlSheetSetPrintGridlines xlSheetSetPrintGridlinesA
    #define xlSheetZoom xlSheetZoomA
    #define xlSheetSetZoom xlSheetSetZoomA
    #define xlSheetPrintZoom xlSheetPrintZoomA
    #define xlSheetSetPrintZoom xlSheetSetPrintZoomA
    #define xlSheetGetPrintFit xlSheetGetPrintFitA
    #define xlSheetSetPrintFit xlSheetSetPrintFitA
    #define xlSheetLandscape xlSheetLandscapeA
    #define xlSheetSetLandscape xlSheetSetLandscapeA
    #define xlSheetPaper xlSheetPaperA
    #define xlSheetSetPaper xlSheetSetPaperA
    #define xlSheetHeader xlSheetHeaderA
    #define xlSheetSetHeader xlSheetSetHeaderA
    #define xlSheetHeaderMargin xlSheetHeaderMarginA
    #define xlSheetFooter xlSheetFooterA
    #define xlSheetSetFooter xlSheetSetFooterA
    #define xlSheetFooterMargin xlSheetFooterMarginA
    #define xlSheetHCenter xlSheetHCenterA
    #define xlSheetSetHCenter xlSheetSetHCenterA
    #define xlSheetVCenter xlSheetVCenterA
    #define xlSheetSetVCenter xlSheetSetVCenterA
    #define xlSheetMarginLeft xlSheetMarginLeftA
    #define xlSheetSetMarginLeft xlSheetSetMarginLeftA
    #define xlSheetMarginRight xlSheetMarginRightA
    #define xlSheetSetMarginRight xlSheetSetMarginRightA
    #define xlSheetMarginTop xlSheetMarginTopA
    #define xlSheetSetMarginTop xlSheetSetMarginTopA
    #define xlSheetMarginBottom xlSheetMarginBottomA
    #define xlSheetSetMarginBottom xlSheetSetMarginBottomA
    #define xlSheetPrintRowCol xlSheetPrintRowColA
    #define xlSheetSetPrintRowCol xlSheetSetPrintRowColA
    #define xlSheetPrintRepeatRows xlSheetPrintRepeatRowsA
    #define xlSheetSetPrintRepeatRows xlSheetSetPrintRepeatRowsA
    #define xlSheetPrintRepeatCols xlSheetPrintRepeatColsA
    #define xlSheetSetPrintRepeatCols xlSheetSetPrintRepeatColsA
    #define xlSheetPrintArea xlSheetPrintAreaA
    #define xlSheetSetPrintArea xlSheetSetPrintAreaA
    #define xlSheetClearPrintRepeats xlSheetClearPrintRepeatsA
    #define xlSheetClearPrintArea xlSheetClearPrintAreaA
    #define xlSheetGetNamedRange xlSheetGetNamedRangeA
    #define xlSheetSetNamedRange xlSheetSetNamedRangeA
    #define xlSheetDelNamedRange xlSheetDelNamedRangeA
    #define xlSheetNamedRangeSize xlSheetNamedRangeSizeA
    #define xlSheetNamedRange xlSheetNamedRangeA
    #define xlSheetGetTable xlSheetGetTableA
    #define xlSheetTableSize xlSheetTableSizeA
    #define xlSheetTable xlSheetTableA
    #define xlSheetAddTable xlSheetAddTableA
    #define xlSheetGetTableByName xlSheetGetTableByNameA
    #define xlSheetGetTableByIndex xlSheetGetTableByIndexA
    #define xlSheetHyperlinkSize xlSheetHyperlinkSizeA
    #define xlSheetHyperlink xlSheetHyperlinkA
    #define xlSheetDelHyperlink xlSheetDelHyperlinkA
    #define xlSheetAddHyperlink xlSheetAddHyperlinkA
    #define xlSheetHyperlinkIndex xlSheetHyperlinkIndexA
    #define xlSheetIsAutoFilter xlSheetIsAutoFilterA
    #define xlSheetAutoFilter xlSheetAutoFilterA
    #define xlSheetApplyFilter xlSheetApplyFilterA
    #define xlSheetApplyFilter2 xlSheetApplyFilter2A
    #define xlSheetRemoveFilter xlSheetRemoveFilterA
    #define xlSheetName xlSheetNameA
    #define xlSheetSetName xlSheetSetNameA
    #define xlSheetProtect xlSheetProtectA
    #define xlSheetSetProtect xlSheetSetProtectA
    #define xlSheetSetProtectEx xlSheetSetProtectExA
    #define xlSheetHidden xlSheetHiddenA
    #define xlSheetSetHidden xlSheetSetHiddenA
    #define xlSheetGetTopLeftView xlSheetGetTopLeftViewA
    #define xlSheetSetTopLeftView xlSheetSetTopLeftViewA
    #define xlSheetRightToLeft xlSheetRightToLeftA
    #define xlSheetSetRightToLeft xlSheetSetRightToLeftA
    #define xlSheetSetAutoFitArea xlSheetSetAutoFitAreaA
    #define xlSheetAddrToRowCol xlSheetAddrToRowColA
    #define xlSheetRowColToAddr xlSheetRowColToAddrA
    #define xlSheetTabColor xlSheetTabColorA
    #define xlSheetSetTabColor xlSheetSetTabColorA
    #define xlSheetGetTabRgbColor xlSheetGetTabRgbColorA
    #define xlSheetSetTabRgbColor xlSheetSetTabRgbColorA
    #define xlSheetAddIgnoredError xlSheetAddIgnoredErrorA
    #define xlSheetAddDataValidation xlSheetAddDataValidationA
    #define xlSheetAddDataValidationEx xlSheetAddDataValidationExA
    #define xlSheetAddDataValidationDouble xlSheetAddDataValidationDoubleA
    #define xlSheetAddDataValidationDoubleEx xlSheetAddDataValidationDoubleExA
    #define xlSheetRemoveDataValidations xlSheetRemoveDataValidationsA
    #define xlSheetFormControlSize xlSheetFormControlSizeA
    #define xlSheetFormControl xlSheetFormControlA
    #define xlSheetAddConditionalFormatting xlSheetAddConditionalFormattingA
    #define xlSheetGetActiveCell xlSheetGetActiveCellA
    #define xlSheetSetActiveCell xlSheetSetActiveCellA
    #define xlSheetSelectionRange xlSheetSelectionRangeA
    #define xlSheetAddSelectionRange xlSheetAddSelectionRangeA
    #define xlSheetRemoveSelection xlSheetRemoveSelectionA

    #define xlFontSize xlFontSizeA
    #define xlFontSetSize xlFontSetSizeA
    #define xlFontItalic xlFontItalicA
    #define xlFontSetItalic xlFontSetItalicA
    #define xlFontStrikeOut xlFontStrikeOutA
    #define xlFontSetStrikeOut xlFontSetStrikeOutA
    #define xlFontColor xlFontColorA
    #define xlFontSetColor xlFontSetColorA
    #define xlFontBold xlFontBoldA
    #define xlFontSetBold xlFontSetBoldA
    #define xlFontScript xlFontScriptA
    #define xlFontSetScript xlFontSetScriptA
    #define xlFontUnderline xlFontUnderlineA
    #define xlFontSetUnderline xlFontSetUnderlineA
    #define xlFontName xlFontNameA
    #define xlFontSetName xlFontSetNameA

    #define xlFormatFont xlFormatFontA
    #define xlFormatSetFont xlFormatSetFontA
    #define xlFormatNumFormat xlFormatNumFormatA
    #define xlFormatSetNumFormat xlFormatSetNumFormatA
    #define xlFormatAlignH xlFormatAlignHA
    #define xlFormatSetAlignH xlFormatSetAlignHA
    #define xlFormatAlignV xlFormatAlignVA
    #define xlFormatSetAlignV xlFormatSetAlignVA
    #define xlFormatWrap xlFormatWrapA
    #define xlFormatSetWrap xlFormatSetWrapA
    #define xlFormatRotation xlFormatRotationA
    #define xlFormatSetRotation xlFormatSetRotationA
    #define xlFormatIndent xlFormatIndentA
    #define xlFormatSetIndent xlFormatSetIndentA
    #define xlFormatShrinkToFit xlFormatShrinkToFitA
    #define xlFormatSetShrinkToFit xlFormatSetShrinkToFitA
    #define xlFormatSetBorder xlFormatSetBorderA
    #define xlFormatSetBorderColor xlFormatSetBorderColorA
    #define xlFormatBorderLeft xlFormatBorderLeftA
    #define xlFormatSetBorderLeft xlFormatSetBorderLeftA
    #define xlFormatBorderRight xlFormatBorderRightA
    #define xlFormatSetBorderRight xlFormatSetBorderRightA
    #define xlFormatBorderTop xlFormatBorderTopA
    #define xlFormatSetBorderTop xlFormatSetBorderTopA
    #define xlFormatBorderBottom xlFormatBorderBottomA
    #define xlFormatSetBorderBottom xlFormatSetBorderBottomA
    #define xlFormatBorderLeftColor xlFormatBorderLeftColorA
    #define xlFormatSetBorderLeftColor xlFormatSetBorderLeftColorA
    #define xlFormatBorderRightColor xlFormatBorderRightColorA
    #define xlFormatSetBorderRightColor xlFormatSetBorderRightColorA
    #define xlFormatBorderTopColor xlFormatBorderTopColorA
    #define xlFormatSetBorderTopColor xlFormatSetBorderTopColorA
    #define xlFormatBorderBottomColor xlFormatBorderBottomColorA
    #define xlFormatSetBorderBottomColor xlFormatSetBorderBottomColorA
    #define xlFormatBorderDiagonal xlFormatBorderDiagonalA
    #define xlFormatSetBorderDiagonal xlFormatSetBorderDiagonalA
    #define xlFormatBorderDiagonalStyle xlFormatBorderDiagonalStyleA
    #define xlFormatSetBorderDiagonalStyle xlFormatSetBorderDiagonalStyleA
    #define xlFormatBorderDiagonalColor xlFormatBorderDiagonalColorA
    #define xlFormatSetBorderDiagonalColor xlFormatSetBorderDiagonalColorA
    #define xlFormatFillPattern xlFormatFillPatternA
    #define xlFormatSetFillPattern xlFormatSetFillPatternA
    #define xlFormatPatternForegroundColor xlFormatPatternForegroundColorA
    #define xlFormatSetPatternForegroundColor xlFormatSetPatternForegroundColorA
    #define xlFormatPatternBackgroundColor xlFormatPatternBackgroundColorA
    #define xlFormatSetPatternBackgroundColor xlFormatSetPatternBackgroundColorA
    #define xlFormatLocked xlFormatLockedA
    #define xlFormatSetLocked xlFormatSetLockedA
    #define xlFormatHidden xlFormatHiddenA
    #define xlFormatSetHidden xlFormatSetHiddenA

    #define xlAutoFilterGetRef xlAutoFilterGetRefA
    #define xlAutoFilterSetRef xlAutoFilterSetRefA
    #define xlAutoFilterColumn xlAutoFilterColumnA
    #define xlAutoFilterColumnSize xlAutoFilterColumnSizeA
    #define xlAutoFilterColumnByIndex xlAutoFilterColumnByIndexA
    #define xlAutoFilterGetSortRange xlAutoFilterGetSortRangeA
    #define xlAutoFilterGetSort xlAutoFilterGetSortA
    #define xlAutoFilterSetSort xlAutoFilterSetSortA
    #define xlAutoFilterAddSort xlAutoFilterAddSortA

    #define xlFilterColumnIndex xlFilterColumnIndexA
    #define xlFilterColumnFilterType xlFilterColumnFilterTypeA
    #define xlFilterColumnFilterSize xlFilterColumnFilterSizeA
    #define xlFilterColumnFilter xlFilterColumnFilterA
    #define xlFilterColumnAddFilter xlFilterColumnAddFilterA
    #define xlFilterColumnGetTop10 xlFilterColumnGetTop10A
    #define xlFilterColumnSetTop10 xlFilterColumnSetTop10A
    #define xlFilterColumnGetCustomFilter xlFilterColumnGetCustomFilterA
    #define xlFilterColumnSetCustomFilter xlFilterColumnSetCustomFilterA
    #define xlFilterColumnSetCustomFilterEx xlFilterColumnSetCustomFilterExA
    #define xlFilterColumnClear xlFilterColumnClearA

    #define xlRichStringAddFont xlRichStringAddFontA
    #define xlRichStringAddText xlRichStringAddTextA
    #define xlRichStringGetText xlRichStringGetTextA
    #define xlRichStringTextSize xlRichStringTextSizeA

    #define xlFormControlObjectType xlFormControlObjectTypeA
    #define xlFormControlChecked xlFormControlCheckedA
    #define xlFormControlSetChecked xlFormControlSetCheckedA
    #define xlFormControlFmlaGroup xlFormControlFmlaGroupA
    #define xlFormControlSetFmlaGroup xlFormControlSetFmlaGroupA
    #define xlFormControlFmlaLink xlFormControlFmlaLinkA
    #define xlFormControlSetFmlaLink xlFormControlSetFmlaLinkA
    #define xlFormControlFmlaRange xlFormControlFmlaRangeA
    #define xlFormControlSetFmlaRange xlFormControlSetFmlaRangeA
    #define xlFormControlFmlaTxbx xlFormControlFmlaTxbxA
    #define xlFormControlSetFmlaTxbx xlFormControlSetFmlaTxbxA
    #define xlFormControlName xlFormControlNameA
    #define xlFormControlLinkedCell xlFormControlLinkedCellA
    #define xlFormControlListFillRange xlFormControlListFillRangeA
    #define xlFormControlMacro xlFormControlMacroA
    #define xlFormControlAltText xlFormControlAltTextA
    #define xlFormControlLocked xlFormControlLockedA
    #define xlFormControlDefaultSize xlFormControlDefaultSizeA
    #define xlFormControlPrint xlFormControlPrintA
    #define xlFormControlDisabled xlFormControlDisabledA
    #define xlFormControlItem xlFormControlItemA
    #define xlFormControlItemSize xlFormControlItemSizeA
    #define xlFormControlAddItem xlFormControlAddItemA
    #define xlFormControlInsertItem xlFormControlInsertItemA
    #define xlFormControlClearItems xlFormControlClearItemsA
    #define xlFormControlDropLines xlFormControlDropLinesA
    #define xlFormControlSetDropLines xlFormControlSetDropLinesA
    #define xlFormControlDx xlFormControlDxA
    #define xlFormControlSetDx xlFormControlSetDxA
    #define xlFormControlFirstButton xlFormControlFirstButtonA
    #define xlFormControlSetFirstButton xlFormControlSetFirstButtonA
    #define xlFormControlHoriz xlFormControlHorizA
    #define xlFormControlSetHoriz xlFormControlSetHorizA
    #define xlFormControlInc xlFormControlIncA
    #define xlFormControlSetInc xlFormControlSetIncA
    #define xlFormControlGetMax xlFormControlGetMaxA
    #define xlFormControlSetMax xlFormControlSetMaxA
    #define xlFormControlGetMin xlFormControlGetMinA
    #define xlFormControlSetMin xlFormControlSetMinA
    #define xlFormControlMultiSel xlFormControlMultiSelA
    #define xlFormControlSetMultiSel xlFormControlSetMultiSelA
    #define xlFormControlSel xlFormControlSelA
    #define xlFormControlSetSel xlFormControlSetSelA
    #define xlFormControlFromAnchor xlFormControlFromAnchorA
    #define xlFormControlToAnchor xlFormControlToAnchorA

    #define xlConditionalFormattingAddRange xlConditionalFormattingAddRangeA
    #define xlConditionalFormattingAddRule xlConditionalFormattingAddRuleA
    #define xlConditionalFormattingAddTopRule xlConditionalFormattingAddTopRuleA
    #define xlConditionalFormattingAddOpNumRule xlConditionalFormattingAddOpNumRuleA
    #define xlConditionalFormattingAddOpStrRule xlConditionalFormattingAddOpStrRuleA
    #define xlConditionalFormattingAddAboveAverageRule xlConditionalFormattingAddAboveAverageRuleA
    #define xlConditionalFormattingAddTimePeriodRule xlConditionalFormattingAddTimePeriodRuleA
    #define xlConditionalFormattingAdd2ColorScaleRule xlConditionalFormattingAdd2ColorScaleRuleA
    #define xlConditionalFormattingAdd2ColorScaleFormulaRule xlConditionalFormattingAdd2ColorScaleFormulaRuleA
    #define xlConditionalFormattingAdd3ColorScaleRule xlConditionalFormattingAdd3ColorScaleRuleA
    #define xlConditionalFormattingAdd3ColorScaleFormulaRule xlConditionalFormattingAdd3ColorScaleFormulaRuleA

    #define xlConditionalFormatFont xlConditionalFormatFontA
    #define xlConditionalFormatNumFormat xlConditionalFormatNumFormatA
    #define xlConditionalFormatSetNumFormat xlConditionalFormatSetNumFormatA
    #define xlConditionalFormatCustomNumFormat xlConditionalFormatCustomNumFormatA
    #define xlConditionalFormatSetCustomNumFormat xlConditionalFormatSetCustomNumFormatA
    #define xlConditionalFormatSetBorder xlConditionalFormatSetBorderA
    #define xlConditionalFormatSetBorderColor xlConditionalFormatSetBorderColorA
    #define xlConditionalFormatBorderLeft xlConditionalFormatBorderLeftA
    #define xlConditionalFormatSetBorderLeft xlConditionalFormatSetBorderLeftA
    #define xlConditionalFormatBorderRight xlConditionalFormatBorderRightA
    #define xlConditionalFormatSetBorderRight xlConditionalFormatSetBorderRightA
    #define xlConditionalFormatBorderTop xlConditionalFormatBorderTopA
    #define xlConditionalFormatSetBorderTop xlConditionalFormatSetBorderTopA
    #define xlConditionalFormatBorderBottom xlConditionalFormatBorderBottomA
    #define xlConditionalFormatSetBorderBottom xlConditionalFormatSetBorderBottomA
    #define xlConditionalFormatBorderLeftColor xlConditionalFormatBorderLeftColorA
    #define xlConditionalFormatSetBorderLeftColor xlConditionalFormatSetBorderLeftColorA
    #define xlConditionalFormatBorderRightColor xlConditionalFormatBorderRightColorA
    #define xlConditionalFormatSetBorderRightColor xlConditionalFormatSetBorderRightColorA
    #define xlConditionalFormatBorderTopColor xlConditionalFormatBorderTopColorA
    #define xlConditionalFormatSetBorderTopColor xlConditionalFormatSetBorderTopColorA
    #define xlConditionalFormatBorderBottomColor xlConditionalFormatBorderBottomColorA
    #define xlConditionalFormatSetBorderBottomColor xlConditionalFormatSetBorderBottomColorA
    #define xlConditionalFormatFillPattern xlConditionalFormatFillPatternA
    #define xlConditionalFormatSetFillPattern xlConditionalFormatSetFillPatternA
    #define xlConditionalFormatPatternForegroundColor xlConditionalFormatPatternForegroundColorA
    #define xlConditionalFormatSetPatternForegroundColor xlConditionalFormatSetPatternForegroundColorA
    #define xlConditionalFormatPatternBackgroundColor xlConditionalFormatPatternBackgroundColorA
    #define xlConditionalFormatSetPatternBackgroundColor xlConditionalFormatSetPatternBackgroundColorA

    #define xlCorePropertiesTitle xlCorePropertiesTitleA
    #define xlCorePropertiesSetTitle xlCorePropertiesSetTitleA
    #define xlCorePropertiesSubject xlCorePropertiesSubjectA
    #define xlCorePropertiesSetSubject xlCorePropertiesSetSubjectA
    #define xlCorePropertiesCreator xlCorePropertiesCreatorA
    #define xlCorePropertiesSetCreator xlCorePropertiesSetCreatorA
    #define xlCorePropertiesLastModifiedBy xlCorePropertiesLastModifiedByA
    #define xlCorePropertiesSetLastModifiedBy xlCorePropertiesSetLastModifiedByA
    #define xlCorePropertiesCreated xlCorePropertiesCreatedA
    #define xlCorePropertiesSetCreated xlCorePropertiesSetCreatedA
    #define xlCorePropertiesCreatedAsDouble xlCorePropertiesCreatedAsDoubleA
    #define xlCorePropertiesSetCreatedAsDouble xlCorePropertiesSetCreatedAsDoubleA
    #define xlCorePropertiesModified xlCorePropertiesModifiedA
    #define xlCorePropertiesSetModified xlCorePropertiesSetModifiedA
    #define xlCorePropertiesModifiedAsDouble xlCorePropertiesModifiedAsDoubleA
    #define xlCorePropertiesSetModifiedAsDouble xlCorePropertiesSetModifiedAsDoubleA
    #define xlCorePropertiesTags xlCorePropertiesTagsA
    #define xlCorePropertiesSetTags xlCorePropertiesSetTagsA
    #define xlCorePropertiesCategories xlCorePropertiesCategoriesA
    #define xlCorePropertiesSetCategories xlCorePropertiesSetCategoriesA
    #define xlCorePropertiesComments xlCorePropertiesCommentsA
    #define xlCorePropertiesSetComments xlCorePropertiesSetCommentsA
    #define xlCorePropertiesRemoveAll xlCorePropertiesRemoveAllA

    #define xlTableName xlTableNameA
    #define xlTableSetName xlTableSetNameA
    #define xlTableRef xlTableRefA
    #define xlTableSetRef xlTableSetRefA
    #define xlTableAutoFilter xlTableAutoFilterA
    #define xlTableStyle xlTableStyleA
    #define xlTableSetStyle xlTableSetStyleA
    #define xlTableShowRowStripes xlTableShowRowStripesA
    #define xlTableSetShowRowStripes xlTableSetShowRowStripesA
    #define xlTableShowColumnStripes xlTableShowColumnStripesA
    #define xlTableSetShowColumnStripes xlTableSetShowColumnStripesA
    #define xlTableShowFirstColumn xlTableShowFirstColumnA
    #define xlTableSetShowFirstColumn xlTableSetShowFirstColumnA
    #define xlTableShowLastColumn xlTableShowLastColumnA
    #define xlTableSetShowLastColumn xlTableSetShowLastColumnA
    #define xlTableColumnSize xlTableColumnSizeA
    #define xlTableColumnName xlTableColumnNameA
    #define xlTableSetColumnName xlTableSetColumnNameA

#endif

#endif
