///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                  LibXL Delphi/Lazarus unit version 5.0.0                  //
//                                                                           //
//                  Copyright (c) 2008 - 2025 XLware s.r.o.                  //
//                                                                           //
//    THIS FILE AND THE SOFTWARE CONTAINED HEREIN IS PROVIDED 'AS IS' AND    //
//                   COMES WITH NO WARRANTIES OF ANY KIND.                   //
//                                                                           //
//      For more information on the LibXL, go to https://www.libxl.com       //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

unit LibXL;

{$Z4}

interface

uses
  System.SysUtils;

type
  AlignH = (ALIGNH_GENERAL, ALIGNH_LEFT, ALIGNH_CENTER, ALIGNH_RIGHT, ALIGNH_FILL, ALIGNH_JUSTIFY, ALIGNH_MERGE, ALIGNH_DISTRIBUTED);
  AlignV = (ALIGNV_TOP, ALIGNV_CENTER, ALIGNV_BOTTOM, ALIGNV_JUSTIFY, ALIGNV_DISTRIBUTED);

  BorderStyle = (BORDERSTYLE_NONE, BORDERSTYLE_THIN, BORDERSTYLE_MEDIUM, BORDERSTYLE_DASHED, BORDERSTYLE_DOTTED, BORDERSTYLE_THICK,
                 BORDERSTYLE_DOUBLE, BORDERSTYLE_HAIR, BORDERSTYLE_MEDIUMDASHED, BORDERSTYLE_DASHDOT, BORDERSTYLE_MEDIUMDASHDOT,
                 BORDERSTYLE_DASHDOTDOT, BORDERSTYLE_MEDIUMDASHDOTDOT, BORDERSTYLE_SLANTDASHDOT);
  BorderDiagonal = (BORDERDIAGONAL_NONE, BORDERDIAGONAL_DOWN, BORDERDIAGONAL_UP, BORDERDIAGONAL_BOTH);
  FillPattern = (FILLPATTERN_NONE, FILLPATTERN_SOLID, FILLPATTERN_GRAY50, FILLPATTERN_GRAY75, FILLPATTERN_GRAY25,
                 FILLPATTERN_HORSTRIPE, FILLPATTERN_VERSTRIPE, FILLPATTERN_REVDIAGSTRIPE, FILLPATTERN_DIAGSTRIPE,
                 FILLPATTERN_DIAGCROSSHATCH, FILLPATTERN_THICKDIAGCROSSHATCH, FILLPATTERN_THINHORSTRIPE, FILLPATTERN_THINVERSTRIPE,
                 FILLPATTERN_THINREVDIAGSTRIPE, FILLPATTERN_THINDIAGSTRIPE, FILLPATTERN_THINHORCROSSHATCH, FILLPATTERN_THINDIAGCROSSHATCH,
                 FILLPATTERN_GRAY12P5, FILLPATTERN_GRAY6P25);
  NumFormat = (NUMFORMAT_GENERAL, NUMFORMAT_NUMBER, NUMFORMAT_NUMBER_D2, NUMFORMAT_NUMBER_SEP, NUMFORMAT_NUMBER_SEP_D2,
               NUMFORMAT_CURRENCY_NEGBRA, NUMFORMAT_CURRENCY_NEGBRARED, NUMFORMAT_CURRENCY_D2_NEGBRA, NUMFORMAT_CURRENCY_D2_NEGBRARED,
               NUMFORMAT_PERCENT, NUMFORMAT_PERCENT_D2, NUMFORMAT_SCIENTIFIC_D2, NUMFORMAT_FRACTION_ONEDIG, NUMFORMAT_FRACTION_TWODIG,
               NUMFORMAT_DATE, NUMFORMAT_CUSTOM_D_MON_YY, NUMFORMAT_CUSTOM_D_MON, NUMFORMAT_CUSTOM_MON_YY,
               NUMFORMAT_CUSTOM_HMM_AM, NUMFORMAT_CUSTOM_HMMSS_AM, NUMFORMAT_CUSTOM_HMM, NUMFORMAT_CUSTOM_HMMSS,
               NUMFORMAT_CUSTOM_MDYYYY_HMM,
               NUMFORMAT_NUMBER_SEP_NEGBRA = 37, NUMFORMAT_NUMBER_SEP_NEGBRARED,
               NUMFORMAT_NUMBER_D2_SEP_NEGBRA, NUMFORMAT_NUMBER_D2_SEP_NEGBRARED, NUMFORMAT_ACCOUNT, NUMFORMAT_ACCOUNTCUR,
               NUMFORMAT_ACCOUNT_D2, NUMFORMAT_ACCOUNT_D2_CUR, NUMFORMAT_CUSTOM_MMSS, NUMFORMAT_CUSTOM_H0MMSS,
               NUMFORMAT_CUSTOM_MMSS0, NUMFORMAT_CUSTOM_000P0E_PLUS0, NUMFORMAT_TEXT);
  Color = (COLOR_BLACK = 8, COLOR_WHITE, COLOR_RED, COLOR_BRIGHTGREEN, COLOR_BLUE, COLOR_YELLOW, COLOR_PINK, COLOR_TURQUOISE, COLOR_DARKRED,
           COLOR_GREEN, COLOR_DARKBLUE, COLOR_DARKYELLOW, COLOR_VIOLET, COLOR_TEAL, COLOR_GRAY25, COLOR_GRAY50, COLOR_PERIWINKLE_CF,
           COLOR_PLUM_CF, COLOR_IVORY_CF, COLOR_LIGHTTURQUOISE_CF, COLOR_DARKPURPLE_CF, COLOR_CORAL_CF, COLOR_OCEANBLUE_CF, COLOR_ICEBLUE_CF,
           COLOR_DARKBLUE_CL, COLOR_PINK_CL, COLOR_YELLOW_CL, COLOR_TURQUOISE_CL, COLOR_VIOLET_CL, COLOR_DARKRED_CL, COLOR_TEAL_CL,
           COLOR_BLUE_CL, COLOR_SKYBLUE, COLOR_LIGHTTURQUOISE, COLOR_LIGHTGREEN, COLOR_LIGHTYELLOW, COLOR_PALEBLUE, COLOR_ROSE, COLOR_LAVENDER,
           COLOR_TAN, COLOR_LIGHTBLUE, COLOR_AQUA, COLOR_LIME, COLOR_GOLD, COLOR_LIGHTORANGE, COLOR_ORANGE, COLOR_BLUEGRAY, COLOR_GRAY40,
           COLOR_DARKTEAL, COLOR_SEAGREEN, COLOR_DARKGREEN, COLOR_OLIVEGREEN, COLOR_BROWN, COLOR_PLUM, COLOR_INDIGO, COLOR_GRAY80,
           COLOR_DEFAULT_FOREGROUND = $0040, COLOR_DEFAULT_BACKGROUND = $0041, COLOR_TOOLTIP = $0051, COLOR_NONE = $7F, COLOR_AUTO = $7FFF);

  SheetType = (SHEETTYPE_SHEET, SHEETTYPE_CHART, SHEETTYPE_UNKNOWN);

  CellType = (CELLTYPE_EMPTY, CELLTYPE_NUMBER, CELLTYPE_STRING, CELLTYPE_BOOLEAN, CELLTYPE_BLANK, CELLTYPE_ERROR, CELLTYPE_STRICTDATE);
  ErrorType = (ERRORTYPE_NULL = $00, ERRORTYPE_DIV_0 = $07, ERRORTYPE_VALUE = $0F, ERRORTYPE_REF = $17, ERRORTYPE_NAME = $1D,
               ERRORTYPE_NUM = $24, ERRORTYPE_NA = $2A, ERRORTYPE_NOERROR = $FF);
  PictureType = (PICTURETYPE_PNG, PICTURETYPE_JPEG, PICTURETYPE_GIF, PICTURETYPE_WMF, PICTURETYPE_DIB, PICTURETYPE_EMF,
                 PICTURETYPE_PICT, PICTURETYPE_TIFF, PICTURETYPE_SVG, PICTURETYPE_ERROR = $FF);
  SheetState = (SHEETSTATE_VISIBLE, SHEETSTATE_HIDDEN, SHEETSTATE_VERYHIDDEN);
  Paper = (PAPER_DEFAULT, PAPER_LETTER, PAPER_LETTERSMALL, PAPER_TABLOID, PAPER_LEDGER, PAPER_LEGAL, PAPER_STATEMENT, PAPER_EXECUTIVE, PAPER_A3,
           PAPER_A4, PAPER_A4SMALL, PAPER_A5, PAPER_B4, PAPER_B5, PAPER_FOLIO, PAPER_QUATRO, PAPER_10x14, PAPER_10x17, PAPER_NOTE, PAPER_ENVELOPE_9,
           PAPER_ENVELOPE_10, PAPER_ENVELOPE_11, PAPER_ENVELOPE_12, PAPER_ENVELOPE_14, PAPER_C_SIZE, PAPER_D_SIZE, PAPER_E_SIZE, PAPER_ENVELOPE_DL,
           PAPER_ENVELOPE_C5, PAPER_ENVELOPE_C3, PAPER_ENVELOPE_C4, PAPER_ENVELOPE_C6, PAPER_ENVELOPE_C65, PAPER_ENVELOPE_B4, PAPER_ENVELOPE_B5,
           PAPER_ENVELOPE_B6, PAPER_ENVELOPE, PAPER_ENVELOPE_MONARCH, PAPER_US_ENVELOPE, PAPER_FANFOLD, PAPER_GERMAN_STD_FANFOLD,
           PAPER_GERMAN_LEGAL_FANFOLD, PAPER_B4_ISO, PAPER_JAPANESE_POSTCARD, PAPER_9x11, PAPER_10x11, PAPER_15x11, PAPER_ENVELOPE_INVITE,
           PAPER_US_LETTER_EXTRA = 50, PAPER_US_LEGAL_EXTRA, PAPER_US_TABLOID_EXTRA, PAPER_A4_EXTRA, PAPER_LETTER_TRANSVERSE, PAPER_A4_TRANSVERSE,
           PAPER_LETTER_EXTRA_TRANSVERSE, PAPER_SUPERA, PAPER_SUPERB, PAPER_US_LETTER_PLUS, PAPER_A4_PLUS, PAPER_A5_TRANSVERSE, PAPER_B5_TRANSVERSE,
           PAPER_A3_EXTRA, PAPER_A5_EXTRA, PAPER_B5_EXTRA, PAPER_A2, PAPER_A3_TRANSVERSE, PAPER_A3_EXTRA_TRANSVERSE, PAPER_JAPANESE_DOUBLE_POSTCARD,
           PAPER_A6, PAPER_JAPANESE_ENVELOPE_KAKU2, PAPER_JAPANESE_ENVELOPE_KAKU3, PAPER_JAPANESE_ENVELOPE_CHOU3, PAPER_JAPANESE_ENVELOPE_CHOU4,
           PAPER_LETTER_ROTATED, PAPER_A3_ROTATED, PAPER_A4_ROTATED, PAPER_A5_ROTATED, PAPER_B4_ROTATED, PAPER_B5_ROTATED,
           PAPER_JAPANESE_POSTCARD_ROTATED, PAPER_DOUBLE_JAPANESE_POSTCARD_ROTATED, PAPER_A6_ROTATED, PAPER_JAPANESE_ENVELOPE_KAKU2_ROTATED,
           PAPER_JAPANESE_ENVELOPE_KAKU3_ROTATED, PAPER_JAPANESE_ENVELOPE_CHOU3_ROTATED, PAPER_JAPANESE_ENVELOPE_CHOU4_ROTATED, PAPER_B6,
           PAPER_B6_ROTATED, PAPER_12x11, PAPER_JAPANESE_ENVELOPE_YOU4, PAPER_JAPANESE_ENVELOPE_YOU4_ROTATED, PAPER_PRC16K, PAPER_PRC32K,
           PAPER_PRC32K_BIG, PAPER_PRC_ENVELOPE1, PAPER_PRC_ENVELOPE2, PAPER_PRC_ENVELOPE3, PAPER_PRC_ENVELOPE4, PAPER_PRC_ENVELOPE5,
           PAPER_PRC_ENVELOPE6, PAPER_PRC_ENVELOPE7, PAPER_PRC_ENVELOPE8, PAPER_PRC_ENVELOPE9, PAPER_PRC_ENVELOPE10, PAPER_PRC16K_ROTATED,
           PAPER_PRC32K_ROTATED, PAPER_PRC32KBIG_ROTATED, PAPER_PRC_ENVELOPE1_ROTATED, PAPER_PRC_ENVELOPE2_ROTATED, PAPER_PRC_ENVELOPE3_ROTATED,
           PAPER_PRC_ENVELOPE4_ROTATED, PAPER_PRC_ENVELOPE5_ROTATED, PAPER_PRC_ENVELOPE6_ROTATED, PAPER_PRC_ENVELOPE7_ROTATED,
           PAPER_PRC_ENVELOPE8_ROTATED, PAPER_PRC_ENVELOPE9_ROTATED, PAPER_PRC_ENVELOPE10_ROTATED);
  Underline = (UNDERLINE_NONE, UNDERLINE_SINGLE, UNDERLINE_DOUBLE, UNDERLINE_SINGLEACC = $21, UNDERLINE_DOUBLEACC = $22);
  Script = (SCRIPT_NORMAL, SCRIPT_SUPER, SCRIPT_SUB);
  Scope = (SCOPE_UNDEFINED = -2, SCOPE_WORKBOOK = -1);
  Position = (POSITION_MOVE_AND_SIZE, POSITION_ONLY_MOVE, POSITION_ABSOLUTE);
  Op = (OPERATOR_EQUAL, OPERATOR_GREATER_THAN, OPERATOR_GREATER_THAN_OR_EQUAL, OPERATOR_LESS_THAN, OPERATOR_LESS_THAN_OR_EQUAL, OPERATOR_NOT_EQUAL);

  Filter = (FILTER_VALUE, FILTER_TOP10, FILTER_CUSTOM, FILTER_DYNAMIC, FILTER_COLOR, FILTER_ICON, FILTER_EXT, FILTER_NOT_SET);

  EnhancedProtection = (PROT_DEFAULT = -1, PROT_ALL = 0, PROT_OBJECTS = 1, PROT_SCENARIOS = 2, PROT_FORMAT_CELLS = 4, PROT_FORMAT_COLUMNS = 8, PROT_FORMAT_ROWS = 16,
                        PROT_INSERT_COLUMNS = 32, PROT_INSERT_ROWS = 64, PROT_INSERT_HYPERLINKS = 128, PROT_DELETE_COLUMNS = 256, PROT_DELETE_ROWS = 512,
                        PROT_SEL_LOCKED_CELLS = 1024, PROT_SORT = 2048, PROT_AUTOFILTER = 4096, PROT_PIVOTTABLES = 8192, PROT_SEL_UNLOCKED_CELLS = 16384);
  IgnoredError = (IERR_NO_ERROR = 0, IERR_EVAL_ERROR = 1, IERR_EMPTY_CELLREF = 2, IERR_NUMBER_STORED_AS_TEXT = 4, IERR_INCONSIST_RANGE = 8,
                  IERR_INCONSIST_FMLA = 16, IERR_TWODIG_TEXTYEAR = 32, IERR_UNLOCK_FMLA = 64, IERR_DATA_VALIDATION = 128);

  DataValidationType = (VALIDATION_TYPE_NONE, VALIDATION_TYPE_WHOLE, VALIDATION_TYPE_DECIMAL, VALIDATION_TYPE_LIST,
                        VALIDATION_TYPE_DATE, VALIDATION_TYPE_TIME, VALIDATION_TYPE_TEXTLENGTH, VALIDATION_TYPE_CUSTOM);

  DataValidationOperator = (VALIDATION_OP_BETWEEN, VALIDATION_OP_NOTBETWEEN, VALIDATION_OP_EQUAL, VALIDATION_OP_NOTEQUAL,
                            VALIDATION_OP_LESSTHAN, VALIDATION_OP_LESSTHANOREQUAL, VALIDATION_OP_GREATERTHAN, VALIDATION_OP_GREATERTHANOREQUAL);

  DataValidationErrorStyle = (VALIDATION_ERRSTYLE_STOP, VALIDATION_ERRSTYLE_WARNING, VALIDATION_ERRSTYLE_INFORMATION);

  CalcModeType = (CALCMODE_MANUAL, CALCMODE_AUTO, CALCMODE_AUTONOTABLE);
  CheckedType = (CHECKEDTYPE_UNCHECKED, CHECKEDTYPE_CHECKED, CHECKEDTYPE_MIXED);
  ObjectType = (OBJECT_UNKNOWN, OBJECT_BUTTON, OBJECT_CHECKBOX, OBJECT_DROP, OBJECT_GBOX, OBJECT_LABEL, OBJECT_LIST, OBJECT_RADIO, OBJECT_SCROLL, OBJECT_SPIN, OBJECT_EDITBOX, OBJECT_DIALOG);
  CFormatType = (CFORMAT_BEGINWITH, CFORMAT_CONTAINSBLANKS, CFORMAT_CONTAINSERRORS, CFORMAT_CONTAINSTEXT, CFORMAT_DUPLICATEVALUES, CFORMAT_ENDSWITH, CFORMAT_EXPRESSION,
                 CFORMAT_NOTCONTAINSBLANKS, CFORMAT_NOTCONTAINSERRORS, CFORMAT_NOTCONTAINSTEXT, CFORMAT_UNIQUEVALUES);
  CFormatOperator = (CFOPERATOR_LESSTHAN, CFOPERATOR_LESSTHANOREQUAL, CFOPERATOR_EQUAL, CFOPERATOR_NOTEQUAL, CFOPERATOR_GREATERTHANOREQUAL, CFOPERATOR_GREATERTHAN, CFOPERATOR_BETWEEN,
                     CFOPERATOR_NOTBETWEEN, CFOPERATOR_CONTAINSTEXT, CFOPERATOR_NOTCONTAINS, CFOPERATOR_BEGINSWITH, CFOPERATOR_ENDSWITH);
  CFormatTimePeriod = (CFTP_LAST7DAYS, CFTP_LASTMONTH, CFTP_LASTWEEK, CFTP_NEXTMONTH, CFTP_NEXTWEEK, CFTP_THISMONTH, CFTP_THISWEEK, CFTP_TODAY, CFTP_TOMORROW, CFTP_YESTERDAY);
  CFVOType = (CFVO_MIN, CFVO_MAX, CFVO_FORMULA, CFVO_NUMBER, CFVO_PERCENT, CFVO_PERCENTILE);
  CellStyle = (CELLSTYLE_NORMAL, CELLSTYLE_BAD, CELLSTYLE_GOOD, CELLSTYLE_NEUTRAL, CELLSTYLE_CALC, CELLSTYLE_CHECKCELL, CELLSTYLE_EXPLANATORY, CELLSTYLE_INPUT, CELLSTYLE_OUTPUT,
               CELLSTYLE_HYPERLINK, CELLSTYLE_LINKEDCELL, CELLSTYLE_NOTE, CELLSTYLE_WARNING, CELLSTYLE_TITLE, CELLSTYLE_HEADING1, CELLSTYLE_HEADING2, CELLSTYLE_HEADING3, CELLSTYLE_HEADING4, CELLSTYLE_TOTAL,
               CELLSTYLE_20ACCENT1, CELLSTYLE_40ACCENT1, CELLSTYLE_60ACCENT1, CELLSTYLE_ACCENT1, CELLSTYLE_20ACCENT2, CELLSTYLE_40ACCENT2, CELLSTYLE_60ACCENT2, CELLSTYLE_ACCENT2,
               CELLSTYLE_20ACCENT3, CELLSTYLE_40ACCENT3, CELLSTYLE_60ACCENT3, CELLSTYLE_ACCENT3, CELLSTYLE_20ACCENT4, CELLSTYLE_40ACCENT4, CELLSTYLE_60ACCENT4, CELLSTYLE_ACCENT4,
               CELLSTYLE_20ACCENT5, CELLSTYLE_40ACCENT5, CELLSTYLE_60ACCENT5, CELLSTYLE_ACCENT5, CELLSTYLE_20ACCENT6, CELLSTYLE_40ACCENT6, CELLSTYLE_60ACCENT6, CELLSTYLE_ACCENT6,
               CELLSTYLE_COMMA, CELLSTYLE_COMMA0, CELLSTYLE_CURRENCY, CELLSTYLE_CURRENCY0, CELLSTYLE_PERCENT);

  TableStyle = (TABLESTYLE_NONE, TABLESTYLE_LIGHT1, TABLESTYLE_LIGHT2, TABLESTYLE_LIGHT3, TABLESTYLE_LIGHT4, TABLESTYLE_LIGHT5, TABLESTYLE_LIGHT6, TABLESTYLE_LIGHT7, TABLESTYLE_LIGHT8,
                TABLESTYLE_LIGHT9, TABLESTYLE_LIGHT10, TABLESTYLE_LIGHT11, TABLESTYLE_LIGHT12, TABLESTYLE_LIGHT13, TABLESTYLE_LIGHT14, TABLESTYLE_LIGHT15, TABLESTYLE_LIGHT16, TABLESTYLE_LIGHT17,
                TABLESTYLE_LIGHT18, TABLESTYLE_LIGHT19, TABLESTYLE_LIGHT20, TABLESTYLE_LIGHT21, TABLESTYLE_MEDIUM1, TABLESTYLE_MEDIUM2, TABLESTYLE_MEDIUM3, TABLESTYLE_MEDIUM4, TABLESTYLE_MEDIUM5,
                TABLESTYLE_MEDIUM6, TABLESTYLE_MEDIUM7, TABLESTYLE_MEDIUM8, TABLESTYLE_MEDIUM9, TABLESTYLE_MEDIUM10, TABLESTYLE_MEDIUM11, TABLESTYLE_MEDIUM12, TABLESTYLE_MEDIUM13, TABLESTYLE_MEDIUM14,
                TABLESTYLE_MEDIUM15, TABLESTYLE_MEDIUM16, TABLESTYLE_MEDIUM17, TABLESTYLE_MEDIUM18, TABLESTYLE_MEDIUM19, TABLESTYLE_MEDIUM20, TABLESTYLE_MEDIUM21, TABLESTYLE_MEDIUM22, TABLESTYLE_MEDIUM23,
                TABLESTYLE_MEDIUM24, TABLESTYLE_MEDIUM25, TABLESTYLE_MEDIUM26, TABLESTYLE_MEDIUM27, TABLESTYLE_MEDIUM28, TABLESTYLE_DARK1, TABLESTYLE_DARK2, TABLESTYLE_DARK3, TABLESTYLE_DARK4,
                TABLESTYLE_DARK5, TABLESTYLE_DARK6, TABLESTYLE_DARK7, TABLESTYLE_DARK8, TABLESTYLE_DARK9, TABLESTYLE_DARK10, TABLESTYLE_DARK11);

  BookHandle = Pointer;
  SheetHandle = Pointer;
  FormatHandle = Pointer;
  FontHandle = Pointer;
  RichStringHandle = Pointer;
  PFormatHandle = ^FormatHandle;
  PFontHandle = ^FontHandle;
  AutoFilterHandle = Pointer;
  FilterColumnHandle = Pointer;
  ConditionalFormatHandle = Pointer;
  FormControlHandle = Pointer;
  ConditionalFormattingHandle = Pointer;
  CorePropertiesHandle = Pointer;
  TableHandle = Pointer;
  PBytes = ^TBytes;
  PPBytes = ^PBytes;

////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                                 Book
//
////////////////////////////////////////////////////////////////////////////////////////////////////

function xlCreateBookC: BookHandle; cdecl;
external 'libxl' name 'xlCreateBookCW';

function xlCreateXMLBookC: BookHandle; cdecl;
external 'libxl' name 'xlCreateXMLBookCW';

function xlBookLoad(handle: BookHandle; filename: PWideChar): Integer; cdecl;
external 'libxl' name 'xlBookLoadW';

function xlBookSave(handle: BookHandle; filename: PWideChar): Integer; cdecl;
external 'libxl' name 'xlBookSaveW';

function xlBookLoadUsingTempFile(handle: BookHandle; filename, tempFile: PWideChar): Integer; cdecl;
external 'libxl' name 'xlBookLoadUsingTempFileW';

function xlBookSaveUsingTempFile(handle: BookHandle; filename: PWideChar; useTempFile: Integer): Integer; cdecl;
external 'libxl' name 'xlBookSaveUsingTempFileW';

function xlBookLoadPartially(handle: BookHandle; filename: PWideChar; sheetIndex, firstRow, lastRow, keepAllSheets: Integer): Integer; cdecl;
external 'libxl' name 'xlBookLoadPartiallyW';

function xlBookLoadPartiallyUsingTempFile(handle: BookHandle; filename: PWideChar; sheetIndex, firstRow, lastRow: Integer; tempFile: PWideChar; keepAllSheets: Integer): Integer; cdecl;
external 'libxl' name 'xlBookLoadPartiallyUsingTempFileW';

function xlBookLoadWithoutEmptyCells(handle: BookHandle; filename: PWideChar): Integer; cdecl;
external 'libxl' name 'xlBookLoadWithoutEmptyCellsW';

function xlBookLoadInfo(handle: BookHandle; filename: PWideChar): Integer; cdecl;
external 'libxl' name 'xlBookLoadInfoW';

function xlBookLoadRaw(handle: BookHandle; data: PBytes; size: Cardinal): Integer; cdecl;
external 'libxl' name 'xlBookLoadRawW';

function xlBookLoadRawPartially(handle: BookHandle; data: PBytes; size: Cardinal; sheetIndex, firstRow, lastRow, keepAllSheets: Integer): Integer; cdecl;
external 'libxl' name 'xlBookLoadRawPartiallyW';

function xlBookSaveRaw(handle: BookHandle; data: PPBytes; size: PCardinal): Integer; cdecl;
external 'libxl' name 'xlBookSaveRawW';

procedure xlBookSetPassword(handle: BookHandle; password: PWideChar); cdecl;
external 'libxl' name 'xlBookSetPasswordW';

function xlBookAddSheet(handle: BookHandle; name: PWideChar; initSheet: SheetHandle): SheetHandle; cdecl;
external 'libxl' name 'xlBookAddSheetW';

function xlBookInsertSheet(handle: BookHandle; index: Integer; name: PWideChar; initSheet: SheetHandle): SheetHandle; cdecl;
external 'libxl' name 'xlBookInsertSheetW';

function xlBookGetSheet(handle: BookHandle; index: Integer): SheetHandle; cdecl;
external 'libxl' name 'xlBookGetSheetW';

function xlBookGetSheetName(handle: BookHandle; index: Integer): PWideChar; cdecl;
external 'libxl' name 'xlBookGetSheetNameW';

function xlBookSheetType(handle: BookHandle; index: Integer): Integer; cdecl;
external 'libxl' name 'xlBookSheetTypeW';

function xlBookMoveSheet(handle: BookHandle; srcIndex, dstIndex: Integer): Integer; cdecl;
external 'libxl' name 'xlBookMoveSheetW';

function xlBookDelSheet(handle: BookHandle; index: Integer): Integer; cdecl;
external 'libxl' name 'xlBookDelSheetW';

function xlBookSheetCount(handle: BookHandle): Integer; cdecl;
external 'libxl' name 'xlBookSheetCountW';

function xlBookAddFormat(handle: BookHandle; initFormat: FormatHandle): FormatHandle; cdecl;
external 'libxl' name 'xlBookAddFormatW';

function xlBookAddFormatFromStyle(handle: BookHandle; style: Integer): FormatHandle; cdecl;
external 'libxl' name 'xlBookAddFormatFromStyleW';

function xlBookAddFont(handle: BookHandle; initFont: FontHandle): FontHandle; cdecl;
external 'libxl' name 'xlBookAddFontW';

function xlBookAddRichString(handle: BookHandle): RichStringHandle; cdecl;
external 'libxl' name 'xlBookAddRichStringW';

function xlBookAddCustomNumFormat(handle: BookHandle; const customNumFormat: PWideChar): Integer; cdecl;
external 'libxl' name 'xlBookAddCustomNumFormatW';

function xlBookCustomNumFormat(handle: BookHandle; fmt: Integer): PWideChar; cdecl;
external 'libxl' name 'xlBookCustomNumFormatW';

function xlBookFormat(handle: BookHandle; index: Integer): FormatHandle; cdecl;
external 'libxl' name 'xlBookFormatW';

function xlBookFormatSize(handle: BookHandle): Integer; cdecl;
external 'libxl' name 'xlBookFormatSizeW';

function xlBookFont(handle: BookHandle; index: Integer): FontHandle; cdecl;
external 'libxl' name 'xlBookFontW';

function xlBookFontSize(handle: BookHandle): Integer; cdecl;
external 'libxl' name 'xlBookFontSizeW';

function xlBookAddConditionalFormat(handle: BookHandle): ConditionalFormatHandle; cdecl;
external 'libxl' name 'xlBookAddConditionalFormatW';

function xlBookDatePack(handle: BookHandle; year, month, day, hour, min, sec, msec: Integer): Double; cdecl;
external 'libxl' name 'xlBookDatePackW';

function xlBookDateUnpack(handle: BookHandle; value: Double; year, month, day, hour, min, sec, msec: PInteger): Integer; cdecl;
external 'libxl' name 'xlBookDateUnpackW';

function xlBookColorPack(handle: BookHandle; red, green, blue: Integer): Integer; cdecl;
external 'libxl' name 'xlBookColorPackW';

procedure xlBookColorUnpack(handle: BookHandle; color: Integer; red, green, blue: PInteger); cdecl;
external 'libxl' name 'xlBookColorUnpackW';

function xlBookActiveSheet(handle: BookHandle): Integer; cdecl;
external 'libxl' name 'xlBookActiveSheetW';

procedure xlBookSetActiveSheet(handle: BookHandle; index: Integer); cdecl;
external 'libxl' name 'xlBookSetActiveSheetW';

function xlBookPictureSize(handle: BookHandle): Integer; cdecl;
external 'libxl' name 'xlBookPictureSizeW';

function xlBookGetPicture(handle: BookHandle; index: Integer; data: PPBytes; size: PCardinal): Integer; cdecl;
external 'libxl' name 'xlBookGetPictureW';

function xlBookAddPicture(handle: BookHandle; filename: PWideChar): Integer; cdecl;
external 'libxl' name 'xlBookAddPictureW';

function xlBookAddPicture2(handle: BookHandle; data: PBytes; size: Cardinal): Integer; cdecl;
external 'libxl' name 'xlBookAddPicture2W';

function xlBookAddPictureAsLink(handle: BookHandle; filename: PWideChar; insert: Integer): Integer; cdecl;
external 'libxl' name 'xlBookAddPictureAsLinkW';

function xlBookDefaultFont(handle: BookHandle; fontSize: PInteger): PWideChar; cdecl;
external 'libxl' name 'xlBookDefaultFontW';

procedure xlBookSetDefaultFont(handle: BookHandle; const fontName: PWideChar; fontSize: Integer); cdecl;
external 'libxl' name 'xlBookSetDefaultFontW';

function xlBookRefR1C1(handle: BookHandle): Integer; cdecl;
external 'libxl' name 'xlBookRefR1C1W';

procedure xlBookSetRefR1C1(handle: BookHandle; refR1C1: Integer); cdecl;
external 'libxl' name 'xlBookSetRefR1C1W';

procedure xlBookSetKey(handle: BookHandle; const name, key: PWideChar); cdecl;
external 'libxl' name 'xlBookSetKeyW';

function xlBookRgbMode(handle: BookHandle): Integer; cdecl;
external 'libxl' name 'xlBookRgbModeW';

procedure xlBookSetRgbMode(handle: BookHandle; rgbMode: Integer); cdecl;
external 'libxl' name 'xlBookSetRgbModeW';

function xlBookCalcMode(handle: BookHandle): Integer; cdecl;
external 'libxl' name 'xlBookCalcModeW';

procedure xlBookSetCalcMode(handle: BookHandle; calcMode: Integer); cdecl;
external 'libxl' name 'xlBookSetCalcModeW';

function xlBookVersion(handle: BookHandle): Integer; cdecl;
external 'libxl' name 'xlBookVersionW';

function xlBookBiffVersion(handle: BookHandle): Integer; cdecl;
external 'libxl' name 'xlBookBiffVersionW';

function xlBookIsDate1904(handle: BookHandle): Integer; cdecl;
external 'libxl' name 'xlBookIsDate1904W';

procedure xlBookSetDate1904(handle: BookHandle; date1904: Integer); cdecl;
external 'libxl' name 'xlBookSetDate1904W';

function xlBookIsTemplate(handle: BookHandle): Integer; cdecl;
external 'libxl' name 'xlBookIsTemplateW';

procedure xlBookSetTemplate(handle: BookHandle; tmpl: Integer); cdecl;
external 'libxl' name 'xlBookSetTemplateW';

function xlBookIsWriteProtected(handle: BookHandle): Integer; cdecl;
external 'libxl' name 'xlBookIsWriteProtectedW';

function xlBookCoreProperties(handle: BookHandle): CorePropertiesHandle; cdecl;
external 'libxl' name 'xlBookCorePropertiesW';

function xlBookRemoveVBA(handle: BookHandle): Integer; cdecl;
external 'libxl' name 'xlBookRemoveVBAW';

function xlBookRemovePrinterSettings(handle: BookHandle): Integer; cdecl;
external 'libxl' name 'xlBookRemovePrinterSettingsW';

procedure xlBookRemoveAllPhonetics(handle: BookHandle); cdecl;
external 'libxl' name 'xlBookRemoveAllPhoneticsW';

function xlBookSetLocale(handle: BookHandle; const locale: PAnsiChar): Integer; cdecl;
external 'libxl' name 'xlBookSetLocaleW';

function xlBookErrorMessage(handle: BookHandle): PAnsiChar; cdecl;
external 'libxl' name 'xlBookErrorMessageW';

procedure xlBookRelease(handle: BookHandle); cdecl;
external 'libxl' name 'xlBookReleaseW';

////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                                     Sheet
//
////////////////////////////////////////////////////////////////////////////////////////////////////

function xlSheetCellType(handle: SheetHandle; row, col: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetCellTypeW';

function xlSheetIsFormula(handle: SheetHandle; row, col: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetIsFormulaW';

function xlSheetCellFormat(handle: SheetHandle; row, col: Integer): FormatHandle; cdecl;
external 'libxl' name 'xlSheetCellFormatW';

procedure xlSheetSetCellFormat(handle: SheetHandle; row, col: Integer; format: FormatHandle); cdecl;
external 'libxl' name 'xlSheetSetCellFormatW';

function xlSheetReadStr(handle: SheetHandle; row, col: Integer; format: PFormatHandle): PWideChar; cdecl;
external 'libxl' name 'xlSheetReadStrW';

function xlSheetWriteStr(handle: SheetHandle; row, col: Integer; value: PWideChar; format: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlSheetWriteStrW';

function xlSheetWriteStrAsNum(handle: SheetHandle; row, col: Integer; value: PWideChar; format: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlSheetWriteStrAsNumW';

function xlSheetReadRichStr(handle: SheetHandle; row, col: Integer; format: PFormatHandle): RichStringHandle; cdecl;
external 'libxl' name 'xlSheetReadRichStrW';

function xlSheetWriteRichStr(handle: SheetHandle; row, col: Integer; richString: RichStringHandle; format: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlSheetWriteRichStrW';

function xlSheetReadNum(handle: SheetHandle; row, col: Integer; format: PFormatHandle): Double; cdecl;
external 'libxl' name 'xlSheetReadNumW';

function xlSheetWriteNum(handle: SheetHandle; row, col: Integer; value: Double; format: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlSheetWriteNumW';

function xlSheetReadBool(handle: SheetHandle; row, col: Integer; format: PFormatHandle): Integer; cdecl;
external 'libxl' name 'xlSheetReadBoolW';

function xlSheetWriteBool(handle: SheetHandle; row, col: Integer; value: Integer; format: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlSheetWriteBoolW';

function xlSheetReadBlank(handle: SheetHandle; row, col: Integer; format: PFormatHandle): Integer; cdecl;
external 'libxl' name 'xlSheetReadBlankW';

function xlSheetWriteBlank(handle: SheetHandle; row, col: Integer; format: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlSheetWriteBlankW';

function xlSheetReadFormula(handle: SheetHandle; row, col: Integer; format: PFormatHandle): PWideChar; cdecl;
external 'libxl' name 'xlSheetReadFormulaW';

function xlSheetWriteFormula(handle: SheetHandle; row, col: Integer; value: PWideChar; format: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlSheetWriteFormulaW';

function xlSheetWriteFormulaNum(handle: SheetHandle; row, col: Integer; expr: PWideChar; value: Double; format: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlSheetWriteFormulaNumW';

function xlSheetWriteFormulaStr(handle: SheetHandle; row, col: Integer; expr, value: PWideChar; format: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlSheetWriteFormulaStrW';

function xlSheetWriteFormulaBool(handle: SheetHandle; row, col: Integer; expr: PWideChar; value: Integer; format: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlSheetWriteFormulaBoolW';

function xlSheetReadComment(handle: SheetHandle; row, col: Integer): PWideChar; cdecl;
external 'libxl' name 'xlSheetReadCommentW';

procedure xlSheetWriteComment(handle: SheetHandle; row, col: Integer; const value, author: PWideChar; width, height: Integer); cdecl;
external 'libxl' name 'xlSheetWriteCommentW';

procedure xlSheetRemoveComment(handle: SheetHandle; row, col: Integer); cdecl;
external 'libxl' name 'xlSheetRemoveCommentW';

function xlSheetIsDate(handle: SheetHandle; row, col: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetIsDateW';

function xlSheetIsRichStr(handle: SheetHandle; row, col: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetIsRichStrW';

function xlSheetReadError(handle: SheetHandle; row, col: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetReadErrorW';

procedure xlSheetWriteError(handle: SheetHandle; row, col, error: Integer; format: FormatHandle); cdecl;
external 'libxl' name 'xlSheetWriteErrorW';

function xlSheetColWidth(handle: SheetHandle; col: Integer): Double; cdecl;
external 'libxl' name 'xlSheetColWidthW';

function xlSheetRowHeight(handle: SheetHandle; row: Integer): Double; cdecl;
external 'libxl' name 'xlSheetRowHeightW';

function xlSheetColWidthPx(handle: SheetHandle; col: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetColWidthPxW';

function xlSheetRowHeightPx(handle: SheetHandle; row: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetRowHeightPxW';

function xlSheetColFormat(handle: SheetHandle; col: Integer): FormatHandle; cdecl;
external 'libxl' name 'xlSheetColFormatW';

function xlSheetRowFormat(handle: SheetHandle; row: Integer): FormatHandle; cdecl;
external 'libxl' name 'xlSheetRowFormatW';

function xlSheetSetCol(handle: SheetHandle; colFirst, colLast: Integer; width: Double; format: FormatHandle; hidden: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetSetColW';

function xlSheetSetColPx(handle: SheetHandle; colFirst, colLast, widthPx: Integer; format: FormatHandle; hidden: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetSetColPxW';

function xlSheetSetRow(handle: SheetHandle; row: Integer; height: Double; format: FormatHandle; hidden: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetSetRowW';

function xlSheetSetRowPx(handle: SheetHandle; row, heightPx: Integer; format: FormatHandle; hidden: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetSetRowPxW';

function xlSheetRowHidden(handle: SheetHandle; row: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetRowHiddenW';

function xlSheetSetRowHidden(handle: SheetHandle; row, hidden: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetSetRowHiddenW';

function xlSheetColHidden(handle: SheetHandle; col: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetColHiddenW';

function xlSheetSetColHidden(handle: SheetHandle; col, hidden: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetSetColHiddenW';

function xlSheetDefaultRowHeight(handle: SheetHandle): Double; cdecl;
external 'libxl' name 'xlSheetDefaultRowHeightW';

procedure xlSheetSetDefaultRowHeight(handle: SheetHandle; height: Double); cdecl;
external 'libxl' name 'xlSheetSetDefaultRowHeightW';

function xlSheetGetMerge(handle: SheetHandle; row, col: Integer; rowFirst, rowLast, colFirst, colLast: PInteger): Integer; cdecl;
external 'libxl' name 'xlSheetGetMergeW';

function xlSheetSetMerge(handle: SheetHandle; rowFirst, rowLast, colFirst, colLast: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetSetMergeW';

function xlSheetDelMerge(handle: SheetHandle; row, col: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetDelMergeW';

function xlSheetMergeSize(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetMergeSizeW';

function xlSheetMerge(handle: SheetHandle; index: Integer; rowFirst, rowLast, colFirst, colLast: PInteger): Integer; cdecl;
external 'libxl' name 'xlSheetMergeW';

function xlSheetDelMergeByIndex(handle: SheetHandle; index: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetDelMergeByIndexW';

function xlSheetPictureSize(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetPictureSizeW';

function xlSheetGetPicture(handle: SheetHandle; index: Integer; rowTop, colLeft, rowBottom, colRight,
                           width, height, offset_x, offset_y: PInteger): Integer; cdecl;
external 'libxl' name 'xlSheetGetPictureW';

function xlSheetRemovePictureByIndex(handle: SheetHandle; index: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetRemovePictureByIndexW';

procedure xlSheetSetPicture(handle: SheetHandle; row, col, pictureId: Integer; scale: Double; offset_x, offset_y, pos: Integer); cdecl;
external 'libxl' name 'xlSheetSetPictureW';

procedure xlSheetSetPicture2(handle: SheetHandle; row, col, pictureId, width, height, offset_x, offset_y, pos: Integer); cdecl;
external 'libxl' name 'xlSheetSetPicture2W';

function xlSheetRemovePicture(handle: SheetHandle; row, col: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetRemovePictureW';

function xlSheetGetHorPageBreak(handle: SheetHandle; index: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetGetHorPageBreakW';

function xlSheetGetHorPageBreakSize(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetGetHorPageBreakSizeW';

function xlSheetGetVerPageBreak(handle: SheetHandle; index: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetGetVerPageBreakW';

function xlSheetGetVerPageBreakSize(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetGetVerPageBreakSizeW';

function xlSheetSetHorPageBreak(handle: SheetHandle; row, pageBreak: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetSetHorPageBreakW';

function xlSheetSetVerPageBreak(handle: SheetHandle; col, pageBreak: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetSetVerPageBreakW';

procedure xlSheetSplit(handle: SheetHandle; row, col: Integer); cdecl;
external 'libxl' name 'xlSheetSplitW';

function xlSheetSplitInfo(handle: SheetHandle; row, col: PInteger): Integer; cdecl;
external 'libxl' name 'xlSheetSplitInfoW';

function xlSheetGroupRows(handle: SheetHandle; rowFirst, rowLast, collapsed: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetGroupRowsW';

function xlSheetGroupCols(handle: SheetHandle; colFirst, colLast, collapsed: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetGroupColsW';

function xlSheetGroupSummaryBelow(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetGroupSummaryBelowW';

procedure xlSheetSetGroupSummaryBelow(handle: SheetHandle; below: Integer); cdecl;
external 'libxl' name 'xlSheetSetGroupSummaryBelowW';

function xlSheetGroupSummaryRight(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetGroupSummaryRightW';

procedure xlSheetSetGroupSummaryRight(handle: SheetHandle; right: Integer); cdecl;
external 'libxl' name 'xlSheetSetGroupSummaryRightW';

function xlSheetClear(handle: SheetHandle; rowFirst, rowLast, colFirst, colLast: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetClearW';

function xlSheetInsertCol(handle: SheetHandle; colFirst, colLast: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetInsertColW';

function xlSheetInsertRow(handle: SheetHandle; rowFirst, rowLast: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetInsertRowW';

function xlSheetRemoveCol(handle: SheetHandle; colFirst, colLast: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetRemoveColW';

function xlSheetRemoveRow(handle: SheetHandle; rowFirst, rowLast: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetRemoveRowW';

function xlSheetInsertColAndKeepRanges(handle: SheetHandle; colFirst, colLast: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetInsertColAndKeepRangesW';

function xlSheetInsertRowAndKeepRanges(handle: SheetHandle; rowFirst, rowLast: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetInsertRowAndKeepRangesW';

function xlSheetRemoveColAndKeepRanges(handle: SheetHandle; colFirst, colLast: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetRemoveColAndKeepRangesW';

function xlSheetRemoveRowAndKeepRanges(handle: SheetHandle; rowFirst, rowLast: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetRemoveRowAndKeepRangesW';

function xlSheetCopyCell(handle: SheetHandle; rowSrc, colSrc, rowDst, colDst: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetCopyCellW';

function xlSheetFirstRow(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetFirstRowW';

function xlSheetLastRow(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetLastRowW';

function xlSheetFirstCol(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetFirstColW';

function xlSheetLastCol(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetLastColW';

function xlSheetFirstFilledRow(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetFirstFilledRowW';

function xlSheetLastFilledRow(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetLastFilledRowW';

function xlSheetFirstFilledCol(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetFirstFilledColW';

function xlSheetLastFilledCol(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetLastFilledColW';

function xlSheetDisplayGridlines(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetDisplayGridlinesW';

procedure xlSheetSetDisplayGridlines(handle: SheetHandle; show: Integer); cdecl;
external 'libxl' name 'xlSheetSetDisplayGridlinesW';

function xlSheetPrintGridlines(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetPrintGridlinesW';

procedure xlSheetSetPrintGridlines(handle: SheetHandle; print: Integer); cdecl;
external 'libxl' name 'xlSheetSetPrintGridlinesW';

function xlSheetZoom(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetZoomW';

procedure xlSheetSetZoom(handle: SheetHandle; zoom: Integer); cdecl;
external 'libxl' name 'xlSheetSetZoomW';

function xlSheetPrintZoom(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetPrintZoomW';

procedure xlSheetSetPrintZoom(handle: SheetHandle; zoom: Integer); cdecl;
external 'libxl' name 'xlSheetSetPrintZoomW';

function xlSheetGetPrintFit(handle: SheetHandle; wPages, hPages: PInteger): Integer; cdecl;
external 'libxl' name 'xlSheetGetPrintFitW';

procedure xlSheetSetPrintFit(handle: SheetHandle; wPages, hPages: Integer); cdecl;
external 'libxl' name 'xlSheetSetPrintFitW';

function xlSheetLandscape(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetLandscapeW';

procedure xlSheetSetLandscape(handle: SheetHandle; landscape: Integer); cdecl;
external 'libxl' name 'xlSheetSetLandscapeW';

function xlSheetPaper(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetPaperW';

procedure xlSheetSetPaper(handle: SheetHandle; paper: Integer); cdecl;
external 'libxl' name 'xlSheetSetPaperW';

function xlSheetHeader(handle: SheetHandle): PWideChar; cdecl;
external 'libxl' name 'xlSheetHeaderW';

function xlSheetSetHeader(handle: SheetHandle; const header: PWideChar; margin: Double): Integer; cdecl;
external 'libxl' name 'xlSheetSetHeaderW';

function xlSheetHeaderMargin(handle: SheetHandle): Double; cdecl;
external 'libxl' name 'xlSheetHeaderMarginW';

function xlSheetFooter(handle: SheetHandle): PWideChar; cdecl;
external 'libxl' name 'xlSheetFooterW';

function xlSheetSetFooter(handle: SheetHandle; const footer: PWideChar; margin: Double): Integer; cdecl;
external 'libxl' name 'xlSheetSetFooterW';

function xlSheetFooterMargin(handle: SheetHandle): Double; cdecl;
external 'libxl' name 'xlSheetFooterMarginW';

function xlSheetHCenter(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetHCenterW';

procedure xlSheetSetHCenter(handle: SheetHandle; hCenter: Integer); cdecl;
external 'libxl' name 'xlSheetSetHCenterW';

function xlSheetVCenter(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetVCenterW';

procedure xlSheetSetVCenter(handle: SheetHandle; vCenter: Integer); cdecl;
external 'libxl' name 'xlSheetSetVCenterW';

function xlSheetMarginLeft(handle: SheetHandle): Double; cdecl;
external 'libxl' name 'xlSheetMarginLeftW';

procedure xlSheetSetMarginLeft(handle: SheetHandle; margin: Double); cdecl;
external 'libxl' name 'xlSheetSetMarginLeftW';

function xlSheetMarginRight(handle: SheetHandle): Double; cdecl;
external 'libxl' name 'xlSheetMarginRightW';

procedure xlSheetSetMarginRight(handle: SheetHandle; margin: Double); cdecl;
external 'libxl' name 'xlSheetSetMarginRightW';

function xlSheetMarginTop(handle: SheetHandle): Double; cdecl;
external 'libxl' name 'xlSheetMarginTopW';

procedure xlSheetSetMarginTop(handle: SheetHandle; margin: Double); cdecl;
external 'libxl' name 'xlSheetSetMarginTopW';

function xlSheetMarginBottom(handle: SheetHandle): Double; cdecl;
external 'libxl' name 'xlSheetMarginBottomW';

procedure xlSheetSetMarginBottom(handle: SheetHandle; margin: Double); cdecl;
external 'libxl' name 'xlSheetSetMarginBottomW';

function xlSheetPrintRowCol(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetPrintRowColW';

procedure xlSheetSetPrintRowCol(handle: SheetHandle; print: Integer); cdecl;
external 'libxl' name 'xlSheetSetPrintRowColW';

function xlSheetPrintRepeatRows(handle: SheetHandle; rowFirst, rowLast: PInteger): Integer; cdecl;
external 'libxl' name 'xlSheetPrintRepeatRowsW';

procedure xlSheetSetPrintRepeatRows(handle: SheetHandle; rowFirst, rowLast: Integer); cdecl;
external 'libxl' name 'xlSheetSetPrintRepeatRowsW';

function xlSheetPrintRepeatCols(handle: SheetHandle; colFirst, colLast: PInteger): Integer; cdecl;
external 'libxl' name 'xlSheetPrintRepeatColsW';

procedure xlSheetSetPrintRepeatCols(handle: SheetHandle; colFirst, colLast: Integer); cdecl;
external 'libxl' name 'xlSheetSetPrintRepeatColsW';

function xlSheetPrintArea(handle: SheetHandle; rowFirst, rowLast, colFirst, colLast: PInteger): Integer; cdecl;
external 'libxl' name 'xlSheetPrintAreaW';

procedure xlSheetSetPrintArea(handle: SheetHandle; rowFirst, rowLast, colFirst, colLast: Integer); cdecl;
external 'libxl' name 'xlSheetSetPrintAreaW';

procedure xlSheetClearPrintRepeats(handle: SheetHandle); cdecl;
external 'libxl' name 'xlSheetClearPrintRepeatsW';

procedure xlSheetClearPrintArea(handle: SheetHandle); cdecl;
external 'libxl' name 'xlSheetClearPrintAreaW';

function xlSheetGetNamedRange(handle: SheetHandle; const name: PWideChar; rowFirst, rowLast, colFirst, colLast: PInteger; scopeId: Integer; hidden: PInteger): Integer; cdecl;
external 'libxl' name 'xlSheetGetNamedRangeW';

function xlSheetSetNamedRange(handle: SheetHandle; const name: PWideChar; rowFirst, rowLast, colFirst, colLast, scopeId: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetSetNamedRangeW';

function xlSheetDelNamedRange(handle: SheetHandle; const name: PWideChar; scopeId: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetDelNamedRangeW';

function xlSheetNamedRangeSize(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetNamedRangeSizeW';

function xlSheetNamedRange(handle: SheetHandle; index: Integer; rowFirst, rowLast, colFirst, colLast, scopeId, hidden: PInteger): PWideChar; cdecl;
external 'libxl' name 'xlSheetNamedRangeW';

function xlSheetGetTable(handle: SheetHandle; name: PWideChar; rowFirst, rowLast, colFirst, colLast, headerRowCount, totalsRowCount: PInteger): Integer; cdecl;
external 'libxl' name 'xlSheetGetTableW';

function xlSheetTableSize(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetTableSizeW';

function xlSheetTable(handle: SheetHandle; index: Integer; rowFirst, rowLast, colFirst, colLast, headerRowCount, totalsRowCount: PInteger): PWideChar; cdecl;
external 'libxl' name 'xlSheetTableW';

function xlSheetAddTable(handle: SheetHandle; const name: PWideChar; rowFirst, rowLast, colFirst, colLast, hasHeaders, tableStyle: Integer): TableHandle; cdecl;
external 'libxl' name 'xlSheetAddTableW';

function xlSheetGetTableByName(handle: SheetHandle; const name: PWideChar): TableHandle; cdecl;
external 'libxl' name 'xlSheetGetTableByNameW';

function xlSheetGetTableByIndex(handle: SheetHandle; index: Integer): TableHandle; cdecl;
external 'libxl' name 'xlSheetGetTableByIndexW';

function xlSheetHyperlinkSize(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetHyperlinkSizeW';

function xlSheetHyperlink(handle: SheetHandle; index: Integer; rowFirst, rowLast, colFirst, colLast: PInteger): PWideChar; cdecl;
external 'libxl' name 'xlSheetHyperlinkW';

function xlSheetDelHyperlink(handle: SheetHandle; index: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetDelHyperlinkW';

procedure xlSheetAddHyperlink(handle: SheetHandle; const hyperlink: PWideChar; rowFirst, rowLast, colFirst, colLast: Integer); cdecl;
external 'libxl' name 'xlSheetAddHyperlinkW';

function xlSheetHyperlinkIndex(handle: SheetHandle; row, col: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetHyperlinkIndexW';

function xlSheetIsAutoFilter(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetIsAutoFilterW';

function xlSheetAutoFilter(handle: SheetHandle): AutoFilterHandle; cdecl;
external 'libxl' name 'xlSheetAutoFilterW';

procedure xlSheetApplyFilter(handle: SheetHandle); cdecl;
external 'libxl' name 'xlSheetApplyFilterW';

procedure xlSheetApplyFilter2(handle: SheetHandle; autoFilter: AutoFilterHandle); cdecl;
external 'libxl' name 'xlSheetApplyFilter2W';

procedure xlSheetRemoveFilter(handle: SheetHandle); cdecl;
external 'libxl' name 'xlSheetRemoveFilterW';

function xlSheetName(handle: SheetHandle): PWideChar; cdecl;
external 'libxl' name 'xlSheetNameW';

procedure xlSheetSetName(handle: SheetHandle; const name: PWideChar); cdecl;
external 'libxl' name 'xlSheetSetNameW';

function xlSheetProtect(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetProtectW';

procedure xlSheetSetProtect(handle: SheetHandle; protect: Integer); cdecl;
external 'libxl' name 'xlSheetSetProtectW';

procedure xlSheetSetProtectEx(handle: SheetHandle; protect: Integer; const password: PWideChar; enhancedProtection: Integer); cdecl;
external 'libxl' name 'xlSheetSetProtectExW';

function xlSheetHidden(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetHiddenW';

function xlSheetSetHidden(handle: SheetHandle; hidden: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetSetHiddenW';

procedure xlSheetGetTopLeftView(handle: SheetHandle; row, col: PInteger); cdecl;
external 'libxl' name 'xlSheetGetTopLeftViewW';

procedure xlSheetSetTopLeftView(handle: SheetHandle; row, col: Integer); cdecl;
external 'libxl' name 'xlSheetSetTopLeftViewW';

function xlSheetRightToLeft(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetRightToLeftW';

procedure xlSheetSetRightToLeft(handle: SheetHandle; rightToLeft: Integer); cdecl;
external 'libxl' name 'xlSheetSetRightToLeftW';

procedure xlSheetSetAutoFitArea(handle: SheetHandle; rowFirst, colFirst, rowLast, colLast: Integer); cdecl;
external 'libxl' name 'xlSheetSetAutoFitAreaW';

procedure xlSheetAddrToRowCol(handle: SheetHandle; const addr: PWideChar; row, col, rowRelative, colRelative: PInteger); cdecl;
external 'libxl' name 'xlSheetAddrToRowColW';

function xlSheetRowColToAddr(handle: SheetHandle; row, col, rowRelative, colRelative: Integer): PWideChar; cdecl;
external 'libxl' name 'xlSheetRowColToAddrW';

function xlSheetTabColor(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetTabColorW';

procedure xlSheetSetTabColor(handle: SheetHandle; color: Integer); cdecl;
external 'libxl' name 'xlSheetSetTabColorW';

function xlSheetGetTabRgbColor(handle: SheetHandle; red, green, blue: PInteger): Integer; cdecl;
external 'libxl' name 'xlSheetGetTabRgbColorW';

procedure xlSheetSetTabRgbColor(handle: SheetHandle; red, green, blue: Integer); cdecl;
external 'libxl' name 'xlSheetSetTabRgbColorW';

function xlSheetSetBorder(handle: SheetHandle; rowFirst, rowLast, colFirst, colLast, borderStyle, borderColor: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetSetBorderW';

function xlSheetAddIgnoredError(handle: SheetHandle; rowFirst, colFirst, rowLast, colLast, iError: Integer): Integer; cdecl;
external 'libxl' name 'xlSheetAddIgnoredErrorW';

procedure xlSheetAddDataValidation(handle: SheetHandle; vtype, op, rowFirst, rowLast, colFirst, colLast: Integer; value1, value2: PWideChar); cdecl;
external 'libxl' name 'xlSheetAddDataValidationW';

procedure xlSheetAddDataValidationEx(handle: SheetHandle; vtype, op, rowFirst, rowLast, colFirst, colLast: Integer; value1, value2: PWideChar;
                                     allowBlank, hideDropDown, showInputMessage, showErrorMessage: Integer; promptTitle, prompt,
                                     errorTitle, error: PWideChar; errorStyle: Integer); cdecl;
external 'libxl' name 'xlSheetAddDataValidationExW';

procedure xlSheetAddDataValidationDouble(handle: SheetHandle; vtype, op, rowFirst, rowLast, colFirst, colLast: Integer; value1, value2: Double); cdecl;
external 'libxl' name 'xlSheetAddDataValidationDoubleW';

procedure xlSheetAddDataValidationDoubleEx(handle: SheetHandle; vtype, op, rowFirst, rowLast, colFirst, colLast: Integer; value1, value2: Double;
                                           allowBlank, hideDropDown, showInputMessage, showErrorMessage: Integer; promptTitle, prompt,
                                           errorTitle, error: PWideChar; errorStyle: Integer); cdecl;
external 'libxl' name 'xlSheetAddDataValidationDoubleExW';

procedure xlSheetRemoveDataValidations(handle: SheetHandle); cdecl;
external 'libxl' name 'xlSheetRemoveDataValidationsW';

function xlSheetFormControlSize(handle: SheetHandle): Integer; cdecl;
external 'libxl' name 'xlSheetFormControlSizeW';

function xlSheetFormControl(handle: SheetHandle; index: Integer): FormControlHandle; cdecl;
external 'libxl' name 'xlSheetFormControlW';

function xlSheetAddConditionalFormatting(handle: SheetHandle): ConditionalFormattingHandle; cdecl;
external 'libxl' name 'xlSheetAddConditionalFormattingW';

function xlSheetGetActiveCell(handle: SheetHandle; row, col: PInteger): Integer; cdecl;
external 'libxl' name 'xlSheetGetActiveCellW';

procedure xlSheetSetActiveCell(handle: SheetHandle; row, col: Integer); cdecl;
external 'libxl' name 'xlSheetSetActiveCellW';

function xlSheetSelectionRange(handle: SheetHandle): PWideChar; cdecl;
external 'libxl' name 'xlSheetSelectionRangeW';

procedure xlSheetAddSelectionRange(handle: SheetHandle; sqref: PWideChar); cdecl;
external 'libxl' name 'xlSheetAddSelectionRangeW';

procedure xlSheetRemoveSelection(handle: SheetHandle); cdecl;
external 'libxl' name 'xlSheetRemoveSelectionW';

////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                              Format
//
////////////////////////////////////////////////////////////////////////////////////////////////////

function xlFormatFont(handle: FormatHandle): FontHandle; cdecl;
external 'libxl' name 'xlFormatFontW';

function xlFormatSetFont(handle: FormatHandle; fontHandle: FontHandle): Integer; cdecl;
external 'libxl' name 'xlFormatSetFontW';

function xlFormatNumFormat(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatNumFormatW';

procedure xlFormatSetNumFormat(handle: FormatHandle; numFormat: Integer); cdecl;
external 'libxl' name 'xlFormatSetNumFormatW';

function xlFormatAlignH(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatAlignHW';

procedure xlFormatSetAlignH(handle: FormatHandle; align: Integer); cdecl;
external 'libxl' name 'xlFormatSetAlignHW';

function xlFormatAlignV(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatAlignVW';

procedure xlFormatSetAlignV(handle: FormatHandle; align: Integer); cdecl;
external 'libxl' name 'xlFormatSetAlignVW';

function xlFormatWrap(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatWrapW';

procedure xlFormatSetWrap(handle: FormatHandle; wrap: Integer); cdecl;
external 'libxl' name 'xlFormatSetWrapW';

function xlFormatRotation(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatRotationW';

function xlFormatSetRotation(handle: FormatHandle; rotation: Integer): Integer; cdecl;
external 'libxl' name 'xlFormatSetRotationW';

function xlFormatIndent(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatIndentW';

procedure xlFormatSetIndent(handle: FormatHandle; indent: Integer); cdecl;
external 'libxl' name 'xlFormatSetIndentW';

function xlFormatShrinkToFit(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatShrinkToFitW';

procedure xlFormatSetShrinkToFit(handle: FormatHandle; shrinkToFit: Integer); cdecl;
external 'libxl' name 'xlFormatSetShrinkToFitW';

procedure xlFormatSetBorder(handle: FormatHandle; style: Integer); cdecl;
external 'libxl' name 'xlFormatSetBorderW';

procedure xlFormatSetBorderColor(handle: FormatHandle; color: Integer); cdecl;
external 'libxl' name 'xlFormatSetBorderColorW';

function xlFormatBorderLeft(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatBorderLeftW';

procedure xlFormatSetBorderLeft(handle: FormatHandle; style: Integer); cdecl;
external 'libxl' name 'xlFormatSetBorderLeftW';

function xlFormatBorderRight(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatBorderRightW';

procedure xlFormatSetBorderRight(handle: FormatHandle; style: Integer); cdecl;
external 'libxl' name 'xlFormatSetBorderRightW';

function xlFormatBorderTop(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatBorderTopW';

procedure xlFormatSetBorderTop(handle: FormatHandle; style: Integer); cdecl;
external 'libxl' name 'xlFormatSetBorderTopW';

function xlFormatBorderBottom(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatBorderBottomW';

procedure xlFormatSetBorderBottom(handle: FormatHandle; style: Integer); cdecl;
external 'libxl' name 'xlFormatSetBorderBottomW';

function xlFormatBorderLeftColor(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatBorderLeftColorW';

procedure xlFormatSetBorderLeftColor(handle: FormatHandle; color: Integer); cdecl;
external 'libxl' name 'xlFormatSetBorderLeftColorW';

function xlFormatBorderRightColor(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatBorderRightColorW';

procedure xlFormatSetBorderRightColor(handle: FormatHandle; color: Integer); cdecl;
external 'libxl' name 'xlFormatSetBorderRightColorW';

function xlFormatBorderTopColor(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatBorderTopColorW';

procedure xlFormatSetBorderTopColor(handle: FormatHandle; color: Integer); cdecl;
external 'libxl' name 'xlFormatSetBorderTopColorW';

function xlFormatBorderBottomColor(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatBorderBottomColorW';

procedure xlFormatSetBorderBottomColor(handle: FormatHandle; color: Integer); cdecl;
external 'libxl' name 'xlFormatSetBorderBottomColorW';

function xlFormatBorderDiagonal(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatBorderDiagonalW';

procedure xlFormatSetBorderDiagonal(handle: FormatHandle; border: Integer); cdecl;
external 'libxl' name 'xlFormatSetBorderDiagonalW';

function xlFormatBorderDiagonalStyle(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatBorderDiagonalStyleW';

procedure xlFormatSetBorderDiagonalStyle(handle: FormatHandle; style: Integer); cdecl;
external 'libxl' name 'xlFormatSetBorderDiagonalStyleW';

function xlFormatBorderDiagonalColor(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatBorderDiagonalColorW';

procedure xlFormatSetBorderDiagonalColor(handle: FormatHandle; color: Integer); cdecl;
external 'libxl' name 'xlFormatSetBorderDiagonalColorW';

function xlFormatFillPattern(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatFillPatternW';

procedure xlFormatSetFillPattern(handle: FormatHandle; pattern: Integer); cdecl;
external 'libxl' name 'xlFormatSetFillPatternW';

function xlFormatPatternForegroundColor(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatPatternForegroundColorW';

procedure xlFormatSetPatternForegroundColor(handle: FormatHandle; color: Integer); cdecl;
external 'libxl' name 'xlFormatSetPatternForegroundColorW';

function xlFormatPatternBackgroundColor(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatPatternBackgroundColorW';

procedure xlFormatSetPatternBackgroundColor(handle: FormatHandle; color: Integer); cdecl;
external 'libxl' name 'xlFormatSetPatternBackgroundColorW';

function xlFormatLocked(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatLockedW';

procedure xlFormatSetLocked(handle: FormatHandle; locked: Integer); cdecl;
external 'libxl' name 'xlFormatSetLockedW';

function xlFormatHidden(handle: FormatHandle): Integer; cdecl;
external 'libxl' name 'xlFormatHiddenW';

procedure xlFormatSetHidden(handle: FormatHandle; hidden: Integer); cdecl;
external 'libxl' name 'xlFormatSetHiddenW';

////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                           Font
//
////////////////////////////////////////////////////////////////////////////////////////////////////

function xlFontSize(handle: FontHandle): Integer; cdecl;
external 'libxl' name 'xlFontSizeW';

procedure xlFontSetSize(handle: FontHandle; size: Integer); cdecl;
external 'libxl' name 'xlFontSetSizeW';

function xlFontItalic(handle: FontHandle): Integer; cdecl;
external 'libxl' name 'xlFontItalicW';

procedure xlFontSetItalic(handle: FontHandle; italic: Integer); cdecl;
external 'libxl' name 'xlFontSetItalicW';

function xlFontStrikeOut(handle: FontHandle): Integer; cdecl;
external 'libxl' name 'xlFontStrikeOutW';

procedure xlFontSetStrikeOut(handle: FontHandle; strikeOut: Integer); cdecl;
external 'libxl' name 'xlFontSetStrikeOutW';

function xlFontColor(handle: FontHandle): Integer; cdecl;
external 'libxl' name 'xlFontColorW';

procedure xlFontSetColor(handle: FontHandle; color: Integer); cdecl;
external 'libxl' name 'xlFontSetColorW';

function xlFontBold(handle: FontHandle): Integer; cdecl;
external 'libxl' name 'xlFontBoldW';

procedure xlFontSetBold(handle: FontHandle; bold: Integer); cdecl;
external 'libxl' name 'xlFontSetBoldW';

function xlFontScript(handle: FontHandle): Integer; cdecl;
external 'libxl' name 'xlFontScriptW';

procedure xlFontSetScript(handle: FontHandle; script: Integer); cdecl;
external 'libxl' name 'xlFontSetScriptW';

function xlFontUnderline(handle: FontHandle): Integer; cdecl;
external 'libxl' name 'xlFontUnderlineW';

procedure xlFontSetUnderline(handle: FontHandle; underline: Integer); cdecl;
external 'libxl' name 'xlFontSetUnderlineW';

function xlFontName(handle: FontHandle): PWideChar; cdecl;
external 'libxl' name 'xlFontNameW';

procedure xlFontSetName(handle: FontHandle; const name: PWideChar); cdecl;
external 'libxl' name 'xlFontSetNameW';

////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                                    AutoFilter
//
////////////////////////////////////////////////////////////////////////////////////////////////////

function xlAutoFilterGetRef(handle: AutoFilterHandle; rowFirst, rowLast, colFirst, colLast: PInteger): Integer; cdecl;
external 'libxl' name 'xlAutoFilterGetRefW';

procedure xlAutoFilterSetRef(handle: AutoFilterHandle; rowFirst, rowLast, colFirst, colLast: Integer); cdecl;
external 'libxl' name 'xlAutoFilterSetRefW';

function xlAutoFilterColumn(handle: AutoFilterHandle; colId: Integer): FilterColumnHandle; cdecl;
external 'libxl' name 'xlAutoFilterColumnW';

function xlAutoFilterColumnSize(handle: AutoFilterHandle): Integer; cdecl;
external 'libxl' name 'xlAutoFilterColumnSizeW';

function xlAutoFilterColumnByIndex(handle: AutoFilterHandle; index: Integer): FilterColumnHandle; cdecl;
external 'libxl' name 'xlAutoFilterColumnByIndexW';

function xlAutoFilterGetSortRange(handle: AutoFilterHandle; rowFirst, rowLast, colFirst, colLast: PInteger): Integer; cdecl;
external 'libxl' name 'xlAutoFilterGetSortRangeW';

function xlAutoFilterGetSort(handle: AutoFilterHandle; columnIndex, descending: PInteger): Integer; cdecl;
external 'libxl' name 'xlAutoFilterGetSortW';

function xlAutoFilterSetSort(handle: AutoFilterHandle; columnIndex, descending: Integer): Integer; cdecl;
external 'libxl' name 'xlAutoFilterSetSortW';

function xlAutoFilterAddSort(handle: AutoFilterHandle; columnIndex, descending: Integer): Integer; cdecl;
external 'libxl' name 'xlAutoFilterAddSortW';

////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                               FilterColumn
//
////////////////////////////////////////////////////////////////////////////////////////////////////

function xlFilterColumnIndex(handle: FilterColumnHandle): Integer; cdecl;
external 'libxl' name 'xlFilterColumnIndexW';

function xlFilterColumnFilterType(handle: FilterColumnHandle): Integer; cdecl;
external 'libxl' name 'xlFilterColumnFilterTypeW';

function xlFilterColumnFilterSize(handle: FilterColumnHandle): Integer; cdecl;
external 'libxl' name 'xlFilterColumnFilterSizeW';

function xlFilterColumnFilter(handle: FilterColumnHandle; index: Integer): PWideChar; cdecl;
external 'libxl' name 'xlFilterColumnFilterW';

procedure xlFilterColumnAddFilter(handle: FilterColumnHandle; value: PWideChar); cdecl;
external 'libxl' name 'xlFilterColumnAddFilterW';

function xlFilterColumnGetTop10(handle: FilterColumnHandle; value: PDouble; top, percent: PInteger): Integer; cdecl;
external 'libxl' name 'xlFilterColumnGetTop10W';

procedure xlFilterColumnSetTop10(handle: FilterColumnHandle; value: Double; top, percent: Integer); cdecl;
external 'libxl' name 'xlFilterColumnSetTop10W';

function xlFilterColumnGetCustomFilter(handle: FilterColumnHandle; op1: PInteger; v1: PPWideChar; op2: PInteger; v2: PPWideChar; andOp: PInteger): Integer; cdecl;
external 'libxl' name 'xlFilterColumnGetCustomFilterW';

procedure xlFilterColumnSetCustomFilter(handle: FilterColumnHandle; op: Integer; val: PWideChar); cdecl;
external 'libxl' name 'xlFilterColumnSetCustomFilterW';

procedure xlFilterColumnSetCustomFilterEx(handle: FilterColumnHandle; op1: Integer; v1: PWideChar; op2: Integer; v2: PWideChar; andOp: Integer); cdecl;
external 'libxl' name 'xlFilterColumnSetCustomFilterExW';

procedure xlFilterColumnClear(handle: FilterColumnHandle); cdecl;
external 'libxl' name 'xlFilterColumnClearW';

////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                                   RichString
//
////////////////////////////////////////////////////////////////////////////////////////////////////

function xlRichStringAddFont(handle: RichStringHandle; initFont: FontHandle): FontHandle; cdecl;
external 'libxl' name 'xlRichStringAddFontW';

procedure xlRichStringAddText(handle: RichStringHandle; text: PWideChar; font: FontHandle); cdecl;
external 'libxl' name 'xlRichStringAddTextW';

function xlRichStringGetText(handle: RichStringHandle; index: Integer; font: PFontHandle): PWideChar; cdecl;
external 'libxl' name 'xlRichStringGetTextW';

function xlRichStringTextSize(handle: RichStringHandle): Integer; cdecl;
external 'libxl' name 'xlRichStringTextSizeW';

////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                                 ConditionalFormatting
//
////////////////////////////////////////////////////////////////////////////////////////////////////

procedure xlConditionalFormattingAddRange(handle: ConditionalFormattingHandle; rowFirst, rowLast, colFirst, colLast: Integer); cdecl;
external 'libxl' name 'xlConditionalFormattingAddRangeW';

procedure xlConditionalFormattingAddRule(handle: ConditionalFormattingHandle; cType: Integer; cFormat: ConditionalFormatHandle; value: PWideChar; stopIfTrue: Integer); cdecl;
external 'libxl' name 'xlConditionalFormattingAddRuleW';

procedure xlConditionalFormattingAddTopRule(handle: ConditionalFormattingHandle; cFormat: ConditionalFormatHandle; value, bottom, percent, stopIfTrue: Integer); cdecl;
external 'libxl' name 'xlConditionalFormattingAddTopRuleW';

procedure xlConditionalFormattingAddOpNumRule(handle: ConditionalFormattingHandle; op: Integer; cFormat: ConditionalFormatHandle; value1, value2: Double; stopIfTrue: Integer); cdecl;
external 'libxl' name 'xlConditionalFormattingAddOpNumRuleW';

procedure xlConditionalFormattingAddOpStrRule(handle: ConditionalFormattingHandle; op: Integer; cFormat: ConditionalFormatHandle; value1, value2: PWideChar; stopIfTrue: Integer); cdecl;
external 'libxl' name 'xlConditionalFormattingAddOpStrRuleW';

procedure xlConditionalFormattingAddAboveAverageRule(handle: ConditionalFormattingHandle; cFormat: ConditionalFormatHandle; aboveAverage, equalAverage, stdDev, stopIfTrue: Integer); cdecl;
external 'libxl' name 'xlConditionalFormattingAddAboveAverageRuleW';

procedure xlConditionalFormattingAddTimePeriodRule(handle: ConditionalFormattingHandle; cFormat: ConditionalFormatHandle; timePeriod, stopIfTrue: Integer); cdecl;
external 'libxl' name 'xlConditionalFormattingAddTimePeriodRuleW';

procedure xlConditionalFormattingAdd2ColorScaleRule(handle: ConditionalFormattingHandle; minColor, maxColor, minType: Integer; minValue: Double; maxType: Integer; maxValue: Double; stopIfTrue: Integer); cdecl;
external 'libxl' name 'xlConditionalFormattingAdd2ColorScaleRuleW';

procedure xlConditionalFormattingAdd2ColorScaleFormulaRule(handle: ConditionalFormattingHandle; minColor, maxColor, minType: Integer; minValue: PWideChar; maxType: Integer; maxValue: PWideChar; stopIfTrue: Integer); cdecl;
external 'libxl' name 'xlConditionalFormattingAdd2ColorScaleFormulaRuleW';

procedure xlConditionalFormattingAdd3ColorScaleRule(handle: ConditionalFormattingHandle; minColor, midColor, maxColor, minType: Integer; minValue: Double; midType: Integer; midValue: Double; maxType: Integer; maxValue: Double; stopIfTrue: Integer); cdecl;
external 'libxl' name 'xlConditionalFormattingAdd3ColorScaleRuleW';

procedure xlConditionalFormattingAdd3ColorScaleFormulaRule(handle: ConditionalFormattingHandle; minColor, midColor, maxColor, minType: Integer; minValue: PWideChar; midType: Integer; midValue: PWideChar; maxType: Integer; maxValue: PWideChar; stopIfTrue: Integer); cdecl;
external 'libxl' name 'xlConditionalFormattingAdd3ColorScaleFormulaRuleW';

////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                                 ConditionalFormat
//
////////////////////////////////////////////////////////////////////////////////////////////////////

function xlConditionalFormatFont(handle: ConditionalFormatHandle): FontHandle; cdecl;
external 'libxl' name 'xlConditionalFormatFontW';

function xlConditionalFormatNumFormat(handle: ConditionalFormatHandle): Integer; cdecl;
external 'libxl' name 'xlConditionalFormatNumFormatW';

procedure xlConditionalFormatSetNumFormat(handle: ConditionalFormatHandle; numFormat: Integer); cdecl;
external 'libxl' name 'xlConditionalFormatSetNumFormatW';

function xlConditionalFormatCustomNumFormat(handle: ConditionalFormatHandle): PWideChar; cdecl;
external 'libxl' name 'xlConditionalFormatCustomNumFormatW';

procedure xlConditionalFormatSetCustomNumFormat(handle: ConditionalFormatHandle; customNumFormat: PWideChar); cdecl;
external 'libxl' name 'xlConditionalFormatSetCustomNumFormatW';

procedure xlConditionalFormatSetBorder(handle: ConditionalFormatHandle; style: Integer); cdecl;
external 'libxl' name 'xlConditionalFormatSetBorderW';

procedure xlConditionalFormatSetBorderColor(handle: ConditionalFormatHandle; color: Integer); cdecl;
external 'libxl' name 'xlConditionalFormatSetBorderColorW';

function xlConditionalFormatBorderLeft(handle: ConditionalFormatHandle): Integer; cdecl;
external 'libxl' name 'xlConditionalFormatBorderLeftW';

procedure xlConditionalFormatSetBorderLeft(handle: ConditionalFormatHandle; style: Integer); cdecl;
external 'libxl' name 'xlConditionalFormatSetBorderLeftW';

function xlConditionalFormatBorderRight(handle: ConditionalFormatHandle): Integer; cdecl;
external 'libxl' name 'xlConditionalFormatBorderRightW';

procedure xlConditionalFormatSetBorderRight(handle: ConditionalFormatHandle; style: Integer); cdecl;
external 'libxl' name 'xlConditionalFormatSetBorderRightW';

function xlConditionalFormatBorderTop(handle: ConditionalFormatHandle): Integer; cdecl;
external 'libxl' name 'xlConditionalFormatBorderTopW';

procedure xlConditionalFormatSetBorderTop(handle: ConditionalFormatHandle; style: Integer); cdecl;
external 'libxl' name 'xlConditionalFormatSetBorderTopW';

function xlConditionalFormatBorderBottom(handle: ConditionalFormatHandle): Integer; cdecl;
external 'libxl' name 'xlConditionalFormatBorderBottomW';

procedure xlConditionalFormatSetBorderBottom(handle: ConditionalFormatHandle; style: Integer); cdecl;
external 'libxl' name 'xlConditionalFormatSetBorderBottomW';

function xlConditionalFormatBorderLeftColor(handle: ConditionalFormatHandle): Integer; cdecl;
external 'libxl' name 'xlConditionalFormatBorderLeftColorW';

procedure xlConditionalFormatSetBorderLeftColor(handle: ConditionalFormatHandle; color: Integer); cdecl;
external 'libxl' name 'xlConditionalFormatSetBorderLeftColorW';

function xlConditionalFormatBorderRightColor(handle: ConditionalFormatHandle): Integer; cdecl;
external 'libxl' name 'xlConditionalFormatBorderRightColorW';

procedure xlConditionalFormatSetBorderRightColor(handle: ConditionalFormatHandle; color: Integer); cdecl;
external 'libxl' name 'xlConditionalFormatSetBorderRightColorW';

function xlConditionalFormatBorderTopColor(handle: ConditionalFormatHandle): Integer; cdecl;
external 'libxl' name 'xlConditionalFormatBorderTopColorW';

procedure xlConditionalFormatSetBorderTopColor(handle: ConditionalFormatHandle; color: Integer); cdecl;
external 'libxl' name 'xlConditionalFormatSetBorderTopColorW';

function xlConditionalFormatBorderBottomColor(handle: ConditionalFormatHandle): Integer; cdecl;
external 'libxl' name 'xlConditionalFormatBorderBottomColorW';

procedure xlConditionalFormatSetBorderBottomColor(handle: ConditionalFormatHandle; color: Integer); cdecl;
external 'libxl' name 'xlConditionalFormatSetBorderBottomColorW';

function xlConditionalFormatFillPattern(handle: ConditionalFormatHandle): Integer; cdecl;
external 'libxl' name 'xlConditionalFormatFillPatternW';

procedure xlConditionalFormatSetFillPattern(handle: ConditionalFormatHandle; pattern: Integer); cdecl;
external 'libxl' name 'xlConditionalFormatSetFillPatternW';

function xlConditionalFormatPatternForegroundColor(handle: ConditionalFormatHandle): Integer; cdecl;
external 'libxl' name 'xlConditionalFormatPatternForegroundColorW';

procedure xlConditionalFormatSetPatternForegroundColor(handle: ConditionalFormatHandle; color: Integer); cdecl;
external 'libxl' name 'xlConditionalFormatSetPatternForegroundColorW';

function xlConditionalFormatPatternBackgroundColor(handle: ConditionalFormatHandle): Integer; cdecl;
external 'libxl' name 'xlConditionalFormatPatternBackgroundColorW';

procedure xlConditionalFormatSetPatternBackgroundColor(handle: ConditionalFormatHandle; color: Integer); cdecl;
external 'libxl' name 'xlConditionalFormatSetPatternBackgroundColorW';

////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                                 FormControl
//
////////////////////////////////////////////////////////////////////////////////////////////////////

function xlFormControlObjectType(handle: FormControlHandle): Integer; cdecl;
external 'libxl' name 'xlFormControlObjectTypeW';

function xlFormControlChecked(handle: FormControlHandle): Integer; cdecl;
external 'libxl' name 'xlFormControlCheckedW';

procedure xlFormControlSetChecked(handle: FormControlHandle; checked: Integer); cdecl;
external 'libxl' name 'xlFormControlSetCheckedW';

function xlFormControlFmlaGroup(handle: FormControlHandle): PWideChar; cdecl;
external 'libxl' name 'xlFormControlFmlaGroupW';

procedure xlFormControlSetFmlaGroup(handle: FormControlHandle; group: PWideChar); cdecl;
external 'libxl' name 'xlFormControlSetFmlaGroupW';

function xlFormControlFmlaLink(handle: FormControlHandle): PWideChar; cdecl;
external 'libxl' name 'xlFormControlFmlaLinkW';

procedure xlFormControlSetFmlaLink(handle: FormControlHandle; link: PWideChar); cdecl;
external 'libxl' name 'xlFormControlSetFmlaLinkW';

function xlFormControlFmlaRange(handle: FormControlHandle): PWideChar; cdecl;
external 'libxl' name 'xlFormControlFmlaRangeW';

procedure xlFormControlSetFmlaRange(handle: FormControlHandle; range: PWideChar); cdecl;
external 'libxl' name 'xlFormControlSetFmlaRangeW';

function xlFormControlFmlaTxbx(handle: FormControlHandle): PWideChar; cdecl;
external 'libxl' name 'xlFormControlFmlaTxbxW';

procedure xlFormControlSetFmlaTxbx(handle: FormControlHandle; txbx: PWideChar); cdecl;
external 'libxl' name 'xlFormControlSetFmlaTxbxW';

function xlFormControlName(handle: FormControlHandle): PWideChar; cdecl;
external 'libxl' name 'xlFormControlNameW';

function xlFormControlLinkedCell(handle: FormControlHandle): PWideChar; cdecl;
external 'libxl' name 'xlFormControlLinkedCellW';

function xlFormControlListFillRange(handle: FormControlHandle): PWideChar; cdecl;
external 'libxl' name 'xlFormControlListFillRangeW';

function xlFormControlMacro(handle: FormControlHandle): PWideChar; cdecl;
external 'libxl' name 'xlFormControlMacroW';

function xlFormControlAltText(handle: FormControlHandle): PWideChar; cdecl;
external 'libxl' name 'xlFormControlAltTextW';

function xlFormControlLocked(handle: FormControlHandle): Integer; cdecl;
external 'libxl' name 'xlFormControlLockedW';

function xlFormControlDefaultSize(handle: FormControlHandle): Integer; cdecl;
external 'libxl' name 'xlFormControlDefaultSizeW';

function xlFormControlPrint(handle: FormControlHandle): Integer; cdecl;
external 'libxl' name 'xlFormControlPrintW';

function xlFormControlDisabled(handle: FormControlHandle): Integer; cdecl;
external 'libxl' name 'xlFormControlDisabledW';

function xlFormControlItem(handle: FormControlHandle; index: Integer): PWideChar; cdecl;
external 'libxl' name 'xlFormControlItemW';

function xlFormControlItemSize(handle: FormControlHandle): Integer; cdecl;
external 'libxl' name 'xlFormControlItemSizeW';

procedure xlFormControlAddItem(handle: FormControlHandle; value: PWideChar); cdecl;
external 'libxl' name 'xlFormControlAddItemW';

procedure xlFormControlInsertItem(handle: FormControlHandle; index: Integer; value: PWideChar); cdecl;
external 'libxl' name 'xlFormControlInsertItemW';

procedure xlFormControlClearItems(handle: FormControlHandle); cdecl;
external 'libxl' name 'xlFormControlClearItemsW';

function xlFormControlDropLines(handle: FormControlHandle): Integer; cdecl;
external 'libxl' name 'xlFormControlDropLinesW';

procedure xlFormControlSetDropLines(handle: FormControlHandle; lines: Integer); cdecl;
external 'libxl' name 'xlFormControlSetDropLinesW';

function xlFormControlDx(handle: FormControlHandle): Integer; cdecl;
external 'libxl' name 'xlFormControlDxW';

procedure xlFormControlSetDx(handle: FormControlHandle; dx: Integer); cdecl;
external 'libxl' name 'xlFormControlSetDxW';

function xlFormControlFirstButton(handle: FormControlHandle): Integer; cdecl;
external 'libxl' name 'xlFormControlFirstButtonW';

procedure xlFormControlSetFirstButton(handle: FormControlHandle; firstButton: Integer); cdecl;
external 'libxl' name 'xlFormControlSetFirstButtonW';

function xlFormControlHoriz(handle: FormControlHandle): Integer; cdecl;
external 'libxl' name 'xlFormControlHorizW';

procedure xlFormControlSetHoriz(handle: FormControlHandle; horiz: Integer); cdecl;
external 'libxl' name 'xlFormControlSetHorizW';

function xlFormControlInc(handle: FormControlHandle): Integer; cdecl;
external 'libxl' name 'xlFormControlIncW';

procedure xlFormControlSetInc(handle: FormControlHandle; inc: Integer); cdecl;
external 'libxl' name 'xlFormControlSetIncW';

function xlFormControlGetMax(handle: FormControlHandle): Integer; cdecl;
external 'libxl' name 'xlFormControlGetMaxW';

procedure xlFormControlSetMax(handle: FormControlHandle; max: Integer); cdecl;
external 'libxl' name 'xlFormControlSetMaxW';

function xlFormControlGetMin(handle: FormControlHandle): Integer; cdecl;
external 'libxl' name 'xlFormControlGetMinW';

procedure xlFormControlSetMin(handle: FormControlHandle; min: Integer); cdecl;
external 'libxl' name 'xlFormControlSetMinW';

function xlFormControlMultiSel(handle: FormControlHandle): PWideChar; cdecl;
external 'libxl' name 'xlFormControlMultiSelW';

procedure xlFormControlSetMultiSel(handle: FormControlHandle; value: PWideChar); cdecl;
external 'libxl' name 'xlFormControlSetMultiSelW';

function xlFormControlSel(handle: FormControlHandle): Integer; cdecl;
external 'libxl' name 'xlFormControlSelW';

procedure xlFormControlSetSel(handle: FormControlHandle; sel: Integer); cdecl;
external 'libxl' name 'xlFormControlSetSelW';

function xlFormControlFromAnchor(handle: FormControlHandle; col, colOff, row, rowOff: PInteger): Integer; cdecl;
external 'libxl' name 'xlFormControlFromAnchorW';

function xlFormControlToAnchor(handle: FormControlHandle; col, colOff, row, rowOff: PInteger): Integer; cdecl;
external 'libxl' name 'xlFormControlToAnchorW';

////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                                 CoreProperties
//
////////////////////////////////////////////////////////////////////////////////////////////////////

function xlCorePropertiesTitle(handle: CorePropertiesHandle): PWideChar; cdecl;
external 'libxl' name 'xlCorePropertiesTitleW';

procedure xlCorePropertiesSetTitle(handle: CorePropertiesHandle; title: PWideChar); cdecl;
external 'libxl' name 'xlCorePropertiesSetTitleW';

function xlCorePropertiesSubject(handle: CorePropertiesHandle): PWideChar; cdecl;
external 'libxl' name 'xlCorePropertiesSubjectW';

procedure xlCorePropertiesSetSubject(handle: CorePropertiesHandle; subject: PWideChar); cdecl;
external 'libxl' name 'xlCorePropertiesSetSubjectW';

function xlCorePropertiesCreator(handle: CorePropertiesHandle): PWideChar; cdecl;
external 'libxl' name 'xlCorePropertiesCreatorW';

procedure xlCorePropertiesSetCreator(handle: CorePropertiesHandle; creator: PWideChar); cdecl;
external 'libxl' name 'xlCorePropertiesSetCreatorW';

function xlCorePropertiesLastModifiedBy(handle: CorePropertiesHandle): PWideChar; cdecl;
external 'libxl' name 'xlCorePropertiesLastModifiedByW';

procedure xlCorePropertiesSetLastModifiedBy(handle: CorePropertiesHandle; lastModifiedBy: PWideChar); cdecl;
external 'libxl' name 'xlCorePropertiesSetLastModifiedByW';

function xlCorePropertiesCreated(handle: CorePropertiesHandle): PWideChar; cdecl;
external 'libxl' name 'xlCorePropertiesCreatedW';

procedure xlCorePropertiesSetCreated(handle: CorePropertiesHandle; created: PWideChar); cdecl;
external 'libxl' name 'xlCorePropertiesSetCreatedW';

function xlCorePropertiesCreatedAsDouble(handle: CorePropertiesHandle): Double; cdecl;
external 'libxl' name 'xlCorePropertiesCreatedAsDoubleW';

procedure xlCorePropertiesSetCreatedAsDouble(handle: CorePropertiesHandle; created: Double); cdecl;
external 'libxl' name 'xlCorePropertiesSetCreatedAsDoubleW';

function xlCorePropertiesModified(handle: CorePropertiesHandle): PWideChar; cdecl;
external 'libxl' name 'xlCorePropertiesModifiedW';

procedure xlCorePropertiesSetModified(handle: CorePropertiesHandle; modified: PWideChar); cdecl;
external 'libxl' name 'xlCorePropertiesSetModifiedW';

function xlCorePropertiesModifiedAsDouble(handle: CorePropertiesHandle): Double; cdecl;
external 'libxl' name 'xlCorePropertiesModifiedAsDoubleW';

procedure xlCorePropertiesSetModifiedAsDouble(handle: CorePropertiesHandle; modified: Double); cdecl;
external 'libxl' name 'xlCorePropertiesSetModifiedAsDoubleW';

function xlCorePropertiesTags(handle: CorePropertiesHandle): PWideChar; cdecl;
external 'libxl' name 'xlCorePropertiesTagsW';

procedure xlCorePropertiesSetTags(handle: CorePropertiesHandle; tags: PWideChar); cdecl;
external 'libxl' name 'xlCorePropertiesSetTagsW';

function xlCorePropertiesCategories(handle: CorePropertiesHandle): PWideChar; cdecl;
external 'libxl' name 'xlCorePropertiesCategoriesW';

procedure xlCorePropertiesSetCategories(handle: CorePropertiesHandle; categories: PWideChar); cdecl;
external 'libxl' name 'xlCorePropertiesSetCategoriesW';

function xlCorePropertiesComments(handle: CorePropertiesHandle): PWideChar; cdecl;
external 'libxl' name 'xlCorePropertiesCommentsW';

procedure xlCorePropertiesSetComments(handle: CorePropertiesHandle; comments: PWideChar); cdecl;
external 'libxl' name 'xlCorePropertiesSetCommentsW';

procedure xlCorePropertiesRemoveAll(handle: CorePropertiesHandle); cdecl;
external 'libxl' name 'xlCorePropertiesRemoveAllW';

////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                                 Table
//
////////////////////////////////////////////////////////////////////////////////////////////////////

function xlTableName(handle: TableHandle): PWideChar; cdecl;
external 'libxl' name 'xlTableNameW';

procedure xlTableSetName(handle: TableHandle; name: PWideChar); cdecl;
external 'libxl' name 'xlTableSetNameW';

function xlTableRef(handle: TableHandle): PWideChar; cdecl;
external 'libxl' name 'xlTableRefW';

procedure xlTableSetRef(handle: TableHandle; ref: PWideChar); cdecl;
external 'libxl' name 'xlTableSetRefW';

function xlTableAutoFilter(handle: TableHandle): AutoFilterHandle; cdecl;
external 'libxl' name 'xlTableAutoFilterW';

function xlTableStyle(handle: TableHandle): Integer; cdecl;
external 'libxl' name 'xlTableStyleW';

procedure xlTableSetStyle(handle: TableHandle; tableStyle: Integer); cdecl;
external 'libxl' name 'xlTableSetStyleW';

function xlTableShowRowStripes(handle: TableHandle): Integer; cdecl;
external 'libxl' name 'xlTableShowRowStripesW';

procedure xlTableSetShowRowStripes(handle: TableHandle; showRowStripes: Integer); cdecl;
external 'libxl' name 'xlTableSetShowRowStripesW';

function xlTableShowColumnStripes(handle: TableHandle): Integer; cdecl;
external 'libxl' name 'xlTableShowColumnStripesW';

procedure xlTableSetShowColumnStripes(handle: TableHandle; showColumnStripes: Integer); cdecl;
external 'libxl' name 'xlTableSetShowColumnStripesW';

function xlTableShowFirstColumn(handle: TableHandle): Integer; cdecl;
external 'libxl' name 'xlTableShowFirstColumnW';

procedure xlTableSetShowFirstColumn(handle: TableHandle; showFirstColumn: Integer); cdecl;
external 'libxl' name 'xlTableSetShowFirstColumnW';

function xlTableShowLastColumn(handle: TableHandle): Integer; cdecl;
external 'libxl' name 'xlTableShowLastColumnW';

procedure xlTableSetShowLastColumn(handle: TableHandle; showLastColumn: Integer); cdecl;
external 'libxl' name 'xlTableSetShowLastColumnW';

function xlTableColumnSize(handle: TableHandle): Integer; cdecl;
external 'libxl' name 'xlTableColumnSizeW';

function xlTableColumnName(handle: TableHandle; columnIndex: Integer): PWideChar; cdecl;
external 'libxl' name 'xlTableColumnNameW';

function xlTableSetColumnName(handle: TableHandle; columnIndex: Integer; name: PWideChar): Integer; cdecl;
external 'libxl' name 'xlTableSetColumnNameW';

////////////////////////////////////////////////////////////////////////////////////////////////////

type
  TXLFormControl = class(TObject)
  private
    handle: FormControlHandle;

    function GetObjectType: ObjectType;

    function GetChecked: CheckedType;
    procedure SetChecked(checked: CheckedType);

    function GetFmlaGroup: WideString;
    procedure SetFmlaGroup(const fmlaGroup: WideString);

    function GetFmlaLink: WideString;
    procedure SetFmlaLink(const fmlaLink: WideString);

    function GetFmlaRange: WideString;
    procedure SetFmlaRange(const fmlaRange: WideString);

    function GetFmlaTxbx: WideString;
    procedure SetFmlaTxbx(const fmlaTxbx: WideString);

    function GetName: WideString;
    function GetLinkedCell: WideString;
    function GetListFillRange: WideString;
    function GetMacro: WideString;
    function GetAltText: WideString;

    function GetLocked: Boolean;
    function GetDefaultSize: Boolean;
    function GetPrint: Boolean;
    function GetDisabled: Boolean;

    function GetDropLines: Integer;
    procedure SetDropLines(dropLines: Integer);

    function GetDx: Integer;
    procedure SetDx(dx: Integer);

    function GetFirstButton: Boolean;
    procedure SetFirstButton(firstButton: Boolean);

    function GetHoriz: Boolean;
    procedure SetHoriz(horiz: Boolean);

    function GetInc: Integer;
    procedure SetInc(inc: Integer);

    function GetMax: Integer;
    procedure SetMax(max: Integer);

    function GetMin: Integer;
    procedure SetMin(min: Integer);

    function GetMultiSel: WideString;
    procedure SetMultiSel(const multiSel: WideString);

    function GetSel: Integer;
    procedure SetSel(sel: Integer);
  public
    property objectType: ObjectType read GetObjectType;
    property checked: CheckedType read GetChecked write SetChecked;
    property fmlaGroup: WideString read GetFmlaGroup write SetFmlaGroup;
    property fmlaLink: WideString read GetFmlaLink write SetFmlaLink;
    property fmlaRange: WideString read GetFmlaRange write SetFmlaRange;
    property fmlaTxbx: WideString read GetFmlaTxbx write SetFmlaTxbx;
    property name: WideString read GetName;
    property linkedCell: WideString read GetLinkedCell;
    property listFillRange: WideString read GetListFillRange;
    property macro: WideString read GetMacro;
    property altText: WideString read GetAltText;
    property locked: Boolean read GetLocked;
    property defaultSize: Boolean read GetDefaultSize;
    property print: Boolean read GetPrint;
    property disabled: Boolean read GetDisabled;

    function item(index: Integer): WideString;
    function itemSize: Integer;
    procedure addItem(value: PWideChar);
    procedure insertItem(index: Integer; value: PWideChar);
    procedure clearItems;

    property dropLines: Integer read GetDropLines write SetDropLines;
    property dx: Integer read GetDx write SetDx;
    property firstButton: Boolean read GetFirstButton write SetFirstButton;
    property horiz: Boolean read GetHoriz write SetHoriz;
    property inc: Integer read GetInc write SetInc;
    property max: Integer read GetMax write SetMax;
    property min: Integer read GetMin write SetMin;
    property multiSel: WideString read GetMultiSel write SetMultiSel;
    property sel: Integer read GetSel write SetSel;

    function fromAnchor(var col, colOff, row, rowOff: Integer): Boolean;
    function toAnchor(var col, colOff, row, rowOff: Integer): Boolean;

    constructor Create(handle: FormControlHandle);
  end;

  TArrayFormControls = array of TXLFormControl;

  TXLFilterColumn = class(TObject)
  private
    book: BookHandle;
    handle: FilterColumnHandle;
  public
    function index: Integer;

    function filterType: Filter;

    function filterSize: Integer;
    function filter(idx: Integer): PWideChar;
    procedure addFilter(const value: PWideChar);

    function getTop10(var value: Double; var top, percent: Boolean): Boolean;
    procedure setTop10(value: Double); overload;
    procedure setTop10(value: Double; top: Boolean); overload;
    procedure setTop10(value: Double; top, percent: Boolean); overload;

    function getCustomFilter(var op1: Op; var v1: PWideChar; var op2: Op; var v2: PWideChar; var andOp: Boolean): Boolean;
    procedure setCustomFilter(op: Op; const v: PWideChar); overload;
    procedure setCustomFilter(op1: Op; const v1: PWideChar; op2: Op; const v2: PWideChar; andOp: Boolean); overload;

    procedure clear;

    constructor Create(handle: FilterColumnHandle; book: BookHandle);
    destructor Destroy; override;
  end;

  TArrayFilterColumns = array of TXLFilterColumn;

  TXLAutoFilter = class(TObject)
  private
    handle: AutoFilterHandle;
    book: BookHandle;
    filterColumns: TArrayFilterColumns;
  public
    function getRef(var rowFirst, rowLast, colFirst, colLast: Integer): Boolean;
    procedure setRef(rowFirst, rowLast, colFirst, colLast: Integer);

    function column(colId: Integer): TXLFilterColumn;

    function columnSize: Integer;
    function columnByIndex(index: Integer): TXLFilterColumn;

    function getSortRange(var rowFirst, rowLast, colFirst, colLast: Integer): Boolean;

    function getSort(var columnIndex: Integer; var descending: Boolean): Boolean;
    function setSort(columnIndex: Integer; descending: Boolean): Boolean;
    function addSort(columnIndex: Integer; descending: Boolean): Boolean;

    constructor Create(handle: AutoFilterHandle; book: BookHandle);
    destructor Destroy; override;
  end;

  TXLFont = class(TObject)
  private
    handle: FontHandle;
    book: BookHandle;

    procedure SetSize(const value: Integer);
    function GetSize: Integer;

    procedure SetBold(const value: Boolean);
    function GetBold: Boolean;

    procedure SetItalic(const value: Boolean);
    function GetItalic: Boolean;

    procedure SetUnderline(const value: Underline);
    function GetUnderline: Underline;

    procedure SetStrikeOut(const value: Boolean);
    function GetStrikeOut: Boolean;

    procedure SetScript(const value: Script);
    function GetScript: Script;

    procedure SetColor(const value: Color);
    function GetColor: Color;

    procedure SetName(const value: WideString);
    function GetName: WideString;
  public
    property size: Integer read GetSize write SetSize;
    property bold: Boolean read GetBold write SetBold;
    property italic: Boolean read GetItalic write SetItalic;
    property underline: Underline read GetUnderline write SetUnderline;
    property strikeOut: Boolean read GetStrikeOut write SetStrikeOut;
    property script: Script read GetScript write SetScript;
    property color: Color read GetColor write SetColor;
    property name: WideString read GetName write SetName;

    constructor Create(handle: FontHandle; book: BookHandle);
    destructor Destroy; override;
  end;

  TArrayFonts = array of TXLFont;

  TXLRichString = class(TObject)
  private
    handle: RichStringHandle;
    book: BookHandle;
    fonts: TArrayFonts;
  public
    function addFont: TXLFont; overload;
    function addFont(initFont: TXLFont): TXLFont; overload;
    procedure addText(const text: PWideChar); overload;
    procedure addText(const text: PWideChar; font: TXLFont); overload;
    function getText(index: Integer): WideString; overload;
    function getText(index: Integer; var font: TXLFont): WideString; overload;
    function textSize: Integer;

    constructor Create(handle: RichStringHandle; book: BookHandle);
    destructor Destroy; override;
  end;

  TArrayRichStrings = array of TXLRichString;

  TXLFormat = class(TObject)
  private
    handle: FormatHandle;
    book: BookHandle;
    ffont: TXLFont;

    procedure SetFont(const value: TXLFont);
    function GetFont: TXLFont;

    procedure SetAlignH(const value: AlignH);
    function GetAlignH: AlignH;

    procedure SetAlignV(const value: AlignV);
    function GetAlignV: AlignV;
    procedure SetWrap(const value: Boolean);
    function GetWrap: Boolean;
    procedure SetRotation(const value: Integer);
    function GetRotation: Integer;
    procedure SetIndent(const value: Integer);
    function GetIndent: Integer;
    procedure SetShrinkToFit(const value: Boolean);
    function GetShrinkToFit: Boolean;

    procedure SetBorderLeft(const value: BorderStyle);
    function GetBorderLeft: BorderStyle;
    procedure SetBorderRight(const value: BorderStyle);
    function GetBorderRight: BorderStyle;
    procedure SetBorderTop(const value: BorderStyle);
    function GetBorderTop: BorderStyle;
    procedure SetBorderBottom(const value: BorderStyle);
    function GetBorderBottom: BorderStyle;

    procedure SetBorderLeftColor(const value: Color);
    function GetBorderLeftColor: Color;
    procedure SetBorderRightColor(const value: Color);
    function GetBorderRightColor: Color;
    procedure SetBorderTopColor(const value: Color);
    function GetBorderTopColor: Color;
    procedure SetBorderBottomColor(const value: Color);
    function GetBorderBottomColor: Color;

    procedure SetBorderDiagonal(const value: BorderDiagonal);
    function GetBorderDiagonal: BorderDiagonal;
    procedure SetBorderDiagonalStyle(const value: BorderStyle);
    function GetBorderDiagonalStyle: BorderStyle;
    procedure SetBorderDiagonalColor(const value: Color);
    function GetBorderDiagonalColor: Color;

    procedure SetFillPattern(const value: FillPattern);
    function GetFillPattern: FillPattern;

    procedure SetPatternForegroundColor(const value: Color);
    function GetPatternForegroundColor: Color;
    procedure SetPatternBackgroundColor(const value: Color);
    function GetPatternBackgroundColor: Color;

    procedure SetLocked(const value: Boolean);
    function GetLocked: Boolean;

    procedure SetHidden(const value: Boolean);
    function GetHidden: Boolean;
  public
    function numFormat: Integer;
    procedure setNumFormat(nFormat: Integer); overload;
    procedure setNumFormat(value: NumFormat); overload;
    procedure setBorder(style: BorderStyle);
    procedure setBorderColor(value: Color);

    property hidden: Boolean read GetHidden write SetHidden;
    property locked: Boolean read GetLocked write SetLocked;
    property fillPattern: FillPattern read GetFillPattern write SetFillPattern;
    property patternForegroundColor: Color read GetPatternForegroundColor write SetPatternForegroundColor;
    property patternBackgroundColor: Color read GetPatternBackgroundColor write SetPatternBackgroundColor;
    property borderDiagonal: BorderDiagonal read GetBorderDiagonal write SetBorderDiagonal;
    property borderDiagonalStyle: BorderStyle read GetBorderDiagonalStyle write SetBorderDiagonalStyle;
    property borderDiagonalColor: Color read GetBorderDiagonalColor write SetBorderDiagonalColor;

    property font: TXLFont read GetFont write SetFont;
    property alignH: AlignH read GetAlignH write SetAlignH;
    property alignV: AlignV read GetAlignV write SetAlignV;
    property wrap: Boolean read GetWrap write SetWrap;
    property rotation: Integer read GetRotation write SetRotation;
    property indent: Integer read GetIndent write SetIndent;
    property shrinkToFit: Boolean read GetShrinkToFit write SetShrinkToFit;

    property borderLeft: BorderStyle read GetBorderLeft write SetBorderLeft;
    property borderRight: BorderStyle read GetBorderRight write SetBorderRight;
    property borderTop: BorderStyle read GetBorderTop write SetBorderTop;
    property borderBottom: BorderStyle read GetBorderBottom write SetBorderBottom;

    property borderLeftColor: Color read GetBorderLeftColor write SetBorderLeftColor;
    property borderRightColor: Color read GetBorderRightColor write SetBorderRightColor;
    property borderTopColor: Color read GetBorderTopColor write SetBorderTopColor;
    property borderBottomColor: Color read GetBorderBottomColor write SetBorderBottomColor;

    constructor Create(handle: FormatHandle; book: BookHandle);
    destructor Destroy; override;
  end;

  TArrayFormats = array of TXLFormat;

  TXLConditionalFormat = class(TObject)
  private
    handle: ConditionalFormatHandle;
    book: BookHandle;
    ffont: TXLFont;

    function GetFont: TXLFont;

    procedure SetBorderLeft(const value: BorderStyle);
    function GetBorderLeft: BorderStyle;
    procedure SetBorderRight(const value: BorderStyle);
    function GetBorderRight: BorderStyle;
    procedure SetBorderTop(const value: BorderStyle);
    function GetBorderTop: BorderStyle;
    procedure SetBorderBottom(const value: BorderStyle);
    function GetBorderBottom: BorderStyle;

    procedure SetBorderLeftColor(const value: Color);
    function GetBorderLeftColor: Color;
    procedure SetBorderRightColor(const value: Color);
    function GetBorderRightColor: Color;
    procedure SetBorderTopColor(const value: Color);
    function GetBorderTopColor: Color;
    procedure SetBorderBottomColor(const value: Color);
    function GetBorderBottomColor: Color;

    procedure SetFillPattern(const value: FillPattern);
    function GetFillPattern: FillPattern;

    procedure SetPatternForegroundColor(const value: Color);
    function GetPatternForegroundColor: Color;
    procedure SetPatternBackgroundColor(const value: Color);
    function GetPatternBackgroundColor: Color;
  public
    property font: TXLFont read GetFont;

    function numFormat: NumFormat;
    procedure setNumFormat(nFormat: NumFormat);

    function customNumFormat: WideString;
    procedure setCustomNumFormat(customNFormat: PWideChar);

    procedure setBorder(style: BorderStyle);
    procedure setBorderColor(value: Color);

    property borderLeft: BorderStyle read GetBorderLeft write SetBorderLeft;
    property borderRight: BorderStyle read GetBorderRight write SetBorderRight;
    property borderTop: BorderStyle read GetBorderTop write SetBorderTop;
    property borderBottom: BorderStyle read GetBorderBottom write SetBorderBottom;

    property borderLeftColor: Color read GetBorderLeftColor write SetBorderLeftColor;
    property borderRightColor: Color read GetBorderRightColor write SetBorderRightColor;
    property borderTopColor: Color read GetBorderTopColor write SetBorderTopColor;
    property borderBottomColor: Color read GetBorderBottomColor write SetBorderBottomColor;

    property fillPattern: FillPattern read GetFillPattern write SetFillPattern;
    property patternForegroundColor: Color read GetPatternForegroundColor write SetPatternForegroundColor;
    property patternBackgroundColor: Color read GetPatternBackgroundColor write SetPatternBackgroundColor;

    constructor Create(handle: ConditionalFormatHandle; book: BookHandle);
    destructor Destroy; override;
  end;

  TArrayConditionalFormats = array of TXLConditionalFormat;

  TXLConditionalFormatting = class(TObject)
  private
    handle: ConditionalFormattingHandle;
  public
    procedure addRange(rowFirst, rowLast, colFirst, colLast: Integer);

    procedure addRule(cType: CFormatType; cFormat: TXLConditionalFormat); overload;
    procedure addRule(cType: CFormatType; cFormat: TXLConditionalFormat; value: PWideChar); overload;
    procedure addRule(cType: CFormatType; cFormat: TXLConditionalFormat; value: PWideChar; stopIfTrue: Boolean); overload;

    procedure addTopRule(cFormat: TXLConditionalFormat; value: Integer); overload;
    procedure addTopRule(cFormat: TXLConditionalFormat; value: Integer; bottom: Boolean); overload;
    procedure addTopRule(cFormat: TXLConditionalFormat; value: Integer; bottom, percent: Boolean); overload;
    procedure addTopRule(cFormat: TXLConditionalFormat; value: Integer; bottom, percent, stopIfTrue: Boolean); overload;

    procedure addOpNumRule(op: CFormatOperator; cFormat: TXLConditionalFormat; value1: Double); overload;
    procedure addOpNumRule(op: CFormatOperator; cFormat: TXLConditionalFormat; value1, value2: Double); overload;
    procedure addOpNumRule(op: CFormatOperator; cFormat: TXLConditionalFormat; value1, value2: Double; stopIfTrue: Boolean); overload;

    procedure addOpStrRule(op: CFormatOperator; cFormat: TXLConditionalFormat; value1: PWideChar); overload;
    procedure addOpStrRule(op: CFormatOperator; cFormat: TXLConditionalFormat; value1, value2: PWideChar); overload;
    procedure addOpStrRule(op: CFormatOperator; cFormat: TXLConditionalFormat; value1, value2: PWideChar; stopIfTrue: Boolean); overload;

    procedure addAboveAverageRule(cFormat: TXLConditionalFormat); overload;
    procedure addAboveAverageRule(cFormat: TXLConditionalFormat; aboveAverage: Boolean); overload;
    procedure addAboveAverageRule(cFormat: TXLConditionalFormat; aboveAverage, equalAverage: Boolean); overload;
    procedure addAboveAverageRule(cFormat: TXLConditionalFormat; aboveAverage, equalAverage: Boolean; stdDev: Integer); overload;
    procedure addAboveAverageRule(cFormat: TXLConditionalFormat; aboveAverage, equalAverage: Boolean; stdDev: Integer; stopIfTrue: Boolean); overload;

    procedure addTimePeriodRule(cFormat: TXLConditionalFormat; timePeriod: CFormatTimePeriod); overload;
    procedure addTimePeriodRule(cFormat: TXLConditionalFormat; timePeriod: CFormatTimePeriod; stopIfTrue: Boolean); overload;

    procedure add2ColorScaleRule(minColor, maxColor: Color); overload;
    procedure add2ColorScaleRule(minColor, maxColor: Color; minType: CFVOType; minValue: Double; maxType: CFVOType; maxValue: Double); overload;
    procedure add2ColorScaleRule(minColor, maxColor: Color; minType: CFVOType; minValue: Double; maxType: CFVOType; maxValue: Double; stopIfTrue: Boolean); overload;

    procedure add2ColorScaleFormulaRule(minColor, maxColor: Color; minType: CFVOType; minValue: PWideChar; maxType: CFVOType; maxValue: PWideChar); overload;
    procedure add2ColorScaleFormulaRule(minColor, maxColor: Color; minType: CFVOType; minValue: PWideChar; maxType: CFVOType; maxValue: PWideChar; stopIfTrue: Boolean); overload;

    procedure add3ColorScaleRule(minColor, midColor, maxColor: Color); overload;
    procedure add3ColorScaleRule(minColor, midColor, maxColor: Color; minType: CFVOType; minValue: Double; midType: CFVOType; midValue: Double; maxType: CFVOType; maxValue: Double); overload;
    procedure add3ColorScaleRule(minColor, midColor, maxColor: Color; minType: CFVOType; minValue: Double; midType: CFVOType; midValue: Double; maxType: CFVOType; maxValue: Double; stopIfTrue: Boolean); overload;

    procedure add3ColorScaleFormulaRule(minColor, midColor, maxColor: Color; minType: CFVOType; minValue: PWideChar; midType: CFVOType; midValue: PWideChar; maxType: CFVOType; maxValue: PWideChar); overload;
    procedure add3ColorScaleFormulaRule(minColor, midColor, maxColor: Color; minType: CFVOType; minValue: PWideChar; midType: CFVOType; midValue: PWideChar; maxType: CFVOType; maxValue: PWideChar; stopIfTrue: Boolean); overload;

    constructor Create(handle: ConditionalFormattingHandle);
  end;

  TArrayConditionalFormattings = array of TXLConditionalFormatting;

  TXLCoreProperties = class(TObject)
  private
    handle: CorePropertiesHandle;

    function GetTitle: WideString;
    procedure SetTitle(const value: WideString);

    function GetSubject: WideString;
    procedure SetSubject(const value: WideString);

    function GetCreator: WideString;
    procedure SetCreator(const value: WideString);

    function GetLastModifiedBy: WideString;
    procedure SetLastModifiedBy(const value: WideString);

    function GetCreated: WideString;
    procedure SetCreated(const value: WideString);

    function GetCreatedAsDouble: Double;
    procedure SetCreatedAsDouble(value: Double);

    function GetModified: WideString;
    procedure SetModified(const value: WideString);

    function GetModifiedAsDouble: Double;
    procedure SetModifiedAsDouble(value: Double);

    function GetTags: WideString;
    procedure SetTags(const value: WideString);

    function GetCategories: WideString;
    procedure SetCategories(const value: WideString);

    function GetComments: WideString;
    procedure SetComments(const value: WideString);
  public
    property title: WideString read GetTitle write SetTitle;
    property subject: WideString read GetSubject write SetSubject;
    property creator: WideString read GetCreator write SetCreator;
    property lastModifiedBy: WideString read GetLastModifiedBy write SetLastModifiedBy;

    property created: WideString read GetCreated write SetCreated;
    property createdAsDouble: Double read GetCreatedAsDouble write SetCreatedAsDouble;
    property modified: WideString read GetModified write SetModified;
    property modifiedAsDouble: Double read GetModifiedAsDouble write SetModifiedAsDouble;

    property tags: WideString read GetTags write SetTags;
    property categories: WideString read GetCategories write SetCategories;
    property comments: WideString read GetComments write SetComments;

    procedure removeAll;

    constructor Create(handle: CorePropertiesHandle);
  end;

  TXLTable = class(TObject)
  private
    handle: TableHandle;
    book: BookHandle;
    xlAutoFilter: TXLAutoFilter;

    function GetName: WideString;
    procedure SetName(const value: WideString);

    function GetRef: WideString;
    procedure SetRef(const value: WideString);

    function GetTableStyle: TableStyle;
    procedure SetTableStyle(const value: TableStyle);

    function GetShowRowStripes: Boolean;
    procedure SetShowRowStripes(const value: Boolean);

    function GetShowColumnStripes: Boolean;
    procedure SetShowColumnStripes(const value: Boolean);

    function GetShowFirstColumn: Boolean;
    procedure SetShowFirstColumn(const value: Boolean);

    function GetShowLastColumn: Boolean;
    procedure SetShowLastColumn(const value: Boolean);

    function GetColumnSize: Integer;
  public
    property name: WideString read GetName write SetName;
    property ref: WideString read GetRef write SetRef;

    function autoFilter: TXLAutoFilter;

    property tableStyle: TableStyle read GetTableStyle write SetTableStyle;
    property showRowStripes: Boolean read GetShowRowStripes write SetShowRowStripes;
    property showColumnStripes: Boolean read GetShowColumnStripes write SetShowColumnStripes;
    property showFirstColumn: Boolean read GetShowFirstColumn write SetShowFirstColumn;
    property showLastColumn: Boolean read GetShowLastColumn write SetShowLastColumn;
    property columnSize: Integer read GetColumnSize;

    function columnName(columnIndex: Integer): WideString;
    function setColumnName(columnIndex: Integer; const _name: PWideChar): Integer;

    constructor Create(handle: TableHandle; book: BookHandle);
    destructor Destroy; override;
  end;

  TArrayTables = array of TXLTable;

  TXLSheet = class(TObject)
  private
    handle: SheetHandle;
    book: BookHandle;
    richStrings: TArrayRichStrings;
    formats: TArrayFormats;
    formControls: TArrayFormControls;
    cFormattings: TArrayConditionalFormattings;
    xlAutoFilter: TXLAutoFilter;
    tables: TArrayTables;

    procedure SetDisplayGridlines(const value: Boolean);
    function GetDisplayGridlines: Boolean;

    procedure SetPrintGridlines(const value: Boolean);
    function GetPrintGridlines: Boolean;

    procedure SetZoom(const value: Integer);
    function GetZoom: Integer;

    procedure SetPrintZoom(const value: Integer);
    function GetPrintZoom: Integer;

    procedure SetLandscape(const value: Boolean);
    function GetLandscape: Boolean;

    procedure SetPaper(const value: Paper);
    function GetPaper: Paper;

    procedure SetHeader(const value: WideString);
    function GetHeader: WideString;

    procedure SetHeaderMargin(const value: Double);
    function GetHeaderMargin: Double;

    function GetFooter: WideString;
    procedure SetFooter(const value: WideString);
    function GetFooterMargin: Double;
    procedure SetFooterMargin(const value: Double);

    function GetHCenter: Boolean;
    procedure SetHCenter(const value: Boolean);

    function GetVCenter: Boolean;
    procedure SetVCenter(const value: Boolean);

    function GetMarginLeft: Double;
    procedure SetMarginLeft(const value: Double);
    function GetMarginRight: Double;
    procedure SetMarginRight(const value: Double);
    function GetMarginBottom: Double;
    function GetMarginTop: Double;
    procedure SetMarginBottom(const value: Double);
    procedure SetMarginTop(const value: Double);

    function GetPrintRowCol: Boolean;
    procedure SetPrintRowCol(const value: Boolean);

    function GetProtectImpl: Boolean;
    procedure SetProtectImpl(const value: Boolean);

    function GetRightToLeft: Boolean;
    procedure SetRightToLeft(const value: Boolean);

    function GetHidden: SheetState;
    procedure SetHidden(const value: SheetState);

    function GetName: WideString;
    procedure SetName(const value: WideString);

    function GetGroupSummaryBelow: Boolean;
    procedure SetGroupSummaryBelow(const value: Boolean);

    function GetGroupSummaryRight: Boolean;
    procedure SetGroupSummaryRight(const value: Boolean);
  public
    property displayGridlines: Boolean read GetDisplayGridlines write SetDisplayGridlines;
    property printGridlines: Boolean read GetPrintGridlines write SetPrintGridlines;
    property zoom: Integer read GetZoom write SetZoom;
    property printZoom: Integer read GetPrintZoom write SetPrintZoom;
    property landscape: Boolean read GetLandscape write SetLandscape;
    property paper: Paper read GetPaper write SetPaper;
    property header: WideString read GetHeader write SetHeader;
    property headerMargin: Double read GetHeaderMargin write SetHeaderMargin;
    property footer: WideString read GetFooter write SetFooter;
    property footerMargin: Double read GetFooterMargin write SetFooterMargin;
    property hCenter: Boolean read GetHCenter write SetHCenter;
    property vCenter: Boolean read GetVCenter write SetVCenter;

    property marginLeft: Double read GetMarginLeft write SetMarginLeft;
    property marginRight: Double read GetMarginRight write SetMarginRight;
    property marginTop: Double read GetMarginTop write SetMarginTop;
    property marginBottom: Double read GetMarginBottom write SetMarginBottom;

    property printRowCol: Boolean read GetPrintRowCol write SetPrintRowCol;
    property name: WideString read GetName write SetName;
    property groupSummaryBelow: Boolean read GetGroupSummaryBelow write SetGroupSummaryBelow;
    property groupSummaryRight: Boolean read GetGroupSummaryRight write SetGroupSummaryRight;

    property protect: Boolean read GetProtectImpl write SetProtectImpl;
    property hidden: SheetState read GetHidden write SetHidden;
    property rightToLeft: Boolean read GetRightToLeft write SetRightToLeft;

    function errorMessage: WideString;

    function getCellType(row, col: Integer): CellType;
    function isFormula(row, col: Integer): Boolean;

    function cellFormat(row, col: Integer): TXLFormat;
    procedure setCellFormat(row, col: Integer; format: TXLFormat);

    function readStr(row, col: Integer): WideString; overload;
    function readStr(row, col: Integer; var format: TXLFormat): WideString; overload;
    function writeStr(row, col: Integer; value: PWideChar): Boolean; overload;
    function writeStr(row, col: Integer; value: PWideChar; format: TXLFormat): Boolean; overload;

    function readRichStr(row, col: Integer): TXLRichString; overload;
    function readRichStr(row, col: Integer; var format: TXLFormat): TXLRichString; overload;
    function writeRichStr(row, col: Integer; value: TXLRichString): Boolean; overload;
    function writeRichStr(row, col: Integer; value: TXLRichString; format: TXLFormat): Boolean; overload;

    function readNum(row, col: Integer): Double; overload;
    function readNum(row, col: Integer; var format: TXLFormat): Double; overload;
    function writeNum(row, col: Integer; value: Double): Boolean; overload;
    function writeNum(row, col: Integer; value: Double; format: TXLFormat): Boolean; overload;

    function readBool(row, col: Integer): Boolean; overload;
    function readBool(row, col: Integer; var format: TXLFormat): Boolean; overload;
    function writeBool(row, col: Integer; value: Boolean): Boolean; overload;
    function writeBool(row, col: Integer; value: Boolean; format: TXLFormat): Boolean; overload;

    function readBlank(row, col: Integer; var format: TXLFormat): Boolean;
    function writeBlank(row, col: Integer; format: TXLFormat): Boolean;

    function readFormula(row, col: Integer): WideString; overload;
    function readFormula(row, col: Integer; var format: TXLFormat): WideString; overload;
    function writeFormula(row, col: Integer; value: PWideChar): Boolean; overload;
    function writeFormula(row, col: Integer; value: PWideChar; format: TXLFormat): Boolean; overload;

    function writeFormulaNum(row, col: Integer; expr: PWideChar; value: Double): Boolean; overload;
    function writeFormulaNum(row, col: Integer; expr: PWideChar; value: Double; format: TXLFormat): Boolean; overload;

    function writeFormulaStr(row, col: Integer; expr, value: PWideChar): Boolean; overload;
    function writeFormulaStr(row, col: Integer; expr, value: PWideChar; format: TXLFormat): Boolean; overload;

    function writeFormulaBool(row, col: Integer; expr: PWideChar; value: Boolean): Boolean; overload;
    function writeFormulaBool(row, col: Integer; expr: PWideChar; value: Boolean; format: TXLFormat): Boolean; overload;

    function readComment(row, col: Integer): WideString;
    procedure writeComment(row, col: Integer; value, author: PWideChar; width, height: Integer);
    procedure removeComment(row, col: Integer);

    function isDate(row, col: Integer): Boolean;
    function isRichStr(row, col: Integer): Boolean;

    function readError(row, col: Integer): ErrorType;
    procedure writeError(row, col: Integer; error: ErrorType); overload;
    procedure writeError(row, col: Integer; error: ErrorType; format: TXLFormat); overload;

    function colWidth(col: Integer): Double;
    function rowHeight(row: Integer): Double;

    function colWidthPx(col: Integer): Integer;
    function rowHeightPx(row: Integer): Integer;

    function colFormat(col: Integer): TXLFormat;
    function rowFormat(row: Integer): TXLFormat;

    function setCol(col: Integer; width: Double): Boolean; overload;
    function setCol(colFirst, colLast: Integer; width: Double): Boolean; overload;
    function setCol(col: Integer; width: Double; format: TXLFormat): Boolean; overload;
    function setCol(colFirst, colLast: Integer; width: Double; format: TXLFormat): Boolean; overload;
    function setCol(col: Integer; width: Double; format: TXLFormat; hid: Boolean): Boolean; overload;
    function setCol(colFirst, colLast: Integer; width: Double; format: TXLFormat; hid: Boolean): Boolean; overload;

    function setColPx(col, widthPx: Integer): Boolean; overload;
    function setColPx(colFirst, colLast, widthPx: Integer): Boolean; overload;
    function setColPx(col, widthPx: Integer; format: TXLFormat): Boolean; overload;
    function setColPx(colFirst, colLast, widthPx: Integer; format: TXLFormat): Boolean; overload;
    function setColPx(col, widthPx: Integer; format: TXLFormat; hid: Boolean): Boolean; overload;
    function setColPx(colFirst, colLast, widthPx: Integer; format: TXLFormat; hid: Boolean): Boolean; overload;

    function setRow(row: Integer; height: Double): Boolean; overload;
    function setRow(row: Integer; height: Double; format: TXLFormat): Boolean; overload;
    function setRow(row: Integer; height: Double; format: TXLFormat; hid: Boolean): Boolean; overload;

    function setRowPx(row, heightPx: Integer): Boolean; overload;
    function setRowPx(row, heightPx: Integer; format: TXLFormat): Boolean; overload;
    function setRowPx(row, heightPx: Integer; format: TXLFormat; hid: Boolean): Boolean; overload;

    function rowHidden(row: Integer): Boolean;
    function setRowHidden(row: Integer; hid: Boolean): Boolean;

    function colHidden(col: Integer): Boolean;
    function setColHidden(col: Integer; hid: Boolean): Boolean;

    function defaultRowHeight: Double;
    procedure setDefaultRowHeight(height: Double);

    function getMerge(row, col: Integer; var rowFirst, rowLast, colFirst, colLast: Integer): Boolean;
    function setMerge(rowFirst, rowLast, colFirst, colLast: Integer): Boolean;
    function delMerge(row, col: Integer): Boolean;

    function mergeSize: Integer;
    function merge(index: Integer; var rowFirst, rowLast, colFirst, colLast: Integer): Boolean;
    function delMergeByIndex(index: Integer): Boolean;

    function pictureSize: Integer;
    function getPicture(index: Integer): Integer; overload;
    function getPicture(index: Integer; var rowTop, colLeft, rowBottom, colRight: Integer): Integer; overload;
    function getPicture(index: Integer; var rowTop, colLeft, rowBottom, colRight, width, height: Integer): Integer; overload;
    function getPicture(index: Integer; var rowTop, colLeft, rowBottom, colRight, width, height, offset_x, offset_y: Integer): Integer; overload;
    function removePictureByIndex(index: Integer): Boolean;

    procedure setPicture(row, col, pictureId: Integer); overload;
    procedure setPicture(row, col, pictureId: Integer; scale: Double); overload;
    procedure setPicture2(row, col, pictureId, width, height: Integer); overload;
    procedure setPicture2(row, col, pictureId, width, height, offset_x, offset_y: Integer; pos: Position); overload;
    function removePicture(row, col: Integer): Boolean;

    function getHorPageBreak(index: Integer): Integer;
    function getHorPageBreakSize: Integer;

    function getVerPageBreak(index: Integer): Integer;
    function getVerPageBreakSize: Integer;

    function setHorPageBreak(row: Integer): Boolean;
    function delHorPageBreak(row: Integer): Boolean;
    function setVerPageBreak(col: Integer): Boolean;
    function delVerPageBreak(col: Integer): Boolean;

    procedure split(row, col: Integer);
    function splitInfo(var row, col: Integer): Boolean;

    function groupRows(rowFirst, rowLast: Integer; collapsed: Boolean): Boolean;
    function groupCols(colFirst, colLast: Integer; collapsed: Boolean): Boolean;

    function clear(rowFirst, rowLast, colFirst, colLast: Integer): Boolean;

    function insertCol(colFirst, colLast: Integer): Boolean;
    function insertRow(rowFirst, rowLast: Integer): Boolean;
    function removeCol(colFirst, colLast: Integer): Boolean;
    function removeRow(rowFirst, rowLast: Integer): Boolean;

    function copyCell(rowSrc, colSrc, rowDst, colDst: Integer): Boolean;

    function firstRow: Integer;
    function lastRow: Integer;
    function firstCol: Integer;
    function lastCol: Integer;

    function firstFilledRow: Integer;
    function lastFilledRow: Integer;
    function firstFilledCol: Integer;
    function lastFilledCol: Integer;

    function getPrintFit(var wPages, hPages: Integer): Boolean;
    procedure setPrintFit(wPages, hPages: Integer);

    function printRepeatRows(var rowFirst, rowLast: Integer): Boolean;
    procedure setPrintRepeatRows(rowFirst, rowLast: Integer);

    function printRepeatCols(var colFirst, colLast: Integer): Boolean;
    procedure setPrintRepeatCols(colFirst, colLast: Integer);

    function printArea(var rowFirst, rowLast, colFirst, colLast: Integer): Boolean;
    procedure setPrintArea(rowFirst, rowLast, colFirst, colLast: Integer);

    procedure clearPrintRepeats;
    procedure clearPrintArea;

    function getNamedRange(const _name: PWideChar; var rowFirst, rowLast, colFirst, colLast: Integer): Boolean; overload;
    function getNamedRange(const _name: PWideChar; var rowFirst, rowLast, colFirst, colLast: Integer; scopeId: Integer): Boolean; overload;
    function getNamedRange(const _name: PWideChar; var rowFirst, rowLast, colFirst, colLast: Integer; scopeId: Integer; var hid: Boolean): Boolean; overload;
    function setNamedRange(const _name: PWideChar; rowFirst, rowLast, colFirst, colLast: Integer): Boolean; overload;
    function setNamedRange(const _name: PWideChar; rowFirst, rowLast, colFirst, colLast, scopeId: Integer): Boolean; overload;
    function delNamedRange(const _name: PWideChar): Boolean; overload;
    function delNamedRange(const _name: PWideChar; scopeId: Integer): Boolean; overload;

    function namedRangeSize: Integer;
    function namedRange(index: Integer; var rowFirst, rowLast, colFirst, colLast: Integer): WideString; overload;
    function namedRange(index: Integer; var rowFirst, rowLast, colFirst, colLast, scopeId: Integer): WideString; overload;
    function namedRange(index: Integer; var rowFirst, rowLast, colFirst, colLast, scopeId: Integer; var hid: Boolean): WideString; overload;

    function getTable(const _name: PWideChar; var rowFirst, rowLast, colFirst, colLast, headerRowCount, totalsRowCount: Integer): Boolean;
    function tableSize: Integer;
    function table(index: Integer; var rowFirst, rowLast, colFirst, colLast, headerRowCount, totalsRowCount: Integer): WideString;

    function addTable(const _name: PWideChar; rowFirst, rowLast, colFirst, colLast: Integer): TXLTable; overload;
    function addTable(const _name: PWideChar; rowFirst, rowLast, colFirst, colLast: Integer; hasHeaders: Boolean): TXLTable; overload;
    function addTable(const _name: PWideChar; rowFirst, rowLast, colFirst, colLast: Integer; hasHeaders: Boolean; tableStyle: TableStyle): TXLTable; overload;
    function getTableByName(const _name: PWideChar): TXLTable;
    function getTableByIndex(index: Integer): TXLTable;

    function hyperlinkSize: Integer;
    function hyperlink(index: Integer; var rowFirst, rowLast, colFirst, colLast: Integer): WideString;
    function delHyperlink(index: Integer): Boolean;
    procedure addHyperlink(const hyperlnk: PWideChar; rowFirst, rowLast, colFirst, colLast: Integer);
    function hyperlinkIndex(row, col: Integer): Integer;

    function isAutoFilter: Boolean;
    function autoFilter: TXLAutoFilter;
    procedure applyFilter;
    procedure applyFilter2(_autoFilter: TXLAutoFilter);
    procedure removeFilter;

    procedure setProtect(_protect: Boolean; const password: PWideChar); overload;
    procedure setProtect(_protect: Boolean; const password: PWideChar; const prot: EnhancedProtection); overload;

    procedure getTopLeftView(var row, col: Integer);
    procedure setTopLeftView(row, col: Integer);
    procedure setAutoFitArea(rowFirst, colFirst, rowLast, colLast: Integer);

    procedure addrToRowCol(const addr: PWideChar; var row, col: Integer); overload;
    procedure addrToRowCol(const addr: PWideChar; var row, col: Integer; var rowRelative, colRelative: Boolean); overload;
    function rowColToAddr(row, col: Integer): WideString; overload;
    function rowColToAddr(row, col: Integer; rowRelative, colRelative: Boolean): WideString; overload;

    function tabColor: Color;
    procedure setTabColor(_color: Color); overload;

    function getTabColor(var red, green, blue: Integer): Boolean;
    procedure setTabColor(red, green, blue: Integer); overload;

    function setBorder(rowFirst, rowLast, colFirst, colLast: Integer; _borderStyle: BorderStyle; borderColor: Color): Boolean;

    function addIgnoredError(rowFirst, colFirst, rowLast, colLast: Integer; iError: IgnoredError): Boolean;

    procedure addDataValidation(vtype: DataValidationType; op: DataValidationOperator; rowFirst, rowLast, colFirst, colLast: Integer; const value: PWideChar); overload;
    procedure addDataValidation(vtype: DataValidationType; op: DataValidationOperator; rowFirst, rowLast, colFirst, colLast: Integer; const value1, value2: PWideChar); overload;
    procedure addDataValidation(vtype: DataValidationType; op: DataValidationOperator; rowFirst, rowLast, colFirst, colLast: Integer; const value1, value2: PWideChar;
                                allowBlank, hideDropDown, showInputMessage, showErrorMessage: Boolean; const promptTitle, prompt,
                                errorTitle, error: PWideChar; errorStyle: DataValidationErrorStyle); overload;

    procedure addDataValidationDouble(vtype: DataValidationType; op: DataValidationOperator; rowFirst, rowLast, colFirst, colLast: Integer; value: Double); overload;
    procedure addDataValidationDouble(vtype: DataValidationType; op: DataValidationOperator; rowFirst, rowLast, colFirst, colLast: Integer; value1, value2: Double); overload;
    procedure addDataValidationDouble(vtype: DataValidationType; op: DataValidationOperator; rowFirst, rowLast, colFirst, colLast: Integer; value1, value2: Double;
                                      allowBlank, hideDropDown, showInputMessage, showErrorMessage: Boolean; const promptTitle, prompt,
                                      errorTitle, error: PWideChar; errorStyle: DataValidationErrorStyle); overload;

    procedure removeDataValidations;

    function formControlSize: Integer;
    function formControl(index: Integer): TXLFormControl;

    function addConditionalFormatting: TXLConditionalFormatting;

    function getActiveCell(var row, col: Integer): Boolean;
    procedure setActiveCell(row, col: Integer);

    function selectionRange: WideString;
    procedure addSelectionRange(sqref: PWideChar);
    procedure removeSelection;

    constructor Create(handle: SheetHandle; book: BookHandle);
    destructor Destroy; override;
  end;

  TArraySheets = array of TXLSheet;

  TXLBook = class(TObject)
  private
    handle: BookHandle;

    fonts: TArrayFonts;
    formats: TArrayFormats;
    richStrings: TArrayRichStrings;
    sheets: TArraySheets;
    conditionalFormats: TArrayConditionalFormats;
    cProperties: TXLCoreProperties;

    procedure Release;

    function GetRefR1C1: Boolean;
    procedure SetRefR1C1(const value: Boolean);

    function GetDate1904: Boolean;
    procedure SetDate1904(const value: Boolean);

    function GetTemplate: Boolean;
    procedure SetTemplate(const value: Boolean);
  public
    function load(filename: PWideChar): Boolean; overload;
    function load(filename, tempFile: PWideChar): Boolean; overload;
    function loadSheet(filename: PWideChar; sheetIndex: Integer): Boolean; overload;
    function loadSheet(filename: PWideChar; sheetIndex: Integer; tempFile: PWideChar): Boolean; overload;
    function loadPartially(filename: PWideChar; sheetIndex, firstRow, lastRow, keepAllSheets: Integer): Boolean; overload;
    function loadPartially(filename: PWideChar; sheetIndex, firstRow, lastRow: Integer; tempFile: PWideChar; keepAllSheets: Integer): Boolean; overload;
    function loadWithoutEmptyCells(filename: PWideChar): Boolean;
    function loadInfo(filename: PWideChar): Boolean;

    function save(filename: PWideChar): Boolean; overload;
    function save(filename: PWideChar; useTempFile: Boolean): Boolean; overload;

    function loadRaw(data: PBytes; size: Cardinal): Boolean; overload;
    function loadRaw(data: PBytes; size: Cardinal; sheetIndex, firstRow, lastRow, keepAllSheets: Integer): Boolean; overload;
    function saveRaw(var Buffer: TBytes; var size: Cardinal): Boolean;

    procedure setPassword(password: PWideChar);

    function addSheet(name: PWideChar): TXLSheet; overload;
    function addSheet(name: PWideChar; initSheet: TXLSheet): TXLSheet; overload;
    function insertSheet(index: Integer; name: PWideChar): TXLSheet; overload;
    function insertSheet(index: Integer; name: PWideChar; initSheet: TXLSheet): TXLSheet; overload;
    function getSheet(index: Integer): TXLSheet;
    function getSheetName(index: Integer): WideString;
    function sheetType(index: Integer): SheetType;
    function moveSheet(srcIndex, dstIndex: Integer): Boolean;
    function delSheet(index: Integer): Boolean;
    function sheetCount: Integer;

    function addFormat: TXLFormat; overload;
    function addFormat(initFormat: TXLFormat): TXLFormat; overload;
    function addFormatFromStyle(style: CellStyle): TXLFormat;
    function addFont: TXLFont; overload;
    function addFont(initFont: TXLFont): TXLFont; overload;
    function addRichString: TXLRichString;
    function addCustomNumFormat(customNumFormat: PWideChar): Integer;
    function customNumFormat(fmt: Integer): WideString;

    function format(index: Integer): TXLFormat;
    function formatSize: Integer;

    function font(index: Integer): TXLFont;
    function fontSize: Integer;

    function addConditionalFormat: TXLConditionalFormat;

    function datePack(year, month, day: Integer): Double; overload;
    function datePack(year, month, day, hour, min, sec: Integer): Double; overload;
    function datePack(year, month, day, hour, min, sec, msec: Integer): Double; overload;

    function dateUnpack(value: Double; var year, month, day: Integer): Boolean; overload;
    function dateUnpack(value: Double; var year, month, day, hour, min, sec: Integer): Boolean; overload;
    function dateUnpack(value: Double; var year, month, day, hour, min, sec, msec: Integer): Boolean; overload;

    function colorPack(red, green, blue: Integer): Color;
    procedure colorUnpack(_color: Color; var red, green, blue: Integer);

    function activeSheet: Integer;
    procedure setActiveSheet(index: Integer);

    function pictureSize: Integer;
    function getPicture(index: Integer; var Buffer: TBytes; var size: Cardinal): PictureType;

    function addPicture(filename: PWideChar): Integer;
    function addPicture2(data: PBytes; size: Cardinal): Integer;
    function addPictureAsLink(filename: PWideChar; insert: Boolean): Integer;

    function defaultFont(var _fontSize: Integer): WideString;
    procedure setDefaultFont(fontName: PWideChar; _fontSize: Integer);

    property refR1C1: Boolean read GetRefR1C1 write SetRefR1C1;

    procedure setKey(name, key: PWideChar);

    function rgbMode: Boolean;
    procedure setRgbMode(_rgbMode: Boolean);

    function calcMode: CalcModeType;
    procedure setCalcMode(_calcMode: CalcModeType);

    function version: Integer;
    function biffVersion: Integer;

    property date1904: Boolean read GetDate1904 write SetDate1904;
    property template: Boolean read GetTemplate write SetTemplate;

    function isWriteProtected: Boolean;

    function coreProperties: TXLCoreProperties;

    function removeVBA: Boolean;
    function removePrinterSettings: Boolean;
    procedure removeAllPhonetics;

    function setLocale(locale: PAnsiChar): Boolean;

    function errorMessage: WideString;

    destructor Destroy; override;
  end;

  TBinBook = class(TXLBook)
  public
    constructor Create;
  end;

  TXmlBook = class(TXLBook)
  public
    constructor Create;
  end;

implementation

procedure xlAddFont(var fonts: TArrayFonts; font: TXLFont);
begin
  SetLength(fonts, Length(fonts) + 1);
  fonts[High(fonts)] := font;
end;

procedure xlAddFilterColumn(var filterColumns: TArrayFilterColumns; filterColumn: TXLFilterColumn);
begin
  SetLength(filterColumns, Length(filterColumns) + 1);
  filterColumns[High(filterColumns)] := filterColumn;
end;

procedure xlAddFormat(var formats: TArrayFormats; format: TXLFormat);
begin
  SetLength(formats, Length(formats) + 1);
  formats[High(formats)] := format;
end;

procedure xlAddRichString(var richStrings: TArrayRichStrings; richString: TXLRichString);
begin
  SetLength(richStrings, Length(richStrings) + 1);
  richStrings[High(richStrings)] := richString;
end;

procedure xlAddFormControl(var formControls: TArrayFormControls; formControl: TXLFormControl);
begin
  SetLength(formControls, Length(formControls) + 1);
  formControls[High(formControls)] := formControl;
end;

procedure xlAddConditionalFormatting(var conditionalFormattings: TArrayConditionalFormattings; conditionalFormatting: TXLConditionalFormatting);
begin
  SetLength(conditionalFormattings, Length(conditionalFormattings) + 1);
  conditionalFormattings[High(conditionalFormattings)] := conditionalFormatting;
end;

procedure xlAddSheet(var sheets: TArraySheets; sheet: TXLSheet);
begin
  SetLength(sheets, Length(sheets) + 1);
  sheets[High(sheets)] := sheet;
end;

procedure xlAddConditionalFormat(var conditionalFormats: TArrayConditionalFormats; conditionalFormat: TXLConditionalFormat);
begin
  SetLength(conditionalFormats, Length(conditionalFormats) + 1);
  conditionalFormats[High(conditionalFormats)] := conditionalFormat;
end;

procedure xlAddTable(var tables: TArrayTables; table: TXLTable);
begin
  SetLength(tables, Length(tables) + 1);
  tables[High(tables)] := table;
end;

////////////////////////////////////////////////////////////////////

procedure TXLConditionalFormatting.addRange(rowFirst, rowLast, colFirst, colLast: Integer);
begin
  xlConditionalFormattingAddRange(handle, rowFirst, rowLast, colFirst, colLast);
end;

procedure TXLConditionalFormatting.addRule(cType: CFormatType; cFormat: TXLConditionalFormat);
begin
  xlConditionalFormattingAddRule(handle, Integer(cType), cFormat.handle, nil, 0);
end;

procedure TXLConditionalFormatting.addRule(cType: CFormatType; cFormat: TXLConditionalFormat; value: PWideChar);
begin
  xlConditionalFormattingAddRule(handle, Integer(cType), cFormat.handle, value, 0);
end;

procedure TXLConditionalFormatting.addRule(cType: CFormatType; cFormat: TXLConditionalFormat; value: PWideChar; stopIfTrue: Boolean);
begin
  xlConditionalFormattingAddRule(handle, Integer(cType), cFormat.handle, value, Integer(stopIfTrue));
end;

procedure TXLConditionalFormatting.addTopRule(cFormat: TXLConditionalFormat; value: Integer);
begin
  xlConditionalFormattingAddTopRule(handle, cFormat.handle, value, 0, 0, 0);
end;

procedure TXLConditionalFormatting.addTopRule(cFormat: TXLConditionalFormat; value: Integer; bottom: Boolean);
begin
  xlConditionalFormattingAddTopRule(handle, cFormat.handle, value, Integer(bottom), 0, 0);
end;

procedure TXLConditionalFormatting.addTopRule(cFormat: TXLConditionalFormat; value: Integer; bottom, percent: Boolean);
begin
  xlConditionalFormattingAddTopRule(handle, cFormat.handle, value, Integer(bottom), Integer(percent), 0);
end;

procedure TXLConditionalFormatting.addTopRule(cFormat: TXLConditionalFormat; value: Integer; bottom, percent, stopIfTrue: Boolean);
begin
  xlConditionalFormattingAddTopRule(handle, cFormat.handle, value, Integer(bottom), Integer(percent), Integer(stopIfTrue));
end;

procedure TXLConditionalFormatting.addOpNumRule(op: CFormatOperator; cFormat: TXLConditionalFormat; value1: Double);
begin
  xlConditionalFormattingAddOpNumRule(handle, Integer(op), cFormat.handle, value1, 0, 0);
end;

procedure TXLConditionalFormatting.addOpNumRule(op: CFormatOperator; cFormat: TXLConditionalFormat; value1, value2: Double);
begin
  xlConditionalFormattingAddOpNumRule(handle, Integer(op), cFormat.handle, value1, value2, 0);
end;

procedure TXLConditionalFormatting.addOpNumRule(op: CFormatOperator; cFormat: TXLConditionalFormat; value1, value2: Double; stopIfTrue: Boolean);
begin
  xlConditionalFormattingAddOpNumRule(handle, Integer(op), cFormat.handle, value1, value2, Integer(stopIfTrue));
end;

procedure TXLConditionalFormatting.addOpStrRule(op: CFormatOperator; cFormat: TXLConditionalFormat; value1: PWideChar);
begin
  xlConditionalFormattingAddOpStrRule(handle, Integer(op), cFormat.handle, value1, nil, 0);
end;

procedure TXLConditionalFormatting.addOpStrRule(op: CFormatOperator; cFormat: TXLConditionalFormat; value1, value2: PWideChar);
begin
  xlConditionalFormattingAddOpStrRule(handle, Integer(op), cFormat.handle, value1, value2, 0);
end;

procedure TXLConditionalFormatting.addOpStrRule(op: CFormatOperator; cFormat: TXLConditionalFormat; value1, value2: PWideChar; stopIfTrue: Boolean);
begin
  xlConditionalFormattingAddOpStrRule(handle, Integer(op), cFormat.handle, value1, value2, Integer(stopIfTrue));
end;

procedure TXLConditionalFormatting.addAboveAverageRule(cFormat: TXLConditionalFormat);
begin
  xlConditionalFormattingAddAboveAverageRule(handle, cFormat.handle, 1, 0, 0, 0);
end;

procedure TXLConditionalFormatting.addAboveAverageRule(cFormat: TXLConditionalFormat; aboveAverage: Boolean);
begin
  xlConditionalFormattingAddAboveAverageRule(handle, cFormat.handle, Integer(aboveAverage), 0, 0, 0);
end;

procedure TXLConditionalFormatting.addAboveAverageRule(cFormat: TXLConditionalFormat; aboveAverage, equalAverage: Boolean);
begin
  xlConditionalFormattingAddAboveAverageRule(handle, cFormat.handle, Integer(aboveAverage), Integer(equalAverage), 0, 0);
end;

procedure TXLConditionalFormatting.addAboveAverageRule(cFormat: TXLConditionalFormat; aboveAverage, equalAverage: Boolean; stdDev: Integer);
begin
  xlConditionalFormattingAddAboveAverageRule(handle, cFormat.handle, Integer(aboveAverage), Integer(equalAverage), stdDev, 0);
end;

procedure TXLConditionalFormatting.addAboveAverageRule(cFormat: TXLConditionalFormat; aboveAverage, equalAverage: Boolean; stdDev: Integer; stopIfTrue: Boolean);
begin
  xlConditionalFormattingAddAboveAverageRule(handle, cFormat.handle, Integer(aboveAverage), Integer(equalAverage), stdDev, Integer(stopIfTrue));
end;

procedure TXLConditionalFormatting.addTimePeriodRule(cFormat: TXLConditionalFormat; timePeriod: CFormatTimePeriod);
begin
  xlConditionalFormattingAddTimePeriodRule(handle, cFormat.handle, Integer(timePeriod), 0);
end;

procedure TXLConditionalFormatting.addTimePeriodRule(cFormat: TXLConditionalFormat; timePeriod: CFormatTimePeriod; stopIfTrue: Boolean);
begin
  xlConditionalFormattingAddTimePeriodRule(handle, cFormat.handle, Integer(timePeriod), Integer(stopIfTrue));
end;

procedure TXLConditionalFormatting.add2ColorScaleRule(minColor, maxColor: Color);
begin
  xlConditionalFormattingAdd2ColorScaleRule(handle, Integer(minColor), Integer(maxColor), Integer(CFVO_MIN), 0, Integer(CFVO_MAX), 0, 0);
end;

procedure TXLConditionalFormatting.add2ColorScaleRule(minColor, maxColor: Color; minType: CFVOType; minValue: Double; maxType: CFVOType; maxValue: Double);
begin
  xlConditionalFormattingAdd2ColorScaleRule(handle, Integer(minColor), Integer(maxColor), Integer(minType), minValue, Integer(maxType), maxValue, 0);
end;

procedure TXLConditionalFormatting.add2ColorScaleRule(minColor, maxColor: Color; minType: CFVOType; minValue: Double; maxType: CFVOType; maxValue: Double; stopIfTrue: Boolean);
begin
  xlConditionalFormattingAdd2ColorScaleRule(handle, Integer(minColor), Integer(maxColor), Integer(minType), minValue, Integer(maxType), maxValue, Integer(stopIfTrue));
end;

procedure TXLConditionalFormatting.add2ColorScaleFormulaRule(minColor, maxColor: Color; minType: CFVOType; minValue: PWideChar; maxType: CFVOType; maxValue: PWideChar);
begin
  xlConditionalFormattingAdd2ColorScaleFormulaRule(handle, Integer(minColor), Integer(maxColor), Integer(minType), minValue, Integer(maxType), maxValue, 0);
end;

procedure TXLConditionalFormatting.add2ColorScaleFormulaRule(minColor, maxColor: Color; minType: CFVOType; minValue: PWideChar; maxType: CFVOType; maxValue: PWideChar; stopIfTrue: Boolean);
begin
  xlConditionalFormattingAdd2ColorScaleFormulaRule(handle, Integer(minColor), Integer(maxColor), Integer(minType), minValue, Integer(maxType), maxValue, Integer(stopIfTrue));
end;

procedure TXLConditionalFormatting.add3ColorScaleRule(minColor, midColor, maxColor: Color);
begin
  xlConditionalFormattingAdd3ColorScaleRule(handle, Integer(minColor), Integer(midColor), Integer(maxColor), Integer(CFVO_MIN), 0, Integer(CFVO_PERCENTILE), 50, Integer(CFVO_MAX), 0, 0);
end;

procedure TXLConditionalFormatting.add3ColorScaleRule(minColor, midColor, maxColor: Color; minType: CFVOType; minValue: Double; midType: CFVOType; midValue: Double; maxType: CFVOType; maxValue: Double);
begin
  xlConditionalFormattingAdd3ColorScaleRule(handle, Integer(minColor), Integer(midColor), Integer(maxColor), Integer(minType), minValue, Integer(midType), midValue, Integer(maxType), maxValue, 0);
end;

procedure TXLConditionalFormatting.add3ColorScaleRule(minColor, midColor, maxColor: Color; minType: CFVOType; minValue: Double; midType: CFVOType; midValue: Double; maxType: CFVOType; maxValue: Double; stopIfTrue: Boolean);
begin
  xlConditionalFormattingAdd3ColorScaleRule(handle, Integer(minColor), Integer(midColor), Integer(maxColor), Integer(minType), minValue, Integer(midType), midValue, Integer(maxType), maxValue, Integer(stopIfTrue));
end;

procedure TXLConditionalFormatting.add3ColorScaleFormulaRule(minColor, midColor, maxColor: Color; minType: CFVOType; minValue: PWideChar; midType: CFVOType; midValue: PWideChar; maxType: CFVOType; maxValue: PWideChar);
begin
  xlConditionalFormattingAdd3ColorScaleFormulaRule(handle, Integer(minColor), Integer(midColor), Integer(maxColor), Integer(minType), minValue, Integer(midType), midValue, Integer(maxType), maxValue, 0);
end;

procedure TXLConditionalFormatting.add3ColorScaleFormulaRule(minColor, midColor, maxColor: Color; minType: CFVOType; minValue: PWideChar; midType: CFVOType; midValue: PWideChar; maxType: CFVOType; maxValue: PWideChar; stopIfTrue: Boolean);
begin
  xlConditionalFormattingAdd3ColorScaleFormulaRule(handle, Integer(minColor), Integer(midColor), Integer(maxColor), Integer(minType), minValue, Integer(midType), midValue, Integer(maxType), maxValue, Integer(stopIfTrue));
end;

constructor TXLConditionalFormatting.Create(handle: ConditionalFormattingHandle);
begin
  inherited Create;
  Self.handle := handle;
end;

//////////////////////////////////////////////////

constructor TXLFormControl.Create(handle: FormControlHandle);
begin
  inherited Create;
  Self.handle := handle;
end;

function TXLFormControl.GetObjectType: ObjectType;
begin
  Result := LibXL.ObjectType(xlFormControlObjectType(handle));
end;

function TXLFormControl.GetChecked: CheckedType;
begin
  Result := LibXL.CheckedType(xlFormControlChecked(handle));
end;

procedure TXLFormControl.SetChecked(checked: CheckedType);
begin
  xlFormControlSetChecked(handle, Integer(checked));
end;

function TXLFormControl.GetFmlaGroup: WideString;
begin
  Result := WideString(xlFormControlFmlaGroup(handle));
end;

procedure TXLFormControl.SetFmlaGroup(const fmlaGroup: WideString);
begin
  xlFormControlSetFmlaGroup(handle, PWideChar(fmlaGroup));
end;

function TXLFormControl.GetFmlaLink: WideString;
begin
  Result := WideString(xlFormControlFmlaLink(handle));
end;

procedure TXLFormControl.SetFmlaLink(const fmlaLink: WideString);
begin
  xlFormControlSetFmlaLink(handle, PWideChar(fmlaLink));
end;

function TXLFormControl.GetFmlaRange: WideString;
begin
  Result := WideString(xlFormControlFmlaRange(handle));
end;

procedure TXLFormControl.SetFmlaRange(const fmlaRange: WideString);
begin
  xlFormControlSetFmlaRange(handle, PWideChar(fmlaRange));
end;

function TXLFormControl.GetFmlaTxbx: WideString;
begin
  Result := WideString(xlFormControlFmlaTxbx(handle));
end;

procedure TXLFormControl.SetFmlaTxbx(const fmlaTxbx: WideString);
begin
  xlFormControlSetFmlaTxbx(handle, PWideChar(fmlaTxbx));
end;

function TXLFormControl.GetName: WideString;
begin
  Result := WideString(xlFormControlName(handle));
end;

function TXLFormControl.GetLinkedCell: WideString;
begin
  Result := WideString(xlFormControlLinkedCell(handle));
end;

function TXLFormControl.GetListFillRange: WideString;
begin
  Result := WideString(xlFormControlListFillRange(handle));
end;

function TXLFormControl.GetMacro: WideString;
begin
  Result := WideString(xlFormControlMacro(handle));
end;

function TXLFormControl.GetAltText: WideString;
begin
  Result := WideString(xlFormControlAltText(handle));
end;

function TXLFormControl.GetLocked: Boolean;
begin
  Result := xlFormControlLocked(handle) > 0;
end;

function TXLFormControl.GetDefaultSize: Boolean;
begin
  Result := xlFormControlDefaultSize(handle) > 0;
end;

function TXLFormControl.GetPrint: Boolean;
begin
  Result := xlFormControlPrint(handle) > 0;
end;

function TXLFormControl.GetDisabled: Boolean;
begin
  Result := xlFormControlDisabled(handle) > 0;
end;

function TXLFormControl.item(index: Integer): WideString;
begin
  Result := WideString(xlFormControlItem(handle, index));
end;

function TXLFormControl.itemSize: Integer;
begin
  Result := xlFormControlItemSize(handle);
end;

procedure TXLFormControl.addItem(value: PWideChar);
begin
  xlFormControlAddItem(handle, value);
end;

procedure TXLFormControl.insertItem(index: Integer; value: PWideChar);
begin
  xlFormControlInsertItem(handle, index, value);
end;

procedure TXLFormControl.clearItems;
begin
  xlFormControlClearItems(handle);
end;

function TXLFormControl.GetDropLines: Integer;
begin
  Result := xlFormControlDropLines(handle);
end;

procedure TXLFormControl.SetDropLines(dropLines: Integer);
begin
  xlFormControlSetDropLines(handle, dropLines);
end;

function TXLFormControl.GetDx: Integer;
begin
  Result := xlFormControlDx(handle);
end;

procedure TXLFormControl.SetDx(dx: Integer);
begin
  xlFormControlSetDx(handle, dx);
end;

function TXLFormControl.GetFirstButton: Boolean;
begin
  Result := xlFormControlFirstButton(handle) > 0;
end;

procedure TXLFormControl.SetFirstButton(firstButton: Boolean);
begin
  xlFormControlSetFirstButton(handle, Integer(firstButton));
end;

function TXLFormControl.GetHoriz: Boolean;
begin
  Result := xlFormControlHoriz(handle) > 0;
end;

procedure TXLFormControl.SetHoriz(horiz: Boolean);
begin
  xlFormControlSetHoriz(handle, Integer(horiz));
end;

function TXLFormControl.GetInc: Integer;
begin
  Result := xlFormControlInc(handle);
end;

procedure TXLFormControl.SetInc(inc: Integer);
begin
  xlFormControlSetInc(handle, inc);
end;

function TXLFormControl.GetMax: Integer;
begin
  Result := xlFormControlGetMax(handle);
end;

procedure TXLFormControl.SetMax(max: Integer);
begin
  xlFormControlSetMax(handle, max);
end;

function TXLFormControl.GetMin: Integer;
begin
  Result := xlFormControlGetMin(handle);
end;

procedure TXLFormControl.SetMin(min: Integer);
begin
  xlFormControlSetMin(handle, min);
end;

function TXLFormControl.GetMultiSel: WideString;
begin
  Result := WideString(xlFormControlMultiSel(handle));
end;

procedure TXLFormControl.SetMultiSel(const multiSel: WideString);
begin
  xlFormControlSetMultiSel(handle, PWideChar(multiSel));
end;

function TXLFormControl.GetSel: Integer;
begin
  Result := xlFormControlSel(handle);
end;

procedure TXLFormControl.SetSel(sel: Integer);
begin
  xlFormControlSetSel(handle, sel);
end;

function TXLFormControl.fromAnchor(var col, colOff, row, rowOff: Integer): Boolean;
begin
  Result := xlFormControlFromAnchor(handle, @col, @colOff, @row, @rowOff) > 0;
end;

function TXLFormControl.toAnchor(var col, colOff, row, rowOff: Integer): Boolean;
begin
  Result := xlFormControlToAnchor(handle, @col, @colOff, @row, @rowOff) > 0;
end;

//////////////////////////////////////////////////

constructor TXLCoreProperties.Create(handle: CorePropertiesHandle);
begin
  inherited Create;
  Self.handle := handle;
end;

function TXLCoreProperties.GetTitle: WideString;
begin
  Result := WideString(xlCorePropertiesTitle(handle));
end;

procedure TXLCoreProperties.SetTitle(const value: WideString);
begin
  xlCorePropertiesSetTitle(handle, PWideChar(value));
end;

function TXLCoreProperties.GetSubject: WideString;
begin
  Result := WideString(xlCorePropertiesSubject(handle));
end;

procedure TXLCoreProperties.SetSubject(const value: WideString);
begin
  xlCorePropertiesSetSubject(handle, PWideChar(value));
end;

function TXLCoreProperties.GetCreator: WideString;
begin
  Result := WideString(xlCorePropertiesCreator(handle));
end;

procedure TXLCoreProperties.SetCreator(const value: WideString);
begin
  xlCorePropertiesSetCreator(handle, PWideChar(value));
end;

function TXLCoreProperties.GetLastModifiedBy: WideString;
begin
  Result := WideString(xlCorePropertiesLastModifiedBy(handle));
end;

procedure TXLCoreProperties.SetLastModifiedBy(const value: WideString);
begin
  xlCorePropertiesSetLastModifiedBy(handle, PWideChar(value));
end;

function TXLCoreProperties.GetCreated: WideString;
begin
  Result := WideString(xlCorePropertiesCreated(handle));
end;

procedure TXLCoreProperties.SetCreated(const value: WideString);
begin
  xlCorePropertiesSetCreated(handle, PWideChar(value));
end;

function TXLCoreProperties.GetCreatedAsDouble: Double;
begin
  Result := xlCorePropertiesCreatedAsDouble(handle);
end;

procedure TXLCoreProperties.SetCreatedAsDouble(value: Double);
begin
  xlCorePropertiesSetCreatedAsDouble(handle, value);
end;

function TXLCoreProperties.GetModified: WideString;
begin
  Result := WideString(xlCorePropertiesModified(handle));
end;

procedure TXLCoreProperties.SetModified(const value: WideString);
begin
  xlCorePropertiesSetModified(handle, PWideChar(value));
end;

function TXLCoreProperties.GetModifiedAsDouble: Double;
begin
  Result := xlCorePropertiesModifiedAsDouble(handle);
end;

procedure TXLCoreProperties.SetModifiedAsDouble(value: Double);
begin
  xlCorePropertiesSetModifiedAsDouble(handle, value);
end;

function TXLCoreProperties.GetTags: WideString;
begin
  Result := WideString(xlCorePropertiesTags(handle));
end;

procedure TXLCoreProperties.SetTags(const value: WideString);
begin
  xlCorePropertiesSetTags(handle, PWideChar(value));
end;

function TXLCoreProperties.GetCategories: WideString;
begin
  Result := WideString(xlCorePropertiesCategories(handle));
end;

procedure TXLCoreProperties.SetCategories(const value: WideString);
begin
  xlCorePropertiesSetCategories(handle, PWideChar(value));
end;

function TXLCoreProperties.GetComments: WideString;
begin
  Result := WideString(xlCorePropertiesComments(handle));
end;

procedure TXLCoreProperties.SetComments(const value: WideString);
begin
  xlCorePropertiesSetComments(handle, PWideChar(value));
end;

procedure TXLCoreProperties.removeAll;
begin
  xlCorePropertiesRemoveAll(handle);
end;

///////////////////////////////////////////////////////////////////////////

function TXLTable.GetName: WideString;
begin
  Result := WideString(xlTableName(handle));
end;

procedure TXLTable.SetName(const value: WideString);
begin
  xlTableSetName(handle, PWideChar(value));
end;

function TXLTable.GetRef: WideString;
begin
  Result := WideString(xlTableRef(handle));
end;

procedure TXLTable.SetRef(const value: WideString);
begin
  xlTableSetRef(handle, PWideChar(value));
end;

function TXLTable.GetTableStyle: TableStyle;
begin
  Result := LibXL.TableStyle(xlTableStyle(handle));
end;

procedure TXLTable.SetTableStyle(const value: TableStyle);
begin
  xlTableSetStyle(handle, Integer(value));
end;

function TXLTable.GetShowRowStripes: Boolean;
begin
  Result := xlTableShowRowStripes(handle) > 0;
end;

procedure TXLTable.SetShowRowStripes(const value: Boolean);
begin
  xlTableSetShowRowStripes(handle, Integer(value));
end;

function TXLTable.GetShowColumnStripes: Boolean;
begin
  Result := xlTableShowColumnStripes(handle) > 0;
end;

procedure TXLTable.SetShowColumnStripes(const value: Boolean);
begin
  xlTableSetShowColumnStripes(handle, Integer(value));
end;

function TXLTable.GetShowFirstColumn: Boolean;
begin
  Result := xlTableShowFirstColumn(handle) > 0;
end;

procedure TXLTable.SetShowFirstColumn(const value: Boolean);
begin
  xlTableSetShowFirstColumn(handle, Integer(value));
end;

function TXLTable.GetShowLastColumn: Boolean;
begin
  Result := xlTableShowLastColumn(handle) > 0;
end;

procedure TXLTable.SetShowLastColumn(const value: Boolean);
begin
  xlTableSetShowLastColumn(handle, Integer(value));
end;

function TXLTable.GetColumnSize: Integer;
begin
  Result := xlTableColumnSize(handle);
end;

function TXLTable.autoFilter: TXLAutoFilter;
var
  autoFilterH: AutoFilterHandle;
begin
  if xlAutoFilter = nil then
  begin
    autoFilterH := xlTableAutoFilter(handle);
    if autoFilterH <> nil then
    begin
      Result := TXLAutoFilter.Create(autoFilterH, book);
      xlAutoFilter := Result;
    end
    else
      Result := nil;
  end
  else
    Result := xlAutoFilter;
end;

function TXLTable.columnName(columnIndex: Integer): WideString;
begin
  Result := WideString(xlTableColumnName(handle, columnIndex));
end;

function TXLTable.setColumnName(columnIndex: Integer; const _name: PWideChar): Integer;
begin
  Result := xlTableSetColumnName(handle, columnIndex, PWideChar(_name));
end;

constructor TXLTable.Create(handle: TableHandle; book: BookHandle);
begin
  inherited Create;
  Self.book := book;
  Self.handle := handle;
end;

destructor TXLTable.Destroy;
begin
  if xlAutoFilter <> nil then xlAutoFilter.Free;
  inherited Destroy;
end;

/////////////////////////////////////////////////////////////////////

constructor TXLRichString.Create(handle: RichStringHandle; book: BookHandle);
begin
  inherited Create;
  Self.book := book;
  Self.handle := handle;
end;

destructor TXLRichString.Destroy;
var
  i: Integer;
begin
  for i := 0 to High(fonts) do fonts[i].Free;
  inherited Destroy;
end;

function TXLRichString.addFont: TXLFont;
var
  fntHandle: FontHandle;
begin
  fntHandle := xlRichStringAddFont(handle, nil);
  if fntHandle <> nil then
  begin
    Result := TXLFont.Create(fntHandle, book);
    xlAddFont(fonts, Result);
  end
  else
    Result := nil;
end;

function TXLRichString.addFont(initFont: TXLFont): TXLFont;
var
  fntHandle: FontHandle;
begin
  fntHandle := xlRichStringAddFont(handle, initFont.handle);
  if fntHandle <> nil then
  begin
    Result := TXLFont.Create(fntHandle, book);
    xlAddFont(fonts, Result);
  end
  else
    Result := nil;
end;

procedure TXLRichString.addText(const text: PWideChar);
begin
  xlRichStringAddText(handle, text, nil);
end;

procedure TXLRichString.addText(const text: PWideChar; font: TXLFont);
begin
  xlRichStringAddText(handle, text, font.handle);
end;

function TXLRichString.getText(index: Integer): WideString;
var
  fntHandle: FontHandle;
begin
  Result := WideString(xlRichStringGetText(handle, index, @fntHandle));
end;

function TXLRichString.getText(index: Integer; var font: TXLFont): WideString;
var
  fntHandle: FontHandle;
begin
  Result := WideString(xlRichStringGetText(handle, index, @fntHandle));
  if fntHandle <> nil then
  begin
    font := TXLFont.Create(fntHandle, book);
    xlAddFont(fonts, font);
  end
  else
    font := nil;
end;

function TXLRichString.textSize: Integer;
begin
  Result := xlRichStringTextSize(handle);
end;

////////////////////////////////////////////////////////////////////////////////

constructor TXLFilterColumn.Create(handle: FilterColumnHandle; book: BookHandle);
begin
  inherited Create;
  Self.book := book;
  Self.handle := handle;
end;

destructor TXLFilterColumn.Destroy;
begin
  inherited Destroy;
end;

function TXLFilterColumn.index: Integer;
begin
  Result := xlFilterColumnIndex(handle);
end;

function TXLFilterColumn.filterType: Filter;
begin
  Result := LibXL.Filter(xlFilterColumnFilterType(handle));
end;

function TXLFilterColumn.filterSize: Integer;
begin
  Result := xlFilterColumnFilterSize(handle);
end;

function TXLFilterColumn.filter(idx: Integer): PWideChar;
begin
  Result := xlFilterColumnFilter(handle, idx);
end;

procedure TXLFilterColumn.addFilter(const value: PWideChar);
begin
  xlFilterColumnAddFilter(handle, value);
end;

function TXLFilterColumn.getTop10(var value: Double; var top, percent: Boolean): Boolean;
var
  iTop, iPercent: Integer;
begin
  Result := xlFilterColumnGetTop10(handle, @value, @iTop, @iPercent) > 0;
  top := iTop > 0;
  percent := iPercent > 0;
end;

procedure TXLFilterColumn.setTop10(value: Double);
begin
  xlFilterColumnSetTop10(handle, value, 1, 0);
end;

procedure TXLFilterColumn.setTop10(value: Double; top: Boolean);
begin
  xlFilterColumnSetTop10(handle, value, Integer(top), 0);
end;

procedure TXLFilterColumn.setTop10(value: Double; top, percent: Boolean);
begin
  xlFilterColumnSetTop10(handle, value, Integer(top), Integer(percent));
end;

function TXLFilterColumn.getCustomFilter(var op1: Op; var v1: PWideChar; var op2: Op; var v2: PWideChar; var andOp: Boolean): Boolean;
var
  iOp1, iOp2, iAndOp: Integer;
begin
  Result := xlFilterColumnGetCustomFilter(handle, @iOp1, @v1, @iOp2, @v2, @iAndOp) > 0;
  op1 := Op(iOp1);
  op2 := Op(iOp2);
  andOp := iAndOp > 0;
end;

procedure TXLFilterColumn.setCustomFilter(op: Op; const v: PWideChar);
begin
  xlFilterColumnSetCustomFilter(handle, Integer(op), v);
end;

procedure TXLFilterColumn.setCustomFilter(op1: Op; const v1: PWideChar; op2: Op; const v2: PWideChar; andOp: Boolean);
begin
  xlFilterColumnSetCustomFilterEx(handle, Integer(op1), v1, Integer(op2), v2, Integer(andOp));
end;

procedure TXLFilterColumn.clear;
begin
  xlFilterColumnClear(handle);
end;

constructor TXLAutoFilter.Create(handle: AutoFilterHandle; book: BookHandle);
begin
  inherited Create;
  Self.book := book;
  Self.handle := handle;
end;

destructor TXLAutoFilter.Destroy;
var
  i: Integer;
begin
  for i := 0 to High(filterColumns) do filterColumns[i].Free;
  inherited Destroy;
end;

function TXLAutoFilter.getRef(var rowFirst, rowLast, colFirst, colLast: Integer): Boolean;
begin
  Result := xlAutoFilterGetRef(handle, @rowFirst, @rowLast, @colFirst, @colLast) > 0;
end;

procedure TXLAutoFilter.setRef(rowFirst, rowLast, colFirst, colLast: Integer);
begin
  xlAutoFilterSetRef(handle, rowFirst, rowLast, colFirst, colLast);
end;

function TXLAutoFilter.column(colId: Integer): TXLFilterColumn;
var
  fcHandle: FilterColumnHandle;
begin
  fcHandle := xlAutoFilterColumn(handle, colId);
  Result := TXLFilterColumn.Create(fcHandle, book);
  xlAddFilterColumn(filterColumns, Result);
end;

function TXLAutoFilter.columnSize: Integer;
begin
  Result := xlAutoFilterColumnSize(handle);
end;

function TXLAutoFilter.columnByIndex(index: Integer): TXLFilterColumn;
var
  fcHandle: FilterColumnHandle;
begin
  fcHandle := xlAutoFilterColumnByIndex(handle, index);
  Result := TXLFilterColumn.Create(fcHandle, book);
  xlAddFilterColumn(filterColumns, Result);
end;

function TXLAutoFilter.getSortRange(var rowFirst, rowLast, colFirst, colLast: Integer): Boolean;
begin
  Result := xlAutoFilterGetSortRange(handle, @rowFirst, @rowLast, @colFirst, @colLast) > 0;
end;

function TXLAutoFilter.getSort(var columnIndex: Integer; var descending: Boolean): Boolean;
var
  iDescending: Integer;
begin
  Result := xlAutoFilterGetSort(handle, @columnIndex, @iDescending) > 0;
  descending := iDescending > 0;
end;

function TXLAutoFilter.setSort(columnIndex: Integer; descending: Boolean): Boolean;
begin
  Result := xlAutoFilterSetSort(handle, columnIndex, Integer(descending)) > 0;
end;

function TXLAutoFilter.addSort(columnIndex: Integer; descending: Boolean): Boolean;
begin
  Result := xlAutoFilterAddSort(handle, columnIndex, Integer(descending)) > 0;
end;

constructor TXLFont.Create(handle: FontHandle; book: BookHandle);
begin
  inherited Create;
  Self.book := book;
  Self.handle := handle;
end;

destructor TXLFont.Destroy;
begin
  inherited Destroy;
end;

function TXLFont.GetBold: Boolean;
begin
  Result := (xlFontBold(handle) > 0);
end;

procedure TXLFont.SetBold(const value: Boolean);
begin
  xlFontSetBold(handle, Integer(value));
end;

function TXLFont.GetName: WideString;
begin
  Result := WideString(xlFontName(handle));
end;

procedure TXLFont.SetName(const value: WideString);
begin
  xlFontSetName(handle, PWideChar(value));
end;

function TXLFont.GetSize: Integer;
begin
  Result := xlFontSize(handle);
end;

procedure TXLFont.SetSize(const value: Integer);
begin
  xlFontSetSize(handle, value);
end;

function TXLFont.GetUnderline: Underline;
begin
  Result := LibXL.Underline(xlFontUnderline(handle));
end;

procedure TXLFont.SetUnderline(const value: Underline);
begin
  xlFontSetUnderline(handle, Integer(value));
end;

function TXLFont.GetColor: Color;
begin
  Result := LibXL.Color(xlFontColor(handle));
end;

procedure TXLFont.SetColor(const value: Color);
begin
  xlFontSetColor(handle, Integer(value));
end;

procedure TXLFont.SetItalic(const value: Boolean);
begin
  xlFontSetItalic(handle, Integer(value));
end;

function TXLFont.GetItalic: Boolean;
begin
  Result := (xlFontItalic(handle) > 0);
end;

procedure TXLFont.SetScript(const value: Script);
begin
  xlFontSetScript(handle, Integer(value));
end;

function TXLFont.GetScript: Script;
begin
  Result := LibXL.Script(xlFontScript(handle));
end;

procedure TXLFont.SetStrikeOut(const value: Boolean);
begin
  xlFontSetStrikeOut(handle, Integer(value));
end;

function TXLFont.GetStrikeOut: Boolean;
begin
  Result := (xlFontStrikeOut(handle) > 0);
end;

constructor TXLFormat.Create(handle: FormatHandle; book: BookHandle);
begin
  inherited Create;
  Self.book := book;
  Self.handle := handle;
end;

destructor TXLFormat.Destroy;
begin
  if ffont <> nil then ffont.Free;
  inherited Destroy;
end;

procedure TXLFormat.SetBorderDiagonal(const value: BorderDiagonal);
begin
  xlFormatSetBorderDiagonal(handle, Integer(value));
end;

procedure TXLFormat.SetBorderDiagonalStyle(const value: BorderStyle);
begin
  xlFormatSetBorderDiagonalStyle(handle, Integer(value));
end;

procedure TXLFormat.SetBorderDiagonalColor(const value: Color);
begin
  xlFormatSetBorderDiagonalColor(handle, Integer(value));
end;

procedure TXLFormat.SetBorderLeft(const value: BorderStyle);
begin
  xlFormatSetBorderLeft(handle, Integer(value));
end;

procedure TXLFormat.SetBorderLeftColor(const value: Color);
begin
  xlFormatSetBorderLeftColor(handle, Integer(value));
end;

procedure TXLFormat.SetBorderRight(const value: BorderStyle);
begin
  xlFormatSetBorderRight(handle, Integer(value));
end;

procedure TXLFormat.SetBorderRightColor(const value: Color);
begin
  xlFormatSetBorderRightColor(handle, Integer(value));
end;

procedure TXLFormat.SetBorderTop(const value: BorderStyle);
begin
  xlFormatSetBorderTop(handle, Integer(value));
end;

procedure TXLFormat.SetBorderTopColor(const value: Color);
begin
  xlFormatSetBorderTopColor(handle, Integer(value));
end;

procedure TXLFormat.SetFillPattern(const value: FillPattern);
begin
  xlFormatSetFillPattern(handle, Integer(value));
end;

procedure TXLFormat.SetFont(const value: TXLFont);
begin
  xlFormatSetFont(handle, value.handle);
end;

function TXLFormat.GetAlignH: AlignH;
begin
  Result := LibXL.AlignH(xlFormatAlignH(handle));
end;

function TXLFormat.GetAlignV: AlignV;
begin
  Result := LibXL.AlignV(xlFormatAlignV(handle));
end;

function TXLFormat.GetBorderBottom: BorderStyle;
begin
  Result := BorderStyle(xlFormatBorderBottom(handle));
end;

function TXLFormat.GetBorderBottomColor: Color;
begin
  Result := Color(xlFormatBorderBottomColor(handle));
end;

function TXLFormat.GetBorderDiagonal: BorderDiagonal;
begin
  Result := LibXL.BorderDiagonal(xlFormatBorderDiagonal(handle));
end;

function TXLFormat.GetBorderDiagonalStyle: BorderStyle;
begin
  Result := LibXL.BorderStyle(xlFormatBorderDiagonalStyle(handle));
end;

function TXLFormat.GetBorderDiagonalColor: Color;
begin
  Result := Color(xlFormatBorderDiagonalColor(handle));
end;

function TXLFormat.GetBorderLeft: BorderStyle;
begin
  Result := BorderStyle(xlFormatBorderLeft(handle));
end;

function TXLFormat.GetBorderLeftColor: Color;
begin
  Result := Color(xlFormatBorderLeftColor(handle));
end;

function TXLFormat.GetBorderRight: BorderStyle;
begin
  Result := BorderStyle(xlFormatBorderRight(handle));
end;

function TXLFormat.GetBorderRightColor: Color;
begin
  Result := Color(xlFormatBorderRightColor(handle));
end;

function TXLFormat.GetBorderTop: BorderStyle;
begin
  Result := BorderStyle(xlFormatBorderTop(handle));
end;

function TXLFormat.GetBorderTopColor: Color;
begin
  Result := Color(xlFormatBorderTopColor(handle));
end;

function TXLFormat.GetFillPattern: FillPattern;
begin
  Result := LibXL.FillPattern(xlFormatFillPattern(handle));
end;

procedure TXLFormat.SetHidden(const value: Boolean);
begin
  xlFormatSetHidden(handle, Integer(value));
end;

procedure TXLFormat.SetIndent(const value: Integer);
begin
  xlFormatSetIndent(handle, Integer(value));
end;

procedure TXLFormat.SetLocked(const value: Boolean);
begin
  xlFormatSetLocked(handle, Integer(value));
end;

function TXLFormat.GetFont: TXLFont;
var
  f: FontHandle;
begin
  if ffont = nil then
  begin
    f := xlFormatFont(handle);
    if f <> nil then
    begin
      Result := TXLFont.Create(f, book);
      ffont := Result;
    end
    else
      Result := nil;
  end
  else
    Result := ffont;
end;

function TXLFormat.GetHidden: Boolean;
begin
  Result := (xlFormatHidden(handle) > 0);
end;

function TXLFormat.GetIndent: Integer;
begin
  Result := (xlFormatIndent(handle));
end;

function TXLFormat.GetLocked: Boolean;
begin
  Result := (xlFormatLocked(handle) > 0);
end;

function TXLFormat.GetPatternBackgroundColor: Color;
begin
  Result := Color(xlFormatPatternBackgroundColor(handle));
end;

function TXLFormat.GetPatternForegroundColor: Color;
begin
  Result := Color(xlFormatPatternForegroundColor(handle));
end;

function TXLFormat.GetRotation: Integer;
begin
  Result := xlFormatRotation(handle);
end;

function TXLFormat.GetShrinkToFit: Boolean;
begin
  Result := (xlFormatShrinkToFit(handle) > 0);
end;

function TXLFormat.GetWrap: Boolean;
begin
  Result := (xlFormatWrap(handle) > 0);
end;

function TXLFormat.numFormat: Integer;
begin
  Result := xlFormatNumFormat(handle);
end;

procedure TXLFormat.SetAlignH(const value: AlignH);
begin
  xlFormatSetAlignH(handle, Integer(value));
end;

procedure TXLFormat.SetAlignV(const value: AlignV);
begin
  xlFormatSetAlignV(handle, Integer(value));
end;

procedure TXLFormat.setNumFormat(nFormat: Integer);
begin
  xlFormatSetNumFormat(handle, nFormat);
end;

procedure TXLFormat.setNumFormat(value: NumFormat);
begin
  xlFormatSetNumFormat(handle, Integer(value));
end;

procedure TXLFormat.SetPatternBackgroundColor(const value: Color);
begin
  xlFormatSetPatternBackgroundColor(handle, Integer(value));
end;

procedure TXLFormat.SetPatternForegroundColor(const value: Color);
begin
  xlFormatSetPatternForegroundColor(handle, Integer(value));
end;

procedure TXLFormat.SetRotation(const value: Integer);
begin
  xlFormatSetRotation(handle, value);
end;

procedure TXLFormat.SetShrinkToFit(const value: Boolean);
begin
  xlFormatSetShrinkToFit(handle, Integer(value));
end;

procedure TXLFormat.SetWrap(const value: Boolean);
begin
  xlFormatSetWrap(handle, Integer(value));
end;

procedure TXLFormat.setBorder(style: BorderStyle);
begin
  xlFormatSetBorder(handle, Integer(style));
end;

procedure TXLFormat.SetBorderBottom(const value: BorderStyle);
begin
  xlFormatSetBorderBottom(handle, Integer(value));
end;

procedure TXLFormat.SetBorderBottomColor(const value: Color);
begin
  xlFormatSetBorderBottomColor(handle, Integer(value));
end;

procedure TXLFormat.setBorderColor(value: Color);
begin
  xlFormatSetBorderColor(handle, Integer(value));
end;

//////////////////////

constructor TXLConditionalFormat.Create(handle: ConditionalFormatHandle; book: BookHandle);
begin
  inherited Create;
  Self.book := book;
  Self.handle := handle;
end;

destructor TXLConditionalFormat.Destroy;
begin
  if ffont <> nil then ffont.Free;
  inherited Destroy;
end;

function TXLConditionalFormat.GetFont: TXLFont;
var
  f: FontHandle;
begin
  if ffont = nil then
  begin
    f := xlConditionalFormatFont(handle);
    if f <> nil then
    begin
      Result := TXLFont.Create(f, book);
      ffont := Result;
    end
    else
      Result := nil;
  end
  else
    Result := ffont;
end;

function TXLConditionalFormat.numFormat: NumFormat;
begin
  Result := LibXL.NumFormat(xlConditionalFormatNumFormat(handle));
end;

procedure TXLConditionalFormat.setNumFormat(nFormat: NumFormat);
begin
  xlConditionalFormatSetNumFormat(handle, Integer(nFormat));
end;

function TXLConditionalFormat.customNumFormat: WideString;
begin
  Result := WideString(xlConditionalFormatCustomNumFormat(handle));
end;

procedure TXLConditionalFormat.setCustomNumFormat(customNFormat: PWideChar);
begin
  xlConditionalFormatSetCustomNumFormat(handle, customNFormat);
end;

procedure TXLConditionalFormat.setBorder(style: BorderStyle);
begin
  xlConditionalFormatSetBorder(handle, Integer(style));
end;

procedure TXLConditionalFormat.setBorderColor(value: Color);
begin
  xlConditionalFormatSetBorderColor(handle, Integer(value));
end;

procedure TXLConditionalFormat.SetBorderLeft(const value: BorderStyle);
begin
  xlConditionalFormatSetBorderLeft(handle, Integer(value));
end;

function TXLConditionalFormat.GetBorderLeft: BorderStyle;
begin
  Result := LibXL.BorderStyle(xlConditionalFormatBorderLeft(handle));
end;

procedure TXLConditionalFormat.SetBorderRight(const value: BorderStyle);
begin
  xlConditionalFormatSetBorderRight(handle, Integer(value));
end;

function TXLConditionalFormat.GetBorderRight: BorderStyle;
begin
  Result := LibXL.BorderStyle(xlConditionalFormatBorderRight(handle));
end;

procedure TXLConditionalFormat.SetBorderTop(const value: BorderStyle);
begin
  xlConditionalFormatSetBorderTop(handle, Integer(value));
end;

function TXLConditionalFormat.GetBorderTop: BorderStyle;
begin
  Result := LibXL.BorderStyle(xlConditionalFormatBorderTop(handle));
end;

procedure TXLConditionalFormat.SetBorderBottom(const value: BorderStyle);
begin
  xlConditionalFormatSetBorderBottom(handle, Integer(value));
end;

function TXLConditionalFormat.GetBorderBottom: BorderStyle;
begin
  Result := LibXL.BorderStyle(xlConditionalFormatBorderBottom(handle));
end;

procedure TXLConditionalFormat.SetBorderLeftColor(const value: Color);
begin
  xlConditionalFormatSetBorderLeftColor(handle, Integer(value));
end;

function TXLConditionalFormat.GetBorderLeftColor: Color;
begin
  Result := LibXL.Color(xlConditionalFormatBorderLeftColor(handle));
end;

procedure TXLConditionalFormat.SetBorderRightColor(const value: Color);
begin
  xlConditionalFormatSetBorderRightColor(handle, Integer(value));
end;

function TXLConditionalFormat.GetBorderRightColor: Color;
begin
  Result := LibXL.Color(xlConditionalFormatBorderRightColor(handle));
end;

procedure TXLConditionalFormat.SetBorderTopColor(const value: Color);
begin
  xlConditionalFormatSetBorderTopColor(handle, Integer(value));
end;

function TXLConditionalFormat.GetBorderTopColor: Color;
begin
  Result := LibXL.Color(xlConditionalFormatBorderTopColor(handle));
end;

procedure TXLConditionalFormat.SetBorderBottomColor(const value: Color);
begin
  xlConditionalFormatSetBorderBottomColor(handle, Integer(value));
end;

function TXLConditionalFormat.GetBorderBottomColor: Color;
begin
  Result := LibXL.Color(xlConditionalFormatBorderBottomColor(handle));
end;

procedure TXLConditionalFormat.SetFillPattern(const value: FillPattern);
begin
  xlConditionalFormatSetFillPattern(handle, Integer(value));
end;

function TXLConditionalFormat.GetFillPattern: FillPattern;
begin
  Result := LibXL.FillPattern(xlConditionalFormatFillPattern(handle));
end;

procedure TXLConditionalFormat.SetPatternForegroundColor(const value: Color);
begin
  xlConditionalFormatSetPatternForegroundColor(handle, Integer(value));
end;

function TXLConditionalFormat.GetPatternForegroundColor: Color;
begin
  Result := LibXL.Color(xlConditionalFormatPatternForegroundColor(handle));
end;

procedure TXLConditionalFormat.SetPatternBackgroundColor(const value: Color);
begin
  xlConditionalFormatSetPatternBackgroundColor(handle, Integer(value));
end;

function TXLConditionalFormat.GetPatternBackgroundColor: Color;
begin
  Result := LibXL.Color(xlConditionalFormatPatternBackgroundColor(handle));
end;

//////////////////////////////////////////////////////////

constructor TXLSheet.Create(handle: SheetHandle; book: BookHandle);
begin
  inherited Create;
  Self.book := book;
  Self.handle := handle;
end;

destructor TXLSheet.Destroy;
var
  i: Integer;
begin
  for i := 0 to High(richStrings) do richStrings[i].Free;
  for i := 0 to High(formats) do formats[i].Free;
  for i := 0 to High(formControls) do formControls[i].Free;
  if xlAutoFilter <> nil then xlAutoFilter.Free;
  for i := 0 to High(tables) do tables[i].Free;
  inherited Destroy;
end;

function TXLSheet.errorMessage: WideString;
begin
  Result := WideString(AnsiString(xlBookErrorMessage(book)));
end;

function TXLSheet.getCellType(row, col: Integer): CellType;
begin
  Result := CellType(xlSheetCellType(handle, row, col));
end;

function TXLSheet.cellFormat(row, col: Integer): TXLFormat;
begin
  Result := TXLFormat.Create(xlSheetCellFormat(handle, row, col), book);
  xlAddFormat(formats, Result);
end;

procedure TXLSheet.setCellFormat(row, col: Integer; format: TXLFormat);
begin
  xlSheetSetCellFormat(handle, row, col, format.handle);
end;

function TXLSheet.isFormula(row, col: Integer): Boolean;
begin
  Result := xlSheetIsFormula(handle, row, col) > 0;
end;

function TXLSheet.readStr(row, col: Integer): WideString;
var
  format: FormatHandle;
  s: PWideChar;
begin
  s := xlSheetReadStr(handle, row, col, @format);
  if s <> nil then
    Result := WideString(s)
  else
    Result := '';
end;

function TXLSheet.readStr(row, col: Integer; var format: TXLFormat): WideString;
var
  fmtHandle: FormatHandle;
  s: PWideChar;
begin
  s := xlSheetReadStr(handle, row, col, @fmtHandle);
  if s <> nil then
  begin
    if fmtHandle <> nil then
    begin
      format := TXLFormat.Create(fmtHandle, book);
      xlAddFormat(formats, format);
    end
    else
      format := nil;
    Result := WideString(s)
  end
  else
    Result := '';
end;

function TXLSheet.writeStr(row, col: Integer; value: PWideChar): Boolean;
begin
  Result := xlSheetWriteStr(handle, row, col, value, nil) > 0;
end;

function TXLSheet.writeStr(row, col: Integer; value: PWideChar; format: TXLFormat): Boolean;
begin
  Result := xlSheetWriteStr(handle, row, col, value, format.handle) > 0;
end;

function TXLSheet.readRichStr(row, col: Integer): TXLRichString;
var
  richString: RichStringHandle;
  format: FormatHandle;
begin
  richString := xlSheetReadRichStr(handle, row, col, @format);
  if richString <> nil then
  begin
    Result := TXLRichString.Create(richString, book);
    xlAddRichString(richStrings, Result);
  end
  else
    Result := nil;
end;

function TXLSheet.readRichStr(row, col: Integer; var format: TXLFormat): TXLRichString;
var
  richString: RichStringHandle;
begin
  richString := xlSheetReadRichStr(handle, row, col, @format.handle);
  if richString <> nil then
  begin
    Result := TXLRichString.Create(richString, book);
    xlAddRichString(richStrings, Result);
  end
  else
    Result := nil;
end;

function TXLSheet.writeRichStr(row, col: Integer; value: TXLRichString): Boolean;
begin
  Result := xlSheetWriteRichStr(handle, row, col, value.handle, nil) > 0;
end;

function TXLSheet.writeRichStr(row, col: Integer; value: TXLRichString; format: TXLFormat): Boolean;
begin
  Result := xlSheetWriteRichStr(handle, row, col, value.handle, format.handle) > 0;
end;

function TXLSheet.readNum(row, col: Integer): Double;
var
  format: FormatHandle;
begin
  Result := xlSheetReadNum(handle, row, col, @format);
end;

function TXLSheet.readNum(row, col: Integer; var format: TXLFormat): Double;
var
  fmtHandle: FormatHandle;
begin
  Result := xlSheetReadNum(handle, row, col, @fmtHandle);
  if fmtHandle <> nil then
  begin
    format := TXLFormat.Create(fmtHandle, book);
    xlAddFormat(formats, format);
  end
  else
    format := nil;
end;

function TXLSheet.writeNum(row, col: Integer; value: Double): Boolean;
begin
  Result := xlSheetWriteNum(handle, row, col, value, nil) > 0;
end;

function TXLSheet.writeNum(row, col: Integer; value: Double; format: TXLFormat): Boolean;
var
  fmtHandle: FormatHandle;
begin
  if format <> nil then
    fmtHandle := format.handle
  else
    fmtHandle := nil;
  Result := xlSheetWriteNum(handle, row, col, value, fmtHandle) > 0;
end;

function TXLSheet.readBool(row, col: Integer): Boolean;
var
  format: FormatHandle;
begin
  Result := xlSheetReadBool(handle, row, col, @format) > 0;
end;

function TXLSheet.readBool(row, col: Integer; var format: TXLFormat): Boolean;
var
  fmtHandle: FormatHandle;
begin
  Result := xlSheetReadBool(handle, row, col, @fmtHandle) > 0;
  if fmtHandle <> nil then
  begin
    format := TXLFormat.Create(fmtHandle, book);
    xlAddFormat(formats, format);
  end
  else
    format := nil;
end;

function TXLSheet.writeBool(row, col: Integer; value: Boolean): Boolean;
begin
  Result := xlSheetWriteBool(handle, row, col, Integer(value), nil) > 0;
end;

function TXLSheet.writeBool(row, col: Integer; value: Boolean; format: TXLFormat): Boolean;
begin
  Result := xlSheetWriteBool(handle, row, col, Integer(value), format.handle) > 0;
end;

function TXLSheet.readBlank(row, col: Integer; var format: TXLFormat): Boolean;
var
  fmtHandle: FormatHandle;
begin
  Result := xlSheetReadBlank(handle, row, col, @fmtHandle) > 0;
  if fmtHandle <> nil then
  begin
    format := TXLFormat.Create(fmtHandle, book);
    xlAddFormat(formats, format);
  end
  else
    format := nil;
end;

function TXLSheet.writeBlank(row, col: Integer; format: TXLFormat): Boolean;
begin
  Result := xlSheetWriteBlank(handle, row, col, format.handle) > 0;
end;

function TXLSheet.readFormula(row, col: Integer): WideString;
var
  format: FormatHandle;
  s: PWideChar;
begin
  s := xlSheetReadFormula(handle, row, col, @format);
  if s <> nil then
    Result := WideString(s)
  else
    Result := '';
end;

function TXLSheet.readFormula(row, col: Integer; var format: TXLFormat): WideString;
var
  fmtHandle: FormatHandle;
  s: PWideChar;
begin
  s := xlSheetReadFormula(handle, row, col, @fmtHandle);
  if s <> nil then
  begin
    if fmtHandle <> nil then
    begin
      format := TXLFormat.Create(fmtHandle, book);
      xlAddFormat(formats, format);
    end
    else
      format := nil;
    Result := WideString(s);
  end
  else
    Result := '';
end;

function TXLSheet.writeFormula(row, col: Integer; value: PWideChar): Boolean;
begin
  Result := xlSheetWriteFormula(handle, row, col, value, nil) > 0;
end;

function TXLSheet.writeFormula(row, col: Integer; value: PWideChar; format: TXLFormat): Boolean;
begin
  Result := xlSheetWriteFormula(handle, row, col, value, format.handle) > 0;
end;

function TXLSheet.writeFormulaNum(row, col: Integer; expr: PWideChar; value: Double): Boolean;
begin
  Result := xlSheetWriteFormulaNum(handle, row, col, expr, value, nil) > 0;
end;

function TXLSheet.writeFormulaNum(row, col: Integer; expr: PWideChar; value: Double; format: TXLFormat): Boolean;
begin
  Result := xlSheetWriteFormulaNum(handle, row, col, expr, value, format.handle) > 0;
end;

function TXLSheet.writeFormulaStr(row, col: Integer; expr, value: PWideChar): Boolean;
begin
  Result := xlSheetWriteFormulaStr(handle, row, col, expr, value, nil) > 0;
end;

function TXLSheet.writeFormulaStr(row, col: Integer; expr, value: PWideChar; format: TXLFormat): Boolean;
begin
  Result := xlSheetWriteFormulaStr(handle, row, col, expr, value, format.handle) > 0;
end;

function TXLSheet.writeFormulaBool(row, col: Integer; expr: PWideChar; value: Boolean): Boolean;
begin
  Result := xlSheetWriteFormulaBool(handle, row, col, expr, Integer(value), nil) > 0;
end;

function TXLSheet.writeFormulaBool(row, col: Integer; expr: PWideChar; value: Boolean; format: TXLFormat): Boolean;
begin
  Result := xlSheetWriteFormulaBool(handle, row, col, expr, Integer(value), format.handle) > 0;
end;

function TXLSheet.readComment(row, col: Integer): WideString;
var
  s: PWideChar;
begin
  s := xlSheetReadComment(handle, row, col);
  if s <> nil then
    Result := WideString(s)
  else
    Result := '';
end;

procedure TXLSheet.writeComment(row, col: Integer; value, author: PWideChar; width, height: Integer);
begin
  xlSheetWriteComment(handle, row, col, value, author, width, height);
end;

procedure TXLSheet.removeComment(row, col: Integer);
begin
  xlSheetRemoveComment(handle, row, col);
end;

function TXLSheet.isDate(row, col: Integer): Boolean;
begin
  Result := xlSheetIsDate(handle, row, col) > 0;
end;

function TXLSheet.isRichStr(row, col: Integer): Boolean;
begin
  Result := xlSheetIsRichStr(handle, row, col) > 0;
end;

function TXLSheet.readError(row, col: Integer): ErrorType;
begin
  Result := ErrorType(xlSheetReadError(handle, row, col));
end;

procedure TXLSheet.writeError(row, col: Integer; error: ErrorType);
begin
  xlSheetWriteError(handle, row, col, Integer(error), nil);
end;

procedure TXLSheet.writeError(row, col: Integer; error: ErrorType; format: TXLFormat);
begin
  xlSheetWriteError(handle, row, col, Integer(error), format.handle);
end;

function TXLSheet.colWidth(col: Integer): Double;
begin
  Result := xlSheetColWidth(handle, col);
end;

function TXLSheet.rowHeight(row: Integer): Double;
begin
  Result := xlSheetRowHeight(handle, row);
end;

function TXLSheet.colWidthPx(col: Integer): Integer;
begin
  Result := xlSheetColWidthPx(handle, col);
end;

function TXLSheet.rowHeightPx(row: Integer): Integer;
begin
  Result := xlSheetRowHeightPx(handle, row);
end;

function TXLSheet.colFormat(col: Integer): TXLFormat;
begin
  Result := TXLFormat(xlSheetColFormat(handle, col));
end;

function TXLSheet.rowFormat(row: Integer): TXLFormat;
begin
  Result := TXLFormat(xlSheetRowFormat(handle, row));
end;

function TXLSheet.setCol(col: Integer; width: Double; format: TXLFormat): Boolean;
begin
  Result := setCol(col, col, width, format);
end;

function TXLSheet.setCol(colFirst, colLast: Integer; width: Double): Boolean;
begin
  Result := xlSheetSetCol(handle, colFirst, colLast, width, nil, 0) > 0;
end;

function TXLSheet.setCol(col: Integer; width: Double): Boolean;
begin
  Result := setCol(col, col, width);
end;

function TXLSheet.setCol(colFirst, colLast: Integer; width: Double; format: TXLFormat; hid: Boolean): Boolean;
var
  fmtHandle: FormatHandle;
begin
  if format <> nil then
    fmtHandle := format.handle
  else
    fmtHandle := nil;
  Result := xlSheetSetCol(handle, colFirst, colLast, width, fmtHandle, Integer(hid)) > 0;
end;

function TXLSheet.setCol(col: Integer; width: Double; format: TXLFormat; hid: Boolean): Boolean;
begin
  Result := setCol(col, col, width, format, hid);
end;

function TXLSheet.setCol(colFirst, colLast: Integer; width: Double; format: TXLFormat): Boolean;
begin
  Result := setCol(colFirst, colLast, width, format, False);
end;

function TXLSheet.setColPx(col, widthPx: Integer): Boolean;
begin
  Result := setColPx(col, col, widthPx);
end;

function TXLSheet.setColPx(colFirst, colLast, widthPx: Integer): Boolean;
begin
  Result := xlSheetSetColPx(handle, colFirst, colLast, widthPx, nil, 0) > 0;
end;

function TXLSheet.setColPx(col, widthPx: Integer; format: TXLFormat): Boolean;
begin
  Result := setColPx(col, col, widthPx, format);
end;

function TXLSheet.setColPx(colFirst, colLast, widthPx: Integer; format: TXLFormat): Boolean;
begin
  Result := setColPx(colFirst, colLast, widthPx, format, False);
end;

function TXLSheet.setColPx(col, widthPx: Integer; format: TXLFormat; hid: Boolean): Boolean;
begin
  Result := setColPx(col, col, widthPx, format, hid);
end;

function TXLSheet.setColPx(colFirst, colLast, widthPx: Integer; format: TXLFormat; hid: Boolean): Boolean;
var
  fmtHandle: FormatHandle;
begin
  if format <> nil then
    fmtHandle := format.handle
  else
    fmtHandle := nil;
  Result := xlSheetSetColPx(handle, colFirst, colLast, widthPx, fmtHandle, Integer(hid)) > 0;
end;

function TXLSheet.setRow(row: Integer; height: Double): Boolean;
begin
  Result := xlSheetSetRow(handle, row, height, nil, 0) > 0;
end;

function TXLSheet.setRow(row: Integer; height: Double; format: TXLFormat): Boolean;
begin
  Result := xlSheetSetRow(handle, row, height, format.handle, 0) > 0;
end;

function TXLSheet.setRow(row: Integer; height: Double; format: TXLFormat; hid: Boolean): Boolean;
var
  fmtHandle: FormatHandle;
begin
  if format <> nil then
    fmtHandle := format.handle
  else
    fmtHandle := nil;
  Result := xlSheetSetRow(handle, row, height, fmtHandle, Integer(hid)) > 0;
end;

function TXLSheet.setRowPx(row, heightPx: Integer): Boolean;
begin
  Result := xlSheetSetRowPx(handle, row, heightPx, nil, 0) > 0;
end;

function TXLSheet.setRowPx(row, heightPx: Integer; format: TXLFormat): Boolean;
begin
  Result := xlSheetSetRowPx(handle, row, heightPx, format.handle, 0) > 0;
end;

function TXLSheet.setRowPx(row, heightPx: Integer; format: TXLFormat; hid: Boolean): Boolean;
var
  fmtHandle: FormatHandle;
begin
  if format <> nil then
    fmtHandle := format.handle
  else
    fmtHandle := nil;
  Result := xlSheetSetRowPx(handle, row, heightPx, fmtHandle, Integer(hid)) > 0;
end;

function TXLSheet.rowHidden(row: Integer): Boolean;
begin
  Result := xlSheetRowHidden(handle, row) > 0;
end;

function TXLSheet.setRowHidden(row: Integer; hid: Boolean): Boolean;
begin
  Result := xlSheetSetRowHidden(handle, row, Integer(hid)) > 0;
end;

function TXLSheet.colHidden(col: Integer): Boolean;
begin
  Result := xlSheetColHidden(handle, col) > 0;
end;

function TXLSheet.setColHidden(col: Integer; hid: Boolean): Boolean;
begin
  Result := xlSheetSetColHidden(handle, col, Integer(hid)) > 0;
end;

function TXLSheet.defaultRowHeight: Double;
begin
  Result := xlSheetDefaultRowHeight(handle);
end;

procedure TXLSheet.setDefaultRowHeight(height: Double);
begin
  xlSheetSetDefaultRowHeight(handle, height);
end;

function TXLSheet.delMerge(row, col: Integer): Boolean;
begin
  Result := xlSheetDelMerge(handle, row, col) > 0;
end;

function TXLSheet.getMerge(row, col: Integer; var rowFirst, rowLast, colFirst, colLast: Integer): Boolean;
begin
  Result := xlSheetGetMerge(handle, row, col, @rowFirst, @rowLast, @colFirst, @colLast) > 0;
end;

function TXLSheet.setMerge(rowFirst, rowLast, colFirst, colLast: Integer): Boolean;
begin
  Result := xlSheetSetMerge(handle, rowFirst, rowLast, colFirst, colLast) > 0;
end;

function TXLSheet.mergeSize: Integer;
begin
  Result := xlSheetMergeSize(handle);
end;

function TXLSheet.merge(index: Integer; var rowFirst, rowLast, colFirst, colLast: Integer): Boolean;
begin
  Result := xlSheetMerge(handle, index, @rowFirst, @rowLast, @colFirst, @colLast) > 0;
end;

function TXLSheet.delMergeByIndex(index: Integer): Boolean;
begin
  Result := xlSheetDelMergeByIndex(handle, index) > 0;
end;

function TXLSheet.pictureSize: Integer;
begin
  Result := xlSheetPictureSize(handle);
end;

function TXLSheet.getPicture(index: Integer): Integer;
var
  rowTop, colLeft, rowBottom, colRight, width, height, offset_x, offset_y: Integer;
begin
  Result := xlSheetGetPicture(handle, index, @rowTop, @colLeft, @rowBottom, @colRight, @width, @height, @offset_x, @offset_y);
end;

function TXLSheet.getPicture(index: Integer; var rowTop, colLeft, rowBottom, colRight: Integer): Integer;
var
  width, height, offset_x, offset_y: Integer;
begin
  Result := xlSheetGetPicture(handle, index, @rowTop, @colLeft, @rowBottom, @colRight, @width, @height, @offset_x, @offset_y);
end;

function TXLSheet.getPicture(index: Integer; var rowTop, colLeft, rowBottom, colRight, width, height: Integer): Integer;
var
  offset_x, offset_y: Integer;
begin
  Result := xlSheetGetPicture(handle, index, @rowTop, @colLeft, @rowBottom, @colRight, @width, @height, @offset_x, @offset_y);
end;

function TXLSheet.getPicture(index: Integer; var rowTop, colLeft, rowBottom, colRight, width, height, offset_x, offset_y: Integer): Integer;
begin
  Result := xlSheetGetPicture(handle, index, @rowTop, @colLeft, @rowBottom, @colRight, @width, @height, @offset_x, @offset_y);
end;

function TXLSheet.delHorPageBreak(row: Integer): Boolean;
begin
  Result := xlSheetSetHorPageBreak(handle, row, 0) > 0;
end;

function TXLSheet.delVerPageBreak(col: Integer): Boolean;
begin
  Result := xlSheetSetVerPageBreak(handle, col, 0) > 0;
end;

function TXLSheet.setHorPageBreak(row: Integer): Boolean;
begin
  Result := xlSheetSetHorPageBreak(handle, row, 1) > 0;
end;

function TXLSheet.setVerPageBreak(col: Integer): Boolean;
begin
  Result := xlSheetSetVerPageBreak(handle, col, 1) > 0;
end;

procedure TXLSheet.setPicture2(row, col, pictureId, width, height, offset_x, offset_y: Integer; pos: Position);
begin
  xlSheetSetPicture2(handle, row, col, pictureId, width, height, offset_x, offset_y, Integer(pos));
end;

procedure TXLSheet.setPicture2(row, col, pictureId, width, height: Integer);
begin
  xlSheetSetPicture2(handle, row, col, pictureId, width, height, 0, 0, Integer(POSITION_MOVE_AND_SIZE));
end;

procedure TXLSheet.setPicture(row, col, pictureId: Integer; scale: Double);
begin
  xlSheetSetPicture(handle, row, col, pictureId, scale, 0, 0, Integer(POSITION_MOVE_AND_SIZE));
end;

procedure TXLSheet.setPicture(row, col, pictureId: Integer);
begin
  setPicture(row, col, pictureId, 1);
end;

function TXLSheet.removePictureByIndex(index: Integer): Boolean;
begin
  Result := xlSheetRemovePictureByIndex(handle, index) > 0;
end;

function TXLSheet.removePicture(row, col: Integer): Boolean;
begin
  Result := xlSheetRemovePicture(handle, row, col) > 0;
end;

function TXLSheet.getHorPageBreak(index: Integer): Integer;
begin
  Result := xlSheetGetHorPageBreak(handle, index);
end;

function TXLSheet.getHorPageBreakSize: Integer;
begin
  Result := xlSheetGetHorPageBreakSize(handle);
end;

function TXLSheet.getVerPageBreak(index: Integer): Integer;
begin
  Result := xlSheetGetVerPageBreak(handle, index);
end;

function TXLSheet.getVerPageBreakSize: Integer;
begin
  Result := xlSheetGetVerPageBreakSize(handle);
end;

procedure TXLSheet.split(row, col: Integer);
begin
  xlSheetSplit(handle, row, col);
end;

function TXLSheet.splitInfo(var row, col: Integer): Boolean;
begin
  Result := xlSheetSplitInfo(handle, @row, @col) > 0;
end;

function TXLSheet.groupCols(colFirst, colLast: Integer; collapsed: Boolean): Boolean;
begin
  Result := xlSheetGroupCols(handle, colFirst, colLast, Integer(collapsed)) > 0;
end;

function TXLSheet.groupRows(rowFirst, rowLast: Integer; collapsed: Boolean): Boolean;
begin
  Result := xlSheetGroupRows(handle, rowFirst, rowLast, Integer(collapsed)) > 0;
end;

function TXLSheet.clear(rowFirst, rowLast, colFirst, colLast: Integer): Boolean;
begin
  Result := xlSheetClear(handle, rowFirst, rowLast, colFirst, colLast) > 0;
end;

function TXLSheet.insertCol(colFirst, colLast: Integer): Boolean;
begin
  Result := xlSheetInsertCol(handle, colFirst, colLast) > 0;
end;

function TXLSheet.insertRow(rowFirst, rowLast: Integer): Boolean;
begin
  Result := xlSheetInsertRow(handle, rowFirst, rowLast) > 0;
end;

function TXLSheet.removeCol(colFirst, colLast: Integer): Boolean;
begin
  Result := xlSheetRemoveCol(handle, colFirst, colLast) > 0;
end;

function TXLSheet.removeRow(rowFirst, rowLast: Integer): Boolean;
begin
  Result := xlSheetRemoveRow(handle, rowFirst, rowLast) > 0;
end;

function TXLSheet.copyCell(rowSrc, colSrc, rowDst, colDst: Integer): Boolean;
begin
  Result := xlSheetCopyCell(handle, rowSrc, colSrc, rowDst, colDst) > 0;
end;

function TXLSheet.printRepeatRows(var rowFirst, rowLast: Integer): Boolean;
begin
  Result := xlSheetPrintRepeatRows(handle, @rowFirst, @rowLast) > 0;
end;

procedure TXLSheet.setPrintRepeatRows(rowFirst, rowLast: Integer);
begin
  xlSheetSetPrintRepeatRows(handle, rowFirst, rowLast);
end;

function TXLSheet.printRepeatCols(var colFirst, colLast: Integer): Boolean;
begin
  Result := xlSheetPrintRepeatCols(handle, @colFirst, @colLast) > 0;
end;

procedure TXLSheet.setPrintRepeatCols(colFirst, colLast: Integer);
begin
  xlSheetSetPrintRepeatCols(handle, colFirst, colLast);
end;

function TXLSheet.printArea(var rowFirst, rowLast, colFirst, colLast: Integer): Boolean;
begin
  Result := xlSheetPrintArea(handle, @rowFirst, @rowLast, @colFirst, @colLast) > 0;
end;

procedure TXLSheet.setPrintArea(rowFirst, rowLast, colFirst, colLast: Integer);
begin
  xlSheetSetPrintArea(handle, rowFirst, rowLast, colFirst, colLast);
end;

procedure TXLSheet.clearPrintRepeats;
begin
  xlSheetClearPrintRepeats(handle);
end;

procedure TXLSheet.clearPrintArea;
begin
  xlSheetClearPrintArea(handle);
end;

function TXLSheet.getNamedRange(const _name: PWideChar; var rowFirst, rowLast, colFirst, colLast: Integer): Boolean;
var
  hid: Integer;
begin
  Result := xlSheetGetNamedRange(handle, _name, @rowFirst, @rowLast, @colFirst, @colLast, Integer(SCOPE_UNDEFINED), @hid) > 0;
end;

function TXLSheet.getNamedRange(const _name: PWideChar; var rowFirst, rowLast, colFirst, colLast: Integer; scopeId: Integer): Boolean;
var
  hid: Integer;
begin
  Result := xlSheetGetNamedRange(handle, _name, @rowFirst, @rowLast, @colFirst, @colLast, scopeId, @hid) > 0;
end;

function TXLSheet.getNamedRange(const _name: PWideChar; var rowFirst, rowLast, colFirst, colLast: Integer; scopeId: Integer; var hid: Boolean): Boolean;
var
  iHid: Integer;
begin
  Result := xlSheetGetNamedRange(handle, _name, @rowFirst, @rowLast, @colFirst, @colLast, scopeId, @iHid) > 0;
  hid := iHid > 0;
end;

function TXLSheet.setNamedRange(const _name: PWideChar; rowFirst, rowLast, colFirst, colLast: Integer): Boolean;
begin
  Result := xlSheetSetNamedRange(handle, _name, rowFirst, rowLast, colFirst, colLast, Integer(SCOPE_UNDEFINED)) > 0;
end;

function TXLSheet.setNamedRange(const _name: PWideChar; rowFirst, rowLast, colFirst, colLast, scopeId: Integer): Boolean;
begin
  Result := xlSheetSetNamedRange(handle, _name, rowFirst, rowLast, colFirst, colLast, scopeId) > 0;
end;

function TXLSheet.delNamedRange(const _name: PWideChar): Boolean;
begin
  Result := xlSheetDelNamedRange(handle, _name, Integer(SCOPE_UNDEFINED)) > 0;
end;

function TXLSheet.delNamedRange(const _name: PWideChar; scopeId: Integer): Boolean;
begin
  Result := xlSheetDelNamedRange(handle, _name, scopeId) > 0;
end;

function TXLSheet.namedRangeSize: Integer;
begin
  Result := xlSheetNamedRangeSize(handle);
end;

function TXLSheet.namedRange(index: Integer; var rowFirst, rowLast, colFirst, colLast: Integer): WideString;
var
  scopeId: Integer;
  hid: Integer;
begin
  Result := xlSheetNamedRange(handle, index, @rowFirst, @rowLast, @colFirst, @colLast, @scopeId, @hid);
end;

function TXLSheet.namedRange(index: Integer; var rowFirst, rowLast, colFirst, colLast, scopeId: Integer): WideString;
var
  hid: Integer;
begin
  Result := xlSheetNamedRange(handle, index, @rowFirst, @rowLast, @colFirst, @colLast, @scopeId, @hid);
end;

function TXLSheet.namedRange(index: Integer; var rowFirst, rowLast, colFirst, colLast, scopeId: Integer; var hid: Boolean): WideString;
var
  iHid: Integer;
begin
  Result := xlSheetNamedRange(handle, index, @rowFirst, @rowLast, @colFirst, @colLast, @scopeId, @iHid);
  hid := iHid > 0;
end;

function TXLSheet.getTable(const _name: PWideChar; var rowFirst, rowLast, colFirst, colLast, headerRowCount, totalsRowCount: Integer): Boolean;
begin
  Result := xlSheetGetTable(handle, _name, @rowFirst, @rowLast, @colFirst, @colLast, @headerRowCount, @totalsRowCount) > 0;
end;

function TXLSheet.tableSize: Integer;
begin
  Result := xlSheetTableSize(handle);
end;

function TXLSheet.table(index: Integer; var rowFirst, rowLast, colFirst, colLast, headerRowCount, totalsRowCount: Integer): WideString;
begin
  Result := xlSheetTable(handle, index, @rowFirst, @rowLast, @colFirst, @colLast, @headerRowCount, @totalsRowCount);
end;

function TXLSheet.addTable(const _name: PWideChar; rowFirst, rowLast, colFirst, colLast: Integer): TXLTable;
begin
  Result := addTable(_name, rowFirst, rowLast, colFirst, colLast, False, TABLESTYLE_MEDIUM2);
end;

function TXLSheet.addTable(const _name: PWideChar; rowFirst, rowLast, colFirst, colLast: Integer; hasHeaders: Boolean): TXLTable;
begin
  Result := addTable(_name, rowFirst, rowLast, colFirst, colLast, hasHeaders, TABLESTYLE_MEDIUM2);
end;

function TXLSheet.addTable(const _name: PWideChar; rowFirst, rowLast, colFirst, colLast: Integer; hasHeaders: Boolean; tableStyle: TableStyle): TXLTable;
var
  tableH: TableHandle;
begin
  tableH := xlSheetAddTable(handle, _name, rowFirst, rowLast, colFirst, colLast, Integer(hasHeaders), Integer(tableStyle));
  if tableH <> nil then
  begin
    Result := TXLTable.Create(tableH, book);
    xlAddTable(tables, Result);
  end
  else
    Result := nil;
end;

function TXLSheet.getTableByName(const _name: PWideChar): TXLTable;
var
  tableH: TableHandle;
begin
  tableH := xlSheetGetTableByName(handle, _name);
  if tableH <> nil then
  begin
    Result := TXLTable.Create(tableH, book);
    xlAddTable(tables, Result);
  end
  else
    Result := nil;
end;

function TXLSheet.getTableByIndex(index: Integer): TXLTable;
var
  tableH: TableHandle;
begin
  tableH := xlSheetGetTableByIndex(handle, index);
  if tableH <> nil then
  begin
    Result := TXLTable.Create(tableH, book);
    xlAddTable(tables, Result);
  end
  else
    Result := nil;
end;

function TXLSheet.hyperlinkSize: Integer;
begin
  Result := xlSheetHyperlinkSize(handle);
end;

function TXLSheet.hyperlink(index: Integer; var rowFirst, rowLast, colFirst, colLast: Integer): WideString;
begin
  Result := xlSheetHyperlink(handle, index, @rowFirst, @rowLast, @colFirst, @colLast);
end;

function TXLSheet.delHyperlink(index: Integer): Boolean;
begin
  Result := xlSheetDelHyperlink(handle, index) > 0;
end;

procedure TXLSheet.addHyperlink(const hyperlnk: PWideChar; rowFirst, rowLast, colFirst, colLast: Integer);
begin
  xlSheetAddHyperlink(handle, hyperlnk, rowFirst, rowLast, colFirst, colLast);
end;

function TXLSheet.hyperlinkIndex(row, col: Integer): Integer;
begin
  Result := xlSheetHyperlinkIndex(handle, row, col);
end;

function TXLSheet.isAutoFilter: Boolean;
begin
  Result := xlSheetIsAutoFilter(handle) > 0;
end;

function TXLSheet.autoFilter: TXLAutoFilter;
var
  autoFilterH: AutoFilterHandle;
begin
  if xlAutoFilter = nil then
  begin
    autoFilterH := xlSheetAutoFilter(handle);
    if autoFilterH <> nil then
    begin
      Result := TXLAutoFilter.Create(xlSheetAutoFilter(handle), book);
      xlAutoFilter := Result
    end
    else
      Result := nil;
  end
  else
    Result := xlAutoFilter;
end;

procedure TXLSheet.applyFilter;
begin
  xlSheetApplyFilter(handle);
end;

procedure TXLSheet.applyFilter2(_autoFilter: TXLAutoFilter);
begin
  xlSheetApplyFilter2(handle, _autoFilter.handle);
end;

procedure TXLSheet.removeFilter;
begin
  xlSheetRemoveFilter(handle);
end;

procedure TXLSheet.setProtect(_protect: Boolean; const password: PWideChar);
begin
  xlSheetSetProtectEx(handle, Integer(_protect), password, Integer(PROT_DEFAULT));
end;

procedure TXLSheet.setProtect(_protect: Boolean; const password: PWideChar; const prot: EnhancedProtection);
begin
  xlSheetSetProtectEx(handle, Integer(_protect), password, Integer(prot));
end;

function TXLSheet.firstRow: Integer;
begin
  Result := xlSheetFirstRow(handle);
end;

function TXLSheet.lastRow: Integer;
begin
  Result := xlSheetLastRow(handle);
end;

function TXLSheet.firstCol: Integer;
begin
  Result := xlSheetFirstCol(handle);
end;

function TXLSheet.lastCol: Integer;
begin
  Result := xlSheetLastCol(handle);
end;

function TXLSheet.firstFilledRow: Integer;
begin
  Result := xlSheetFirstFilledRow(handle);
end;

function TXLSheet.lastFilledRow: Integer;
begin
  Result := xlSheetLastFilledRow(handle);
end;

function TXLSheet.firstFilledCol: Integer;
begin
  Result := xlSheetFirstFilledCol(handle);
end;

function TXLSheet.lastFilledCol: Integer;
begin
  Result := xlSheetLastFilledCol(handle);
end;

function TXLSheet.getPrintFit(var wPages, hPages: Integer): Boolean;
begin
  Result := xlSheetGetPrintFit(handle, @wPages, @hPages) > 0;
end;

procedure TXLSheet.setPrintFit(wPages, hPages: Integer);
begin
  xlSheetSetPrintFit(handle, wPages, hPages);
end;

function TXLSheet.GetDisplayGridlines: Boolean;
begin
  Result := (xlSheetDisplayGridlines(handle) > 0);
end;

procedure TXLSheet.SetDisplayGridlines(const value: Boolean);
begin
  xlSheetSetDisplayGridlines(handle, Integer(value));
end;

function TXLSheet.GetPrintGridlines: Boolean;
begin
  Result := (xlSheetPrintGridlines(handle) > 0);
end;

procedure TXLSheet.SetPrintGridlines(const value: Boolean);
begin
  xlSheetSetPrintGridlines(handle, Integer(value));
end;

procedure TXLSheet.SetZoom(const value: Integer);
begin
  xlSheetSetZoom(handle, value);
end;

function TXLSheet.GetZoom: Integer;
begin
  Result := xlSheetZoom(handle);
end;

function TXLSheet.GetPrintZoom: Integer;
begin
  Result := xlSheetPrintZoom(handle);
end;

procedure TXLSheet.SetPrintZoom(const value: Integer);
begin
  xlSheetSetPrintZoom(handle, value);
end;

procedure TXLSheet.SetLandscape(const value: Boolean);
begin
  xlSheetSetLandscape(handle, Integer(value));
end;

function TXLSheet.GetLandscape: Boolean;
begin
  Result := (xlSheetLandscape(handle) > 0);
end;

function TXLSheet.GetPaper: Paper;
begin
  Result := LibXL.Paper(xlSheetPaper(handle));
end;

procedure TXLSheet.SetPaper(const value: Paper);
begin
  xlSheetSetPaper(handle, Integer(value));
end;

function TXLSheet.GetHeader: WideString;
var
  s: PWideChar;
begin
  s := xlSheetHeader(handle);
  if s <> nil then
    Result := WideString(s)
  else
    Result := '';
end;

procedure TXLSheet.SetHeader(const value: WideString);
begin
  xlSheetSetHeader(handle, PWideChar(value), 0.5);
end;

function TXLSheet.GetHeaderMargin: Double;
begin
  Result := xlSheetHeaderMargin(handle);
end;

procedure TXLSheet.SetHeaderMargin(const value: Double);
begin
  xlSheetSetHeader(handle, PWideChar(Self.header), value);
end;

function TXLSheet.GetFooter: WideString;
var
  s: PWideChar;
begin
  s := xlSheetFooter(handle);
  if s <> nil then
    Result := WideString(s)
  else
    Result := '';
end;

procedure TXLSheet.SetFooter(const value: WideString);
begin
  xlSheetSetFooter(handle, PWideChar(value), 0.5);
end;

function TXLSheet.GetFooterMargin: Double;
begin
  Result := xlSheetFooterMargin(handle);
end;

procedure TXLSheet.SetFooterMargin(const value: Double);
begin
  xlSheetSetFooter(handle, PWideChar(Self.footer), value);
end;

procedure TXLSheet.SetHCenter(const value: Boolean);
begin
  xlSheetSetHCenter(handle, Integer(value));
end;

function TXLSheet.GetHCenter: Boolean;
begin
  Result := (xlSheetHCenter(handle) > 0);
end;

procedure TXLSheet.SetVCenter(const value: Boolean);
begin
  xlSheetSetVCenter(handle, Integer(value));
end;

function TXLSheet.GetVCenter: Boolean;
begin
  Result := (xlSheetVCenter(handle) > 0);
end;

procedure TXLSheet.SetMarginLeft(const value: Double);
begin
  xlSheetSetMarginLeft(handle, value);
end;

function TXLSheet.GetMarginLeft: Double;
begin
  Result := xlSheetMarginLeft(handle);
end;

procedure TXLSheet.SetMarginRight(const value: Double);
begin
  xlSheetSetMarginRight(handle, value);
end;

function TXLSheet.GetMarginRight: Double;
begin
  Result := xlSheetMarginRight(handle);
end;

procedure TXLSheet.SetMarginTop(const value: Double);
begin
  xlSheetSetMarginTop(handle, value);
end;

function TXLSheet.GetMarginTop: Double;
begin
  Result := xlSheetMarginTop(handle);
end;

procedure TXLSheet.SetMarginBottom(const value: Double);
begin
  xlSheetSetMarginBottom(handle, value);
end;

function TXLSheet.GetMarginBottom: Double;
begin
  Result := xlSheetMarginBottom(handle);
end;

function TXLSheet.GetName: WideString;
var
  s: PWideChar;
begin
  s := xlSheetName(handle);
  if s <> nil then
    Result := WideString(s)
  else
    Result := '';
end;

procedure TXLSheet.SetName(const value: WideString);
begin
  xlSheetSetName(handle, PWideChar(value));
end;

function TXLSheet.GetPrintRowCol: Boolean;
begin
  Result := (xlSheetPrintRowCol(handle) > 0);
end;

procedure TXLSheet.SetPrintRowCol(const value: Boolean);
begin
  xlSheetSetPrintRowCol(handle, Integer(value));
end;

function TXLSheet.GetProtectImpl: Boolean;
begin
  Result := (xlSheetProtect(handle) > 0);
end;

procedure TXLSheet.SetProtectImpl(const value: Boolean);
begin
  xlSheetSetProtect(handle, Integer(value));
end;

function TXLSheet.GetRightToLeft: Boolean;
begin
  Result := (xlSheetRightToLeft(handle) > 0);
end;

procedure TXLSheet.SetRightToLeft(const value: Boolean);
begin
  xlSheetSetRightToLeft(handle, Integer(value));
end;

function TXLSheet.GetHidden: SheetState;
begin
  Result := SheetState(xlSheetHidden(handle));
end;

procedure TXLSheet.SetHidden(const value: SheetState);
begin
  xlSheetSetHidden(handle, Integer(value));
end;

procedure TXLSheet.getTopLeftView(var row, col: Integer);
begin
  xlSheetGetTopLeftView(handle, @row, @col);
end;

procedure TXLSheet.setTopLeftView(row, col: Integer);
begin
  xlSheetSetTopLeftView(handle, row, col);
end;

procedure TXLSheet.setAutoFitArea(rowFirst, colFirst, rowLast, colLast: Integer);
begin
  xlSheetSetAutoFitArea(handle, rowFirst, colFirst, rowLast, colLast);
end;

function TXLSheet.GetGroupSummaryBelow: Boolean;
begin
  Result := (xlSheetGroupSummaryBelow(handle) > 0);
end;

procedure TXLSheet.SetGroupSummaryBelow(const value: Boolean);
begin
  xlSheetSetGroupSummaryBelow(handle, Integer(value));
end;

function TXLSheet.GetGroupSummaryRight: Boolean;
begin
  Result := (xlSheetGroupSummaryRight(handle) > 0);
end;

procedure TXLSheet.SetGroupSummaryRight(const value: Boolean);
begin
  xlSheetSetGroupSummaryRight(handle, Integer(value));
end;

procedure TXLSheet.addrToRowCol(const addr: PWideChar; var row, col: Integer);
var
  iRowRelative: Integer;
  iColRelative: Integer;
begin
  xlSheetAddrToRowCol(handle, addr, @row, @col, @iRowRelative, @iColRelative);
end;

procedure TXLSheet.addrToRowCol(const addr: PWideChar; var row, col: Integer; var rowRelative, colRelative: Boolean);
var
  iRowRelative, iColRelative: Integer;
begin
  xlSheetAddrToRowCol(handle, addr, @row, @col, @iRowRelative, @iColRelative);
  rowRelative := iRowRelative > 0;
  colRelative := iColRelative > 0;
end;

function TXLSheet.rowColToAddr(row, col: Integer): WideString;
var
  s: PWideChar;
begin
  s := xlSheetRowColToAddr(handle, row, col, 1, 1);
  if s <> nil then
    Result := WideString(s)
  else
    Result := '';
end;

function TXLSheet.rowColToAddr(row, col: Integer; rowRelative, colRelative: Boolean): WideString;
var
  s: PWideChar;
begin
  s := xlSheetRowColToAddr(handle, row, col, Integer(rowRelative), Integer(colRelative));
  if s <> nil then
    Result := WideString(s)
  else
    Result := '';
end;

function TXLSheet.tabColor: Color;
begin
  Result := LibXL.Color(xlSheetTabColor(handle));
end;

procedure TXLSheet.setTabColor(_color: Color);
begin
  xlSheetSetTabColor(handle, Integer(_color));
end;

function TXLSheet.getTabColor(var red, green, blue: Integer): Boolean;
begin
  Result := xlSheetGetTabRgbColor(handle, @red, @green, @blue) > 0;
end;

procedure TXLSheet.setTabColor(red, green, blue: Integer);
begin
  xlSheetSetTabRgbColor(handle, red, green, blue);
end;

function TXLSheet.addIgnoredError(rowFirst, colFirst, rowLast, colLast: Integer; iError: IgnoredError): Boolean;
begin
  Result := xlSheetAddIgnoredError(handle, rowFirst, colFirst, rowLast, colLast, Integer(iError)) > 0;
end;

function TXLSheet.setBorder(rowFirst, rowLast, colFirst, colLast: Integer; _borderStyle: BorderStyle; borderColor: Color): Boolean;
begin
  Result := xlSheetSetBorder(handle, rowFirst, rowLast, colFirst, colLast, Integer(_borderStyle), Integer(borderColor)) > 0;
end;

procedure TXLSheet.addDataValidation(vtype: DataValidationType; op: DataValidationOperator; rowFirst, rowLast, colFirst, colLast: Integer; const value: PWideChar);
begin
  xlSheetAddDataValidation(handle, Integer(vtype), Integer(op), rowFirst, rowLast, colFirst, colLast, value, nil);
end;

procedure TXLSheet.addDataValidation(vtype: DataValidationType; op: DataValidationOperator; rowFirst, rowLast, colFirst, colLast: Integer; const value1, value2: PWideChar);
begin
  xlSheetAddDataValidation(handle, Integer(vtype), Integer(op), rowFirst, rowLast, colFirst, colLast, value1, value2);
end;

procedure TXLSheet.addDataValidation(vtype: DataValidationType; op: DataValidationOperator; rowFirst, rowLast, colFirst, colLast: Integer; const value1, value2: PWideChar;
                                     allowBlank, hideDropDown, showInputMessage, showErrorMessage: Boolean; const promptTitle, prompt,
                                     errorTitle, error: PWideChar; errorStyle: DataValidationErrorStyle);
begin
  xlSheetAddDataValidationEx(handle, Integer(vtype), Integer(op), rowFirst, rowLast, colFirst, colLast, value1, value2, Integer(allowBlank), Integer(hideDropDown), Integer(showInputMessage), Integer(showErrorMessage), promptTitle, prompt, errorTitle, error, Integer(errorStyle));
end;

procedure TXLSheet.addDataValidationDouble(vtype: DataValidationType; op: DataValidationOperator; rowFirst, rowLast, colFirst, colLast: Integer; value: Double);
begin
  xlSheetAddDataValidationDouble(handle, Integer(vtype), Integer(op), rowFirst, rowLast, colFirst, colLast, value, 0);
end;

procedure TXLSheet.addDataValidationDouble(vtype: DataValidationType; op: DataValidationOperator; rowFirst, rowLast, colFirst, colLast: Integer; value1, value2: Double);
begin
  xlSheetAddDataValidationDouble(handle, Integer(vtype), Integer(op), rowFirst, rowLast, colFirst, colLast, value1, value2);
end;

procedure TXLSheet.addDataValidationDouble(vtype: DataValidationType; op: DataValidationOperator; rowFirst, rowLast, colFirst, colLast: Integer; value1, value2: Double;
                                           allowBlank, hideDropDown, showInputMessage, showErrorMessage: Boolean; const promptTitle, prompt,
                                           errorTitle, error: PWideChar; errorStyle: DataValidationErrorStyle);
begin
  xlSheetAddDataValidationDoubleEx(handle, Integer(vtype), Integer(op), rowFirst, rowLast, colFirst, colLast, value1, value2, Integer(allowBlank), Integer(hideDropDown), Integer(showInputMessage), Integer(showErrorMessage), promptTitle, prompt, errorTitle, error, Integer(errorStyle));
end;

procedure TXLSheet.removeDataValidations;
begin
  xlSheetRemoveDataValidations(handle);
end;

function TXLSheet.formControlSize: Integer;
begin
  Result := xlSheetFormControlSize(handle);
end;

function TXLSheet.formControl(index: Integer): TXLFormControl;
var
  frmControlHandle: FormControlHandle;
begin
  frmControlHandle := xlSheetFormControl(handle, index);
  if frmControlHandle <> nil then
  begin
    Result := TXLFormControl.Create(frmControlHandle);
    xlAddFormControl(formControls, Result);
  end
  else
    Result := nil;
end;

function TXLSheet.addConditionalFormatting: TXLConditionalFormatting;
var
  cFormattingHandle: ConditionalFormattingHandle;
begin
  cFormattingHandle := xlSheetAddConditionalFormatting(handle);
  if cFormattingHandle <> nil then
  begin
    Result := TXLConditionalFormatting.Create(cFormattingHandle);
    xlAddConditionalFormatting(cFormattings, Result);
  end
  else
    Result := nil;
end;

function TXLSheet.getActiveCell(var row, col: Integer): Boolean;
begin
  Result := xlSheetGetActiveCell(handle, @row, @col) > 0;
end;

procedure TXLSheet.setActiveCell(row, col: Integer);
begin
  xlSheetSetActiveCell(handle, row, col);
end;

function TXLSheet.selectionRange: WideString;
begin
  Result := WideString(xlSheetSelectionRange(handle));
end;

procedure TXLSheet.addSelectionRange(sqref: PWideChar);
begin
  xlSheetAddSelectionRange(handle, sqref);
end;

procedure TXLSheet.removeSelection;
begin
  xlSheetRemoveSelection(handle);
end;

//////////////////////////////////////////////////////////////////////////////////////////////

function TXLBook.load(filename: PWideChar): Boolean;
begin
  Result := xlBookLoad(handle, filename) > 0;
end;

function TXLBook.load(filename, tempFile: PWideChar): Boolean;
begin
  Result := xlBookLoadUsingTempFile(handle, filename, tempFile) > 0;
end;

function TXLBook.loadSheet(filename: PWideChar; sheetIndex: Integer): Boolean;
begin
  Result := xlBookLoadPartially(handle, filename, sheetIndex, -1, -1, 0) > 0;
end;

function TXLBook.loadSheet(filename: PWideChar; sheetIndex: Integer; tempFile: PWideChar): Boolean;
begin
  Result := xlBookLoadPartiallyUsingTempFile(handle, filename, sheetIndex, -1, -1, tempFile, 0) > 0;
end;

function TXLBook.loadPartially(filename: PWideChar; sheetIndex, firstRow, lastRow, keepAllSheets: Integer): Boolean;
begin
  Result := xlBookLoadPartially(handle, filename, sheetIndex, firstRow, lastRow, keepAllSheets) > 0;
end;

function TXLBook.loadPartially(filename: PWideChar; sheetIndex, firstRow, lastRow: Integer; tempFile: PWideChar; keepAllSheets: Integer): Boolean;
begin
  Result := xlBookLoadPartiallyUsingTempFile(handle, filename, sheetIndex, firstRow, lastRow, tempFile, keepAllSheets) > 0;
end;

function TXLBook.loadWithoutEmptyCells(filename: PWideChar): Boolean;
begin
  Result := xlBookLoadWithoutEmptyCells(handle, filename) > 0;
end;

function TXLBook.loadInfo(filename: PWideChar): Boolean;
begin
  Result := xlBookLoadInfo(handle, filename) > 0;
end;

function TXLBook.save(filename: PWideChar): Boolean;
begin
  Result := xlBookSave(handle, filename) > 0;
end;

function TXLBook.save(filename: PWideChar; useTempFile: Boolean): Boolean;
begin
  Result := xlBookSaveUsingTempFile(handle, filename, Integer(useTempFile)) > 0;
end;

function TXLBook.loadRaw(data: PBytes; size: Cardinal): Boolean;
begin
  Result := xlBookLoadRaw(handle, @data^[0], size) > 0;
end;

function TXLBook.loadRaw(data: PBytes; size: Cardinal; sheetIndex, firstRow, lastRow, keepAllSheets: Integer): Boolean;
begin
  Result := xlBookLoadRawPartially(handle, @data^[0], size, sheetIndex, firstRow, lastRow, keepAllSheets) > 0;
end;

function TXLBook.saveRaw(var Buffer: TBytes; var size: Cardinal): Boolean;
var
  ptr: PBytes;
  i: Integer;
  p: PByte;
begin
  Result := xlBookSaveRaw(handle, @ptr, @size) > 0;
  if Result then
  begin
    SetLength(Buffer, size);
    p := @(ptr^);
    for i := 0 to size - 1 do
    begin
      Buffer[i] := Byte(p^);
      Inc(p);
    end;
  end;
end;

procedure TXLBook.setPassword(password: PWideChar);
begin
  xlBookSetPassword(handle, password);
end;

function TXLBook.addSheet(name: PWideChar): TXLSheet;
var
  new_sheetHandle: SheetHandle;
begin
  new_sheetHandle := xlBookAddSheet(handle, name, nil);
  if new_sheetHandle <> nil then
  begin
    Result := TXLSheet.Create(new_sheetHandle, Self.handle);
    xlAddSheet(sheets, Result);
  end
  else
    Result := nil;
end;

function TXLBook.addSheet(name: PWideChar; initSheet: TXLSheet): TXLSheet;
var
  new_sheetHandle: SheetHandle;
begin
  new_sheetHandle := xlBookAddSheet(handle, name, initSheet.handle);
  if new_sheetHandle <> nil then
  begin
    Result := TXLSheet.Create(new_sheetHandle, Self.handle);
    xlAddSheet(sheets, Result);
  end
  else
    Result := nil;
end;

function TXLBook.insertSheet(index: Integer; name: PWideChar): TXLSheet;
var
  new_sheetHandle: SheetHandle;
begin
  new_sheetHandle := xlBookInsertSheet(handle, index, name, nil);
  if new_sheetHandle <> nil then
  begin
    Result := TXLSheet.Create(new_sheetHandle, Self.handle);
    xlAddSheet(sheets, Result);
  end
  else
    Result := nil;
end;

function TXLBook.insertSheet(index: Integer; name: PWideChar; initSheet: TXLSheet): TXLSheet;
var
  new_sheetHandle: SheetHandle;
begin
  new_sheetHandle := xlBookInsertSheet(handle, index, name, initSheet.handle);
  if new_sheetHandle <> nil then
  begin
    Result := TXLSheet.Create(new_sheetHandle, Self.handle);
    xlAddSheet(sheets, Result);
  end
  else
    Result := nil;
end;

function TXLBook.getSheet(index: Integer): TXLSheet;
var
  new_sheetHandle: SheetHandle;
begin
  new_sheetHandle := xlBookGetSheet(handle, index);
  if new_sheetHandle <> nil then
  begin
    Result := TXLSheet.Create(new_sheetHandle, Self.handle);
    xlAddSheet(sheets, Result);
  end
  else
    Result := nil;
end;

function TXLBook.getSheetName(index: Integer): WideString;
begin
  Result := WideString(xlBookGetSheetName(handle, index));
end;

function TXLBook.sheetType(index: Integer): SheetType;
begin
  Result := SheetType(xlBookSheetType(handle, index));
end;

function TXLBook.moveSheet(srcIndex, dstIndex: Integer): Boolean;
begin
  Result := xlBookMoveSheet(handle, srcIndex, dstIndex) > 0;
end;

function TXLBook.delSheet(index: Integer): Boolean;
begin
  Result := xlBookDelSheet(handle, index) > 0;
end;

function TXLBook.sheetCount: Integer;
begin
  Result := xlBookSheetCount(handle);
end;

function TXLBook.addFormat: TXLFormat;
var
  fmtHandle: FormatHandle;
begin
  fmtHandle := xlBookAddFormat(handle, nil);
  if fmtHandle <> nil then
  begin
    Result := TXLFormat.Create(fmtHandle, handle);
    xlAddFormat(formats, Result);
  end
  else
    Result := nil;
end;

function TXLBook.addFormat(initFormat: TXLFormat): TXLFormat;
var
  fmtHandle: FormatHandle;
begin
  fmtHandle := xlBookAddFormat(handle, initFormat.handle);
  if fmtHandle <> nil then
  begin
    Result := TXLFormat.Create(fmtHandle, handle);
    xlAddFormat(formats, Result);
  end
  else
    Result := nil;
end;

function TXLBook.addFormatFromStyle(style: CellStyle): TXLFormat;
var
  fmtHandle: FormatHandle;
begin
  fmtHandle := xlBookAddFormatFromStyle(handle, Integer(style));
  if fmtHandle <> nil then
  begin
    Result := TXLFormat.Create(fmtHandle, handle);
    xlAddFormat(formats, Result);
  end
  else
    Result := nil;
end;

function TXLBook.addFont: TXLFont;
var
  fnt: FontHandle;
begin
  fnt := xlBookAddFont(handle, nil);
  if fnt <> nil then
  begin
    Result := TXLFont.Create(fnt, handle);
    xlAddFont(fonts, Result);
  end
  else
    Result := nil;
end;

function TXLBook.addFont(initFont: TXLFont): TXLFont;
var
  fnt: FontHandle;
begin
  fnt := xlBookAddFont(handle, initFont.handle);
  if fnt <> nil then
  begin
    Result := TXLFont.Create(fnt, handle);
    xlAddFont(fonts, Result);
  end
  else
    Result := nil;
end;

function TXLBook.addRichString: TXLRichString;
var
  richString: RichStringHandle;
begin
  richString := xlBookAddRichString(handle);
  if richString <> nil then
  begin
    Result := TXLRichString.Create(richString, handle);
    xlAddRichString(richStrings, Result);
  end
  else
    Result := nil;
end;

function TXLBook.addCustomNumFormat(customNumFormat: PWideChar): Integer;
begin
  Result := xlBookAddCustomNumFormat(handle, customNumFormat);
end;

function TXLBook.customNumFormat(fmt: Integer): WideString;
var
  s: PWideChar;
begin
  s := xlBookCustomNumFormat(handle, fmt);
  if s <> nil then
    Result := WideString(s)
  else
    Result := '';
end;

function TXLBook.format(index: Integer): TXLFormat;
var
  fmtHandle: FormatHandle;
begin
  fmtHandle := xlBookFormat(handle, index);
  if fmtHandle <> nil then
  begin
    Result := TXLFormat.Create(fmtHandle, handle);
    xlAddFormat(formats, Result);
  end
  else
    Result := nil;
end;

function TXLBook.formatSize: Integer;
begin
  Result := xlBookFormatSize(handle);
end;

function TXLBook.font(index: Integer): TXLFont;
var
  fntHandle: FontHandle;
begin
  fntHandle := xlBookFont(handle, index);
  if fntHandle <> nil then
  begin
    Result := TXLFont.Create(fntHandle, handle);
    xlAddFont(fonts, Result);
  end
  else
    Result := nil;
end;

function TXLBook.fontSize: Integer;
begin
  Result := xlBookFontSize(handle);
end;

function TXLBook.addConditionalFormat: TXLConditionalFormat;
var
  fmtHandle: ConditionalFormatHandle;
begin
  fmtHandle := xlBookAddConditionalFormat(handle);
  if fmtHandle <> nil then
  begin
    Result := TXLConditionalFormat.Create(fmtHandle, handle);
    xlAddConditionalFormat(conditionalFormats, Result);
  end
  else
    Result := nil;
end;

function TXLBook.datePack(year, month, day: Integer): Double;
begin
  Result := xlBookDatePack(handle, year, month, day, 0, 0, 0, 0);
end;

function TXLBook.datePack(year, month, day, hour, min, sec: Integer): Double;
begin
  Result := xlBookDatePack(handle, year, month, day, hour, min, sec, 0);
end;

function TXLBook.datePack(year, month, day, hour, min, sec, msec: Integer): Double;
begin
  Result := xlBookDatePack(handle, year, month, day, hour, min, sec, msec);
end;

function TXLBook.dateUnpack(value: Double; var year, month, day: Integer): Boolean;
var
  hour, min, sec, msec: Integer;
begin
  Result := xlBookDateUnpack(handle, value, @year, @month, @day, @hour, @min, @sec, @msec) > 0;
end;

function TXLBook.dateUnpack(value: Double; var year, month, day, hour, min, sec: Integer): Boolean;
var
  msec: Integer;
begin
  Result := xlBookDateUnpack(handle, value, @year, @month, @day, @hour, @min, @sec, @msec) > 0;
end;

function TXLBook.dateUnpack(value: Double; var year, month, day, hour, min, sec, msec: Integer): Boolean;
begin
  Result := xlBookDateUnpack(handle, value, @year, @month, @day, @hour, @min, @sec, @msec) > 0;
end;

function TXLBook.colorPack(red, green, blue: Integer): Color;
begin
  Result := Color(xlBookColorPack(handle, red, green, blue));
end;

procedure TXLBook.colorUnpack(_color: Color; var red, green, blue: Integer);
begin
  xlBookColorUnpack(handle, Integer(_color), @red, @green, @blue);
end;

function TXLBook.activeSheet: Integer;
begin
  Result := xlBookActiveSheet(handle);
end;

procedure TXLBook.setActiveSheet(index: Integer);
begin
  xlBookSetActiveSheet(handle, index);
end;

function TXLBook.pictureSize: Integer;
begin
  Result := xlBookPictureSize(handle);
end;

function TXLBook.getPicture(index: Integer; var Buffer: TBytes; var size: Cardinal): PictureType;
var
  ptr: PBytes;
  i: Integer;
  p: PByte;
begin
  Result := PictureType(xlBookGetPicture(handle, index, @ptr, @size));
  if Result <> PICTURETYPE_ERROR then
  begin
    SetLength(Buffer, size);
    p := @(ptr^);
    for i := 0 to size - 1 do
    begin
      Buffer[i] := Byte(p^);
      Inc(p);
    end;
  end;
end;

function TXLBook.addPicture(filename: PWideChar): Integer;
begin
  Result := xlBookAddPicture(handle, filename);
end;

function TXLBook.addPicture2(data: PBytes; size: Cardinal): Integer;
begin
  Result := xlBookAddPicture2(handle, data, size);
end;

function TXLBook.addPictureAsLink(filename: PWideChar; insert: Boolean): Integer;
begin
  Result := xlBookAddPictureAsLink(handle, filename, Integer(insert));
end;

function TXLBook.defaultFont(var _fontSize: Integer): WideString;
var
  s: PWideChar;
begin
  s := xlBookDefaultFont(handle, @_fontSize);
  if s <> nil then
    Result := WideString(s)
  else
    Result := '';
end;

procedure TXLBook.setDefaultFont(fontName: PWideChar; _fontSize: Integer);
begin
  xlBookSetDefaultFont(handle, fontName, _fontSize);
end;

function TXLBook.GetRefR1C1: Boolean;
begin
  Result := (xlBookRefR1C1(handle) > 0);
end;

procedure TXLBook.SetRefR1C1(const value: Boolean);
begin
  xlBookSetRefR1C1(handle, Integer(value));
end;

function TXLBook.GetDate1904: Boolean;
begin
  Result := (xlBookIsDate1904(handle) > 0);
end;

procedure TXLBook.SetDate1904(const value: Boolean);
begin
  xlBookSetDate1904(handle, Integer(value));
end;

function TXLBook.GetTemplate: Boolean;
begin
  Result := (xlBookIsTemplate(handle) > 0);
end;

procedure TXLBook.SetTemplate(const value: Boolean);
begin
  xlBookSetTemplate(handle, Integer(value));
end;

procedure TXLBook.setKey(name, key: PWideChar);
begin
  xlBookSetKey(handle, name, key);
end;

function TXLBook.rgbMode: Boolean;
begin
  Result := Boolean(xlBookRgbMode(handle));
end;

procedure TXLBook.setRgbMode(_rgbMode: Boolean);
begin
  xlBookSetRgbMode(handle, Integer(_rgbMode));
end;

function TXLBook.calcMode: CalcModeType;
begin
  Result := CalcModeType(xlBookCalcMode(handle));
end;

procedure TXLBook.setCalcMode(_calcMode: CalcModeType);
begin
  xlBookSetCalcMode(handle, Integer(_calcMode));
end;

function TXLBook.version: Integer;
begin
  Result := xlBookVersion(handle);
end;

function TXLBook.biffVersion: Integer;
begin
  Result := xlBookBiffVersion(handle);
end;

function TXLBook.isWriteProtected: Boolean;
begin
  Result := xlBookIsWriteProtected(handle) > 0;
end;

function TXLBook.coreProperties: TXLCoreProperties;
var
  CorePropertiesH: CorePropertiesHandle;
begin
  if cProperties = nil then
  begin
    CorePropertiesH := xlBookCoreProperties(handle);
    if CorePropertiesH <> nil then
    begin
      Result := TXLCoreProperties.Create(CorePropertiesH);
      cProperties := Result;
    end
    else
      Result := nil;
  end
  else
    Result := cProperties;
end;

function TXLBook.removeVBA: Boolean;
begin
  Result := xlBookRemoveVBA(handle) > 0;
end;

function TXLBook.removePrinterSettings: Boolean;
begin
  Result := xlBookRemovePrinterSettings(handle) > 0;
end;

procedure TXLBook.removeAllPhonetics;
begin
  xlBookRemoveAllPhonetics(handle);
end;

function TXLBook.setLocale(locale: PAnsiChar): Boolean;
begin
  Result := xlBookSetLocale(handle, locale) > 0;
end;

function TXLBook.errorMessage: WideString;
begin
  Result := WideString(AnsiString(xlBookErrorMessage(handle)));
end;

procedure TXLBook.Release;
var
  i: Integer;
begin
  for i:= 0 to High(fonts) do fonts[i].Free;
  for i:= 0 to High(formats) do formats[i].Free;
  for i:= 0 to High(richStrings) do richStrings[i].Free;
  for i:= 0 to High(sheets) do sheets[i].Free;
  for i:= 0 to High(conditionalFormats) do conditionalFormats[i].Free;
  if cProperties <> nil then cProperties.Free;
  xlBookRelease(handle);
end;

destructor TXLBook.Destroy;
begin
  Release;
  inherited Destroy;
end;

constructor TBinBook.Create;
begin
  inherited Create;
  handle := xlCreateBookC;
end;

constructor TXmlBook.Create;
begin
  inherited Create;
  handle := xlCreateXMLBookC;
end;

end.
